/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.EvaluationCache;
import ai.org.apache.poi.ss.formula.IEvaluationListener;
import ai.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai.org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import ai.org.apache.poi.ss.usermodel.FormulaEvaluator;
import ai.org.apache.poi.util.Internal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class CollaboratingWorkbooksEnvironment {
    public static final CollaboratingWorkbooksEnvironment EMPTY = new CollaboratingWorkbooksEnvironment();
    private final Map<String, WorkbookEvaluator> _evaluatorsByName;
    private final WorkbookEvaluator[] _evaluators;
    private boolean _unhooked;

    private CollaboratingWorkbooksEnvironment() {
        this._evaluatorsByName = Collections.emptyMap();
        this._evaluators = new WorkbookEvaluator[0];
    }

    public static void setup(String[] stringArray, WorkbookEvaluator[] workbookEvaluatorArray) {
        int n = stringArray.length;
        if (workbookEvaluatorArray.length != n) {
            throw new IllegalArgumentException("Number of workbook names is " + n + " but number of evaluators is " + workbookEvaluatorArray.length);
        }
        if (n < 1) {
            throw new IllegalArgumentException("Must provide at least one collaborating worbook");
        }
        new CollaboratingWorkbooksEnvironment(stringArray, workbookEvaluatorArray, n);
    }

    public static void setup(Map<String, WorkbookEvaluator> map) {
        if (map.size() < 1) {
            throw new IllegalArgumentException("Must provide at least one collaborating worbook");
        }
        WorkbookEvaluator[] workbookEvaluatorArray = map.values().toArray(new WorkbookEvaluator[map.size()]);
        new CollaboratingWorkbooksEnvironment(map, workbookEvaluatorArray);
    }

    public static void setupFormulaEvaluator(Map<String, FormulaEvaluator> map) {
        HashMap<String, WorkbookEvaluator> hashMap = new HashMap<String, WorkbookEvaluator>(map.size());
        for (String string : map.keySet()) {
            FormulaEvaluator formulaEvaluator = map.get(string);
            if (formulaEvaluator instanceof WorkbookEvaluatorProvider) {
                hashMap.put(string, ((WorkbookEvaluatorProvider)((Object)formulaEvaluator))._getWorkbookEvaluator());
                continue;
            }
            throw new IllegalArgumentException("Formula Evaluator " + formulaEvaluator + " provides no WorkbookEvaluator access");
        }
        CollaboratingWorkbooksEnvironment.setup(hashMap);
    }

    private CollaboratingWorkbooksEnvironment(String[] stringArray, WorkbookEvaluator[] workbookEvaluatorArray, int n) {
        this(CollaboratingWorkbooksEnvironment.toUniqueMap(stringArray, workbookEvaluatorArray, n), workbookEvaluatorArray);
    }

    private static Map<String, WorkbookEvaluator> toUniqueMap(String[] stringArray, WorkbookEvaluator[] workbookEvaluatorArray, int n) {
        HashMap<String, WorkbookEvaluator> hashMap = new HashMap<String, WorkbookEvaluator>(n * 3 / 2);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            WorkbookEvaluator workbookEvaluator = workbookEvaluatorArray[i];
            if (hashMap.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate workbook name '" + string + "'");
            }
            hashMap.put(string, workbookEvaluator);
        }
        return hashMap;
    }

    private CollaboratingWorkbooksEnvironment(Map<String, WorkbookEvaluator> map, WorkbookEvaluator[] workbookEvaluatorArray) {
        IdentityHashMap<WorkbookEvaluator, String> identityHashMap = new IdentityHashMap<WorkbookEvaluator, String>(workbookEvaluatorArray.length);
        for (String string : map.keySet()) {
            WorkbookEvaluator workbookEvaluator = map.get(string);
            if (identityHashMap.containsKey(workbookEvaluator)) {
                String string2 = "Attempted to register same workbook under names '" + (String)identityHashMap.get(workbookEvaluator) + "' and '" + string + "'";
                throw new IllegalArgumentException(string2);
            }
            identityHashMap.put(workbookEvaluator, string);
        }
        this.unhookOldEnvironments(workbookEvaluatorArray);
        CollaboratingWorkbooksEnvironment.hookNewEnvironment(workbookEvaluatorArray, this);
        this._unhooked = false;
        this._evaluators = workbookEvaluatorArray;
        this._evaluatorsByName = map;
    }

    private static void hookNewEnvironment(WorkbookEvaluator[] workbookEvaluatorArray, CollaboratingWorkbooksEnvironment collaboratingWorkbooksEnvironment) {
        int n = workbookEvaluatorArray.length;
        IEvaluationListener iEvaluationListener = workbookEvaluatorArray[0].getEvaluationListener();
        for (int i = 0; i < n; ++i) {
            if (iEvaluationListener == workbookEvaluatorArray[i].getEvaluationListener()) continue;
            throw new RuntimeException("Workbook evaluators must all have the same evaluation listener");
        }
        EvaluationCache evaluationCache = new EvaluationCache(iEvaluationListener);
        for (int i = 0; i < n; ++i) {
            workbookEvaluatorArray[i].attachToEnvironment(collaboratingWorkbooksEnvironment, evaluationCache, i);
        }
    }

    private void unhookOldEnvironments(WorkbookEvaluator[] workbookEvaluatorArray) {
        HashSet<CollaboratingWorkbooksEnvironment> hashSet = new HashSet<CollaboratingWorkbooksEnvironment>();
        for (int i = 0; i < workbookEvaluatorArray.length; ++i) {
            hashSet.add(workbookEvaluatorArray[i].getEnvironment());
        }
        CollaboratingWorkbooksEnvironment[] collaboratingWorkbooksEnvironmentArray = new CollaboratingWorkbooksEnvironment[hashSet.size()];
        hashSet.toArray(collaboratingWorkbooksEnvironmentArray);
        for (int i = 0; i < collaboratingWorkbooksEnvironmentArray.length; ++i) {
            collaboratingWorkbooksEnvironmentArray[i].unhook();
        }
    }

    private void unhook() {
        if (this._evaluators.length < 1) {
            return;
        }
        for (int i = 0; i < this._evaluators.length; ++i) {
            this._evaluators[i].detachFromEnvironment();
        }
        this._unhooked = true;
    }

    public WorkbookEvaluator getWorkbookEvaluator(String string) throws WorkbookNotFoundException {
        if (this._unhooked) {
            throw new IllegalStateException("This environment has been unhooked");
        }
        WorkbookEvaluator workbookEvaluator = this._evaluatorsByName.get(string);
        if (workbookEvaluator == null) {
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("Could not resolve external workbook name '").append(string).append("'.");
            if (this._evaluators.length < 1) {
                stringBuffer.append(" Workbook environment has not been set up.");
            } else {
                stringBuffer.append(" The following workbook names are valid: (");
                Iterator<String> iterator = this._evaluatorsByName.keySet().iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (n++ > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("'").append(iterator.next()).append("'");
                }
                stringBuffer.append(")");
            }
            throw new WorkbookNotFoundException(stringBuffer.toString());
        }
        return workbookEvaluator;
    }

    public static final class WorkbookNotFoundException
    extends Exception {
        private static final long serialVersionUID = 8787784539811167941L;

        WorkbookNotFoundException(String string) {
            super(string);
        }
    }
}

