/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.CellCacheEntry;
import ai.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import ai.org.apache.poi.ss.formula.FormulaUsedBlankCellSet;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import java.util.HashSet;
import java.util.Set;

final class CellEvaluationFrame {
    private final FormulaCellCacheEntry _cce;
    private final Set<CellCacheEntry> _sensitiveInputCells;
    private FormulaUsedBlankCellSet _usedBlankCellGroup;

    public CellEvaluationFrame(FormulaCellCacheEntry formulaCellCacheEntry) {
        this._cce = formulaCellCacheEntry;
        this._sensitiveInputCells = new HashSet<CellCacheEntry>();
    }

    public CellCacheEntry getCCE() {
        return this._cce;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void addSensitiveInputCell(CellCacheEntry cellCacheEntry) {
        this._sensitiveInputCells.add(cellCacheEntry);
    }

    private CellCacheEntry[] getSensitiveInputCells() {
        int n = this._sensitiveInputCells.size();
        if (n < 1) {
            return CellCacheEntry.EMPTY_ARRAY;
        }
        CellCacheEntry[] cellCacheEntryArray = new CellCacheEntry[n];
        this._sensitiveInputCells.toArray(cellCacheEntryArray);
        return cellCacheEntryArray;
    }

    public void addUsedBlankCell(int n, int n2, int n3, int n4) {
        if (this._usedBlankCellGroup == null) {
            this._usedBlankCellGroup = new FormulaUsedBlankCellSet();
        }
        this._usedBlankCellGroup.addCell(n, n2, n3, n4);
    }

    public void updateFormulaResult(ValueEval valueEval) {
        this._cce.updateFormulaResult(valueEval, this.getSensitiveInputCells(), this._usedBlankCellGroup);
    }
}

