/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import ai.org.apache.poi.ss.formula.FormulaCellCacheEntrySet;
import ai.org.apache.poi.ss.formula.IEvaluationListener;
import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;

abstract class CellCacheEntry
implements IEvaluationListener.ICacheEntry {
    public static final CellCacheEntry[] EMPTY_ARRAY = new CellCacheEntry[0];
    private final FormulaCellCacheEntrySet _consumingCells = new FormulaCellCacheEntrySet();
    private ValueEval _value;

    protected CellCacheEntry() {
    }

    protected final void clearValue() {
        this._value = null;
    }

    public final boolean updateValue(ValueEval valueEval) {
        if (valueEval == null) {
            throw new IllegalArgumentException("Did not expect to update to null");
        }
        boolean bl = !CellCacheEntry.areValuesEqual(this._value, valueEval);
        this._value = valueEval;
        return bl;
    }

    public final ValueEval getValue() {
        return this._value;
    }

    private static boolean areValuesEqual(ValueEval valueEval, ValueEval valueEval2) {
        if (valueEval == null) {
            return false;
        }
        Class<?> clazz = valueEval.getClass();
        if (clazz != valueEval2.getClass()) {
            return false;
        }
        if (valueEval == BlankEval.instance) {
            return valueEval2 == valueEval;
        }
        if (clazz == NumberEval.class) {
            return ((NumberEval)valueEval).getNumberValue() == ((NumberEval)valueEval2).getNumberValue();
        }
        if (clazz == StringEval.class) {
            return ((StringEval)valueEval).getStringValue().equals(((StringEval)valueEval2).getStringValue());
        }
        if (clazz == BoolEval.class) {
            return ((BoolEval)valueEval).getBooleanValue() == ((BoolEval)valueEval2).getBooleanValue();
        }
        if (clazz == ErrorEval.class) {
            return ((ErrorEval)valueEval).getErrorCode() == ((ErrorEval)valueEval2).getErrorCode();
        }
        throw new IllegalStateException("Unexpected value class (" + clazz.getName() + ")");
    }

    public final void addConsumingCell(FormulaCellCacheEntry formulaCellCacheEntry) {
        this._consumingCells.add(formulaCellCacheEntry);
    }

    public final FormulaCellCacheEntry[] getConsumingCells() {
        return this._consumingCells.toArray();
    }

    public final void clearConsumingCell(FormulaCellCacheEntry formulaCellCacheEntry) {
        if (!this._consumingCells.remove(formulaCellCacheEntry)) {
            throw new IllegalStateException("Specified formula cell is not consumed by this cell");
        }
    }

    public final void recurseClearCachedFormulaResults(IEvaluationListener iEvaluationListener) {
        if (iEvaluationListener == null) {
            this.recurseClearCachedFormulaResults();
        } else {
            iEvaluationListener.onClearCachedValue(this);
            this.recurseClearCachedFormulaResults(iEvaluationListener, 1);
        }
    }

    protected final void recurseClearCachedFormulaResults() {
        FormulaCellCacheEntry[] formulaCellCacheEntryArray = this.getConsumingCells();
        for (int i = 0; i < formulaCellCacheEntryArray.length; ++i) {
            FormulaCellCacheEntry formulaCellCacheEntry = formulaCellCacheEntryArray[i];
            formulaCellCacheEntry.clearFormulaEntry();
            formulaCellCacheEntry.recurseClearCachedFormulaResults();
        }
    }

    protected final void recurseClearCachedFormulaResults(IEvaluationListener iEvaluationListener, int n) {
        IEvaluationListener.ICacheEntry[] iCacheEntryArray = this.getConsumingCells();
        iEvaluationListener.sortDependentCachedValues(iCacheEntryArray);
        for (int i = 0; i < iCacheEntryArray.length; ++i) {
            IEvaluationListener.ICacheEntry iCacheEntry = iCacheEntryArray[i];
            iEvaluationListener.onClearDependentCachedValue(iCacheEntry, n);
            ((FormulaCellCacheEntry)iCacheEntry).clearFormulaEntry();
            ((CellCacheEntry)iCacheEntry).recurseClearCachedFormulaResults(iEvaluationListener, n + 1);
        }
    }
}

