/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.format;

import ai.org.apache.poi.ss.format.CellFormatPart;
import ai.org.apache.poi.ss.format.CellFormatType;
import ai.org.apache.poi.ss.format.CellFormatter;
import java.util.regex.Matcher;

public class CellTextFormatter
extends CellFormatter {
    private final int[] textPos;
    private final String desc;
    static final CellFormatter SIMPLE_TEXT = new CellTextFormatter("@");

    public CellTextFormatter(String string) {
        super(string);
        final int[] nArray = new int[1];
        this.desc = CellFormatPart.parseFormat(string, CellFormatType.TEXT, new CellFormatPart.PartHandler(){

            public String handlePart(Matcher matcher, String string, CellFormatType cellFormatType, StringBuffer stringBuffer) {
                if (string.equals("@")) {
                    nArray[0] = nArray[0] + 1;
                    return "\u0000";
                }
                return null;
            }
        }).toString();
        this.textPos = new int[nArray[0]];
        int n = this.desc.length() - 1;
        for (int i = 0; i < this.textPos.length; ++i) {
            this.textPos[i] = this.desc.lastIndexOf("\u0000", n);
            n = this.textPos[i] - 1;
        }
    }

    public void formatValue(StringBuffer stringBuffer, Object object) {
        int n = stringBuffer.length();
        String string = object.toString();
        if (object instanceof Boolean) {
            string = string.toUpperCase();
        }
        stringBuffer.append(this.desc);
        for (int i = 0; i < this.textPos.length; ++i) {
            int n2 = n + this.textPos[i];
            stringBuffer.replace(n2, n2 + 1, string);
        }
    }

    public void simpleValue(StringBuffer stringBuffer, Object object) {
        SIMPLE_TEXT.formatValue(stringBuffer, object);
    }
}

