/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.format;

import java.util.HashMap;
import java.util.Map;

public abstract class CellFormatCondition {
    private static final int LT = 0;
    private static final int LE = 1;
    private static final int GT = 2;
    private static final int GE = 3;
    private static final int EQ = 4;
    private static final int NE = 5;
    private static final Map<String, Integer> TESTS = new HashMap<String, Integer>();

    public static CellFormatCondition getInstance(String string, String string2) {
        if (!TESTS.containsKey(string)) {
            throw new IllegalArgumentException("Unknown test: " + string);
        }
        int n = TESTS.get(string);
        final double d = Double.parseDouble(string2);
        switch (n) {
            case 0: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 < d;
                    }
                };
            }
            case 1: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 <= d;
                    }
                };
            }
            case 2: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 > d;
                    }
                };
            }
            case 3: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 >= d;
                    }
                };
            }
            case 4: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 == d;
                    }
                };
            }
            case 5: {
                return new CellFormatCondition(){

                    public boolean pass(double d2) {
                        return d2 != d;
                    }
                };
            }
        }
        throw new IllegalArgumentException("Cannot create for test number " + n + "(\"" + string + "\")");
    }

    public abstract boolean pass(double var1);

    static {
        TESTS.put("<", 0);
        TESTS.put("<=", 1);
        TESTS.put(">", 2);
        TESTS.put(">=", 3);
        TESTS.put("=", 4);
        TESTS.put("==", 4);
        TESTS.put("!=", 5);
        TESTS.put("<>", 5);
    }
}

