/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.storage;

import ai.org.apache.poi.hssf.OldExcelFormatException;
import ai.org.apache.poi.poifs.common.POIFSBigBlockSize;
import ai.org.apache.poi.poifs.common.POIFSConstants;
import ai.org.apache.poi.poifs.filesystem.NotOLE2FileException;
import ai.org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import ai.org.apache.poi.poifs.storage.HeaderBlockConstants;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.IOUtils;
import ai.org.apache.poi.util.IntegerField;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.LongField;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import ai.org.apache.poi.util.ShortField;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class HeaderBlock
implements HeaderBlockConstants {
    private static final POILogger _logger = POILogFactory.getLogger(HeaderBlock.class);
    private final POIFSBigBlockSize bigBlockSize;
    private int _bat_count;
    private int _property_start;
    private int _sbat_start;
    private int _sbat_count;
    private int _xbat_start;
    private int _xbat_count;
    private final byte[] _data;
    private static final byte _default_value = -1;

    public HeaderBlock(InputStream inputStream) throws IOException {
        this(HeaderBlock.readFirst512(inputStream));
        if (this.bigBlockSize.getBigBlockSize() != 512) {
            int n = this.bigBlockSize.getBigBlockSize() - 512;
            byte[] byArray = new byte[n];
            IOUtils.readFully(inputStream, byArray);
        }
    }

    public HeaderBlock(ByteBuffer byteBuffer) throws IOException {
        this(IOUtils.toByteArray(byteBuffer, 512));
    }

    private HeaderBlock(byte[] byArray) throws IOException {
        this._data = byArray;
        long l = LittleEndian.getLong(this._data, 0);
        if (l != -2226271756974174256L) {
            byte[] byArray2 = POIFSConstants.OOXML_FILE_HEADER;
            if (this._data[0] == byArray2[0] && this._data[1] == byArray2[1] && this._data[2] == byArray2[2] && this._data[3] == byArray2[3]) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. You are calling the part of POI that deals with OLE2 Office Documents. You need to call a different part of POI to process this data (eg XSSF instead of HSSF)");
            }
            if (this._data[0] == 9 && this._data[1] == 0 && this._data[2] == 4 && this._data[3] == 0 && this._data[4] == 0 && this._data[5] == 0 && (this._data[6] == 16 || this._data[6] == 32 || this._data[6] == 64) && this._data[7] == 0) {
                throw new OldExcelFormatException("The supplied data appears to be in BIFF2 format. HSSF only supports the BIFF8 format, try OldExcelExtractor");
            }
            if (this._data[0] == 9 && this._data[1] == 2 && this._data[2] == 6 && this._data[3] == 0 && this._data[4] == 0 && this._data[5] == 0 && (this._data[6] == 16 || this._data[6] == 32 || this._data[6] == 64) && this._data[7] == 0) {
                throw new OldExcelFormatException("The supplied data appears to be in BIFF3 format. HSSF only supports the BIFF8 format, try OldExcelExtractor");
            }
            if (this._data[0] == 9 && this._data[1] == 4 && this._data[2] == 6 && this._data[3] == 0 && this._data[4] == 0 && this._data[5] == 0 && ((this._data[6] == 16 || this._data[6] == 32 || this._data[6] == 64) && this._data[7] == 0 || this._data[6] == 0 && this._data[7] == 1)) {
                throw new OldExcelFormatException("The supplied data appears to be in BIFF4 format. HSSF only supports the BIFF8 format, try OldExcelExtractor");
            }
            throw new NotOLE2FileException("Invalid header signature; read " + HeaderBlock.longToHex(l) + ", expected " + HeaderBlock.longToHex(-2226271756974174256L) + " - Your file appears " + "not to be a valid OLE2 document");
        }
        if (this._data[30] == 12) {
            this.bigBlockSize = POIFSConstants.LARGER_BIG_BLOCK_SIZE_DETAILS;
        } else if (this._data[30] == 9) {
            this.bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;
        } else {
            throw new IOException("Unsupported blocksize  (2^" + this._data[30] + "). Expected 2^9 or 2^12.");
        }
        this._bat_count = new IntegerField(44, byArray).get();
        this._property_start = new IntegerField(48, this._data).get();
        this._sbat_start = new IntegerField(60, this._data).get();
        this._sbat_count = new IntegerField(64, this._data).get();
        this._xbat_start = new IntegerField(68, this._data).get();
        this._xbat_count = new IntegerField(72, this._data).get();
    }

    public HeaderBlock(POIFSBigBlockSize pOIFSBigBlockSize) {
        this.bigBlockSize = pOIFSBigBlockSize;
        this._data = new byte[512];
        Arrays.fill(this._data, (byte)-1);
        new LongField(0, -2226271756974174256L, this._data);
        new IntegerField(8, 0, this._data);
        new IntegerField(12, 0, this._data);
        new IntegerField(16, 0, this._data);
        new IntegerField(20, 0, this._data);
        new ShortField(24, 59, this._data);
        new ShortField(26, 3, this._data);
        new ShortField(28, -2, this._data);
        new ShortField(30, pOIFSBigBlockSize.getHeaderValue(), this._data);
        new IntegerField(32, 6, this._data);
        new IntegerField(36, 0, this._data);
        new IntegerField(40, 0, this._data);
        new IntegerField(52, 0, this._data);
        new IntegerField(56, 4096, this._data);
        this._bat_count = 0;
        this._sbat_count = 0;
        this._xbat_count = 0;
        this._property_start = -2;
        this._sbat_start = -2;
        this._xbat_start = -2;
    }

    private static byte[] readFirst512(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[512];
        int n = IOUtils.readFully(inputStream, byArray);
        if (n != 512) {
            throw HeaderBlock.alertShortRead(n, 512);
        }
        return byArray;
    }

    private static String longToHex(long l) {
        return new String(HexDump.longToHex(l));
    }

    private static IOException alertShortRead(int n, int n2) {
        int n3 = n < 0 ? 0 : n;
        String string = " byte" + (n3 == 1 ? "" : "s");
        return new IOException("Unable to read entire header; " + n3 + string + " read; expected " + n2 + " bytes");
    }

    public int getPropertyStart() {
        return this._property_start;
    }

    public void setPropertyStart(int n) {
        this._property_start = n;
    }

    public int getSBATStart() {
        return this._sbat_start;
    }

    public int getSBATCount() {
        return this._sbat_count;
    }

    public void setSBATStart(int n) {
        this._sbat_start = n;
    }

    public void setSBATBlockCount(int n) {
        this._sbat_count = n;
    }

    public int getBATCount() {
        return this._bat_count;
    }

    public void setBATCount(int n) {
        this._bat_count = n;
    }

    public int[] getBATArray() {
        int[] nArray = new int[Math.min(this._bat_count, 109)];
        int n = 76;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = LittleEndian.getInt(this._data, n);
            n += 4;
        }
        return nArray;
    }

    public void setBATArray(int[] nArray) {
        int n;
        int n2 = Math.min(nArray.length, 109);
        int n3 = 109 - n2;
        int n4 = 76;
        for (n = 0; n < n2; ++n) {
            LittleEndian.putInt(this._data, n4, nArray[n]);
            n4 += 4;
        }
        for (n = 0; n < n3; ++n) {
            LittleEndian.putInt(this._data, n4, -1);
            n4 += 4;
        }
    }

    public int getXBATCount() {
        return this._xbat_count;
    }

    public void setXBATCount(int n) {
        this._xbat_count = n;
    }

    public int getXBATIndex() {
        return this._xbat_start;
    }

    public void setXBATStart(int n) {
        this._xbat_start = n;
    }

    public POIFSBigBlockSize getBigBlockSize() {
        return this.bigBlockSize;
    }

    void writeData(OutputStream outputStream) throws IOException {
        new IntegerField(44, this._bat_count, this._data);
        new IntegerField(48, this._property_start, this._data);
        new IntegerField(60, this._sbat_start, this._data);
        new IntegerField(64, this._sbat_count, this._data);
        new IntegerField(68, this._xbat_start, this._data);
        new IntegerField(72, this._xbat_count, this._data);
        outputStream.write(this._data, 0, 512);
        for (int i = 512; i < this.bigBlockSize.getBigBlockSize(); ++i) {
            outputStream.write(0);
        }
    }
}

