/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.storage;

import ai.org.apache.poi.poifs.storage.BlockAllocationTableReader;
import ai.org.apache.poi.poifs.storage.BlockList;
import ai.org.apache.poi.poifs.storage.ListManagedBlock;
import java.io.IOException;

abstract class BlockListImpl
implements BlockList {
    private ListManagedBlock[] _blocks = new ListManagedBlock[0];
    private BlockAllocationTableReader _bat = null;

    protected BlockListImpl() {
    }

    protected void setBlocks(ListManagedBlock[] listManagedBlockArray) {
        this._blocks = listManagedBlockArray;
    }

    public void zap(int n) {
        if (n >= 0 && n < this._blocks.length) {
            this._blocks[n] = null;
        }
    }

    protected ListManagedBlock get(int n) {
        return this._blocks[n];
    }

    public ListManagedBlock remove(int n) throws IOException {
        ListManagedBlock listManagedBlock = null;
        try {
            listManagedBlock = this._blocks[n];
            if (listManagedBlock == null) {
                throw new IOException("block[ " + n + " ] already removed - " + "does your POIFS have circular or duplicate block references?");
            }
            this._blocks[n] = null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Cannot remove block[ " + n + " ]; out of range[ 0 - " + (this._blocks.length - 1) + " ]");
        }
        return listManagedBlock;
    }

    public ListManagedBlock[] fetchBlocks(int n, int n2) throws IOException {
        if (this._bat == null) {
            throw new IOException("Improperly initialized list: no block allocation table provided");
        }
        return this._bat.fetchBlocks(n, n2, this);
    }

    public void setBAT(BlockAllocationTableReader blockAllocationTableReader) throws IOException {
        if (this._bat != null) {
            throw new IOException("Attempt to replace existing BlockAllocationTable");
        }
        this._bat = blockAllocationTableReader;
    }

    public int blockCount() {
        return this._blocks.length;
    }

    protected int remainingBlocks() {
        int n = 0;
        for (int i = 0; i < this._blocks.length; ++i) {
            if (this._blocks[i] == null) continue;
            ++n;
        }
        return n;
    }
}

