/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.Ole10NativeException;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.LittleEndianOutputStream;
import ai.org.apache.poi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Ole10Native {
    public static final String OLE10_NATIVE = "\u0001Ole10Native";
    protected static final String ISO1 = "ISO-8859-1";
    private int totalSize;
    private short flags1 = (short)2;
    private String label;
    private String fileName;
    private short flags2 = 0;
    private short unknown1 = (short)3;
    private String command;
    private byte[] dataBuffer;
    private short flags3 = 0;
    private EncodingMode mode;

    public static Ole10Native createFromEmbeddedOleObject(POIFSFileSystem pOIFSFileSystem) throws IOException, Ole10NativeException {
        return Ole10Native.createFromEmbeddedOleObject(pOIFSFileSystem.getRoot());
    }

    public static Ole10Native createFromEmbeddedOleObject(DirectoryNode directoryNode) throws IOException, Ole10NativeException {
        DocumentEntry documentEntry = (DocumentEntry)directoryNode.getEntry(OLE10_NATIVE);
        byte[] byArray = new byte[documentEntry.getSize()];
        int n = directoryNode.createDocumentInputStream(documentEntry).read(byArray);
        assert (n == byArray.length);
        return new Ole10Native(byArray, 0);
    }

    public Ole10Native(String string, String string2, String string3, byte[] byArray) {
        this.setLabel(string);
        this.setFileName(string2);
        this.setCommand(string3);
        this.setDataBuffer(byArray);
        this.mode = EncodingMode.parsed;
    }

    public Ole10Native(byte[] byArray, int n, boolean bl) throws Ole10NativeException {
        this(byArray, n);
    }

    public Ole10Native(byte[] byArray, int n) throws Ole10NativeException {
        int n2;
        int n3 = n;
        if (byArray.length < n + 2) {
            throw new Ole10NativeException("data is too small");
        }
        this.totalSize = LittleEndian.getInt(byArray, n3);
        this.mode = EncodingMode.unparsed;
        if (LittleEndian.getShort(byArray, n3 += 4) == 2) {
            this.mode = Character.isISOControl(byArray[n3 + 2]) ? EncodingMode.compact : EncodingMode.parsed;
        }
        switch (this.mode) {
            case parsed: {
                this.flags1 = LittleEndian.getShort(byArray, n3);
                int n4 = Ole10Native.getStringLength(byArray, n3 += 2);
                this.label = StringUtil.getFromCompressedUnicode(byArray, n3, n4 - 1);
                n3 += n4;
                n4 = Ole10Native.getStringLength(byArray, n3);
                this.fileName = StringUtil.getFromCompressedUnicode(byArray, n3, n4 - 1);
                this.flags2 = LittleEndian.getShort(byArray, n3 += n4);
                this.unknown1 = LittleEndian.getShort(byArray, n3 += 2);
                n4 = LittleEndian.getInt(byArray, n3 += 2);
                this.command = StringUtil.getFromCompressedUnicode(byArray, n3 += 4, n4 - 1);
                if (this.totalSize < (n3 += n4)) {
                    throw new Ole10NativeException("Invalid Ole10Native");
                }
                n2 = LittleEndian.getInt(byArray, n3);
                if (n2 >= 0 && this.totalSize - ((n3 += 4) - 4) >= n2) break;
                throw new Ole10NativeException("Invalid Ole10Native");
            }
            case compact: {
                this.flags1 = LittleEndian.getShort(byArray, n3);
                n3 += 2;
                n2 = this.totalSize - 2;
                break;
            }
            default: {
                n2 = this.totalSize;
            }
        }
        this.dataBuffer = new byte[n2];
        System.arraycopy(byArray, n3, this.dataBuffer, 0, n2);
        n3 += n2;
    }

    private static int getStringLength(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 + n < byArray.length && byArray[n + n2] != 0) {
            ++n2;
        }
        return ++n2;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public short getFlags1() {
        return this.flags1;
    }

    public String getLabel() {
        return this.label;
    }

    public String getFileName() {
        return this.fileName;
    }

    public short getFlags2() {
        return this.flags2;
    }

    public short getUnknown1() {
        return this.unknown1;
    }

    public String getCommand() {
        return this.command;
    }

    public int getDataSize() {
        return this.dataBuffer.length;
    }

    public byte[] getDataBuffer() {
        return this.dataBuffer;
    }

    public short getFlags3() {
        return this.flags3;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(outputStream);
        switch (this.mode) {
            case parsed: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LittleEndianOutputStream littleEndianOutputStream2 = new LittleEndianOutputStream(byteArrayOutputStream);
                littleEndianOutputStream2.writeShort(this.getFlags1());
                littleEndianOutputStream2.write(this.getLabel().getBytes(ISO1));
                littleEndianOutputStream2.write(0);
                littleEndianOutputStream2.write(this.getFileName().getBytes(ISO1));
                littleEndianOutputStream2.write(0);
                littleEndianOutputStream2.writeShort(this.getFlags2());
                littleEndianOutputStream2.writeShort(this.getUnknown1());
                littleEndianOutputStream2.writeInt(this.getCommand().length() + 1);
                littleEndianOutputStream2.write(this.getCommand().getBytes(ISO1));
                littleEndianOutputStream2.write(0);
                littleEndianOutputStream2.writeInt(this.getDataSize());
                littleEndianOutputStream2.write(this.getDataBuffer());
                littleEndianOutputStream2.writeShort(this.getFlags3());
                littleEndianOutputStream2.close();
                littleEndianOutputStream.writeInt(byteArrayOutputStream.size());
                byteArrayOutputStream.writeTo(outputStream);
                break;
            }
            case compact: {
                littleEndianOutputStream.writeInt(this.getDataSize() + 2);
                littleEndianOutputStream.writeShort(this.getFlags1());
                outputStream.write(this.getDataBuffer());
                break;
            }
            default: {
                littleEndianOutputStream.writeInt(this.getDataSize());
                outputStream.write(this.getDataBuffer());
            }
        }
    }

    public void setFlags1(short s) {
        this.flags1 = s;
    }

    public void setFlags2(short s) {
        this.flags2 = s;
    }

    public void setFlags3(short s) {
        this.flags3 = s;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setUnknown1(short s) {
        this.unknown1 = s;
    }

    public void setDataBuffer(byte[] byArray) {
        this.dataBuffer = byArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EncodingMode {
        parsed,
        unparsed,
        compact;

    }
}

