/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.POIFSDocument;
import ai.org.apache.poi.poifs.storage.DataInputBlock;
import java.io.IOException;

public final class ODocumentInputStream
extends DocumentInputStream {
    private int _current_offset;
    private int _marked_offset;
    private int _document_size;
    private boolean _closed;
    private POIFSDocument _document;
    private DataInputBlock _currentBlock;

    public ODocumentInputStream(DocumentEntry documentEntry) throws IOException {
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage");
        }
        DocumentNode documentNode = (DocumentNode)documentEntry;
        if (documentNode.getDocument() == null) {
            throw new IOException("Cannot open internal document storage");
        }
        this._current_offset = 0;
        this._marked_offset = 0;
        this._document_size = documentEntry.getSize();
        this._closed = false;
        this._document = documentNode.getDocument();
        this._currentBlock = this.getDataInputBlock(0);
    }

    public ODocumentInputStream(POIFSDocument pOIFSDocument) {
        this._current_offset = 0;
        this._marked_offset = 0;
        this._document_size = pOIFSDocument.getSize();
        this._closed = false;
        this._document = pOIFSDocument;
        this._currentBlock = this.getDataInputBlock(0);
    }

    public int available() {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        return this._document_size - this._current_offset;
    }

    public void close() {
        this._closed = true;
    }

    public void mark(int n) {
        this._marked_offset = this._current_offset;
    }

    private DataInputBlock getDataInputBlock(int n) {
        return this._document.getDataInputBlock(n);
    }

    public int read() throws IOException {
        this.dieIfClosed();
        if (this.atEOD()) {
            return -1;
        }
        int n = this._currentBlock.readUByte();
        ++this._current_offset;
        if (this._currentBlock.available() < 1) {
            this._currentBlock = this.getDataInputBlock(this._current_offset);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.dieIfClosed();
        if (byArray == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("can't read past buffer boundaries");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.atEOD()) {
            return -1;
        }
        int n3 = Math.min(this.available(), n2);
        this.readFully(byArray, n, n3);
        return n3;
    }

    public void reset() {
        this._current_offset = this._marked_offset;
        this._currentBlock = this.getDataInputBlock(this._current_offset);
    }

    public long skip(long l) throws IOException {
        this.dieIfClosed();
        if (l < 0L) {
            return 0L;
        }
        int n = this._current_offset + (int)l;
        if (n < this._current_offset) {
            n = this._document_size;
        } else if (n > this._document_size) {
            n = this._document_size;
        }
        long l2 = n - this._current_offset;
        this._current_offset = n;
        this._currentBlock = this.getDataInputBlock(this._current_offset);
        return l2;
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private boolean atEOD() {
        return this._current_offset == this._document_size;
    }

    private void checkAvaliable(int n) {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        if (n > this._document_size - this._current_offset) {
            throw new RuntimeException("Buffer underrun - requested " + n + " bytes but " + (this._document_size - this._current_offset) + " was available");
        }
    }

    public byte readByte() {
        return (byte)this.readUByte();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.checkAvaliable(n2);
        int n3 = this._currentBlock.available();
        if (n3 > n2) {
            this._currentBlock.readFully(byArray, n, n2);
            this._current_offset += n2;
            return;
        }
        int n4 = n2;
        int n5 = n;
        while (n4 > 0) {
            boolean bl = n4 >= n3;
            int n6 = bl ? n3 : n4;
            this._currentBlock.readFully(byArray, n5, n6);
            n4 -= n6;
            n5 += n6;
            this._current_offset += n6;
            if (!bl) continue;
            if (this._current_offset == this._document_size) {
                if (n4 > 0) {
                    throw new IllegalStateException("reached end of document stream unexpectedly");
                }
                this._currentBlock = null;
                break;
            }
            this._currentBlock = this.getDataInputBlock(this._current_offset);
            n3 = this._currentBlock.available();
        }
    }

    public long readLong() {
        long l;
        this.checkAvaliable(8);
        int n = this._currentBlock.available();
        if (n > 8) {
            l = this._currentBlock.readLongLE();
        } else {
            DataInputBlock dataInputBlock = this.getDataInputBlock(this._current_offset + n);
            l = n == 8 ? this._currentBlock.readLongLE() : dataInputBlock.readLongLE(this._currentBlock, n);
            this._currentBlock = dataInputBlock;
        }
        this._current_offset += 8;
        return l;
    }

    public int readInt() {
        int n;
        this.checkAvaliable(4);
        int n2 = this._currentBlock.available();
        if (n2 > 4) {
            n = this._currentBlock.readIntLE();
        } else {
            DataInputBlock dataInputBlock = this.getDataInputBlock(this._current_offset + n2);
            n = n2 == 4 ? this._currentBlock.readIntLE() : dataInputBlock.readIntLE(this._currentBlock, n2);
            this._currentBlock = dataInputBlock;
        }
        this._current_offset += 4;
        return n;
    }

    public int readUShort() {
        int n;
        this.checkAvaliable(2);
        int n2 = this._currentBlock.available();
        if (n2 > 2) {
            n = this._currentBlock.readUShortLE();
        } else {
            DataInputBlock dataInputBlock = this.getDataInputBlock(this._current_offset + n2);
            n = n2 == 2 ? this._currentBlock.readUShortLE() : dataInputBlock.readUShortLE(this._currentBlock);
            this._currentBlock = dataInputBlock;
        }
        this._current_offset += 2;
        return n;
    }

    public int readUByte() {
        this.checkAvaliable(1);
        int n = this._currentBlock.readUByte();
        ++this._current_offset;
        if (this._currentBlock.available() < 1) {
            this._currentBlock = this.getDataInputBlock(this._current_offset);
        }
        return n;
    }
}

