/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.BlockStore;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NPOIFSStream
implements Iterable<ByteBuffer> {
    private BlockStore blockStore;
    private int startBlock;
    private OutputStream outStream;

    public NPOIFSStream(BlockStore blockStore, int n) {
        this.blockStore = blockStore;
        this.startBlock = n;
    }

    public NPOIFSStream(BlockStore blockStore) {
        this.blockStore = blockStore;
        this.startBlock = -2;
    }

    public int getStartBlock() {
        return this.startBlock;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.getBlockIterator();
    }

    public Iterator<ByteBuffer> getBlockIterator() {
        if (this.startBlock == -2) {
            throw new IllegalStateException("Can't read from a new stream before it has been written to");
        }
        return new StreamBlockByteBufferIterator(this.startBlock);
    }

    public void updateContents(byte[] byArray) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(byArray);
        outputStream.close();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.outStream == null) {
            this.outStream = new StreamBlockByteBuffer();
        }
        return this.outStream;
    }

    public void free() throws IOException {
        BlockStore.ChainLoopDetector chainLoopDetector = this.blockStore.getChainLoopDetector();
        this.free(chainLoopDetector);
    }

    private void free(BlockStore.ChainLoopDetector chainLoopDetector) {
        int n = this.startBlock;
        while (n != -2) {
            int n2 = n;
            chainLoopDetector.claim(n2);
            n = this.blockStore.getNextBlock(n2);
            this.blockStore.setNextBlock(n2, -1);
        }
        this.startBlock = -2;
    }

    protected class StreamBlockByteBuffer
    extends OutputStream {
        byte[] oneByte = new byte[1];
        ByteBuffer buffer;
        BlockStore.ChainLoopDetector loopDetector;
        int prevBlock;
        int nextBlock;

        protected StreamBlockByteBuffer() throws IOException {
            this.loopDetector = NPOIFSStream.this.blockStore.getChainLoopDetector();
            this.prevBlock = -2;
            this.nextBlock = NPOIFSStream.this.startBlock;
        }

        protected void createBlockIfNeeded() throws IOException {
            if (this.buffer != null && this.buffer.hasRemaining()) {
                return;
            }
            int n = this.nextBlock;
            if (n == -2) {
                n = NPOIFSStream.this.blockStore.getFreeBlock();
                this.loopDetector.claim(n);
                this.nextBlock = -2;
                if (this.prevBlock != -2) {
                    NPOIFSStream.this.blockStore.setNextBlock(this.prevBlock, n);
                }
                NPOIFSStream.this.blockStore.setNextBlock(n, -2);
                if (NPOIFSStream.this.startBlock == -2) {
                    NPOIFSStream.this.startBlock = n;
                }
            } else {
                this.loopDetector.claim(n);
                this.nextBlock = NPOIFSStream.this.blockStore.getNextBlock(n);
            }
            this.buffer = NPOIFSStream.this.blockStore.createBlockIfNeeded(n);
            this.prevBlock = n;
        }

        public void write(int n) throws IOException {
            this.oneByte[0] = (byte)(n & 0xFF);
            this.write(this.oneByte);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            do {
                this.createBlockIfNeeded();
                n3 = Math.min(this.buffer.remaining(), n2);
                this.buffer.put(byArray, n, n3);
                n += n3;
            } while ((n2 -= n3) > 0);
        }

        public void close() throws IOException {
            NPOIFSStream nPOIFSStream = new NPOIFSStream(NPOIFSStream.this.blockStore, this.nextBlock);
            nPOIFSStream.free(this.loopDetector);
            NPOIFSStream.this.blockStore.setNextBlock(this.prevBlock, -2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class StreamBlockByteBufferIterator
    implements Iterator<ByteBuffer> {
        private BlockStore.ChainLoopDetector loopDetector;
        private int nextBlock;

        protected StreamBlockByteBufferIterator(int n) {
            this.nextBlock = n;
            try {
                this.loopDetector = NPOIFSStream.this.blockStore.getChainLoopDetector();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextBlock != -2;
        }

        @Override
        public ByteBuffer next() {
            if (this.nextBlock == -2) {
                throw new IndexOutOfBoundsException("Can't read past the end of the stream");
            }
            try {
                this.loopDetector.claim(this.nextBlock);
                ByteBuffer byteBuffer = NPOIFSStream.this.blockStore.getBlockAt(this.nextBlock);
                this.nextBlock = NPOIFSStream.this.blockStore.getNextBlock(this.nextBlock);
                return byteBuffer;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

