/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.dev.POIFSViewable;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.DocumentOutputStream;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.NPOIFSStream;
import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.poifs.property.DocumentProperty;
import ai.org.apache.poi.util.HexDump;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NPOIFSDocument
implements POIFSViewable {
    private DocumentProperty _property;
    private NPOIFSFileSystem _filesystem;
    private NPOIFSStream _stream;
    private int _block_size;

    public NPOIFSDocument(DocumentNode documentNode) throws IOException {
        this((DocumentProperty)documentNode.getProperty(), ((DirectoryNode)documentNode.getParent()).getNFileSystem());
    }

    public NPOIFSDocument(DocumentProperty documentProperty, NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this._property = documentProperty;
        this._filesystem = nPOIFSFileSystem;
        if (documentProperty.getSize() < 4096) {
            this._stream = new NPOIFSStream(this._filesystem.getMiniStore(), documentProperty.getStartBlock());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new NPOIFSStream(this._filesystem, documentProperty.getStartBlock());
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
    }

    public NPOIFSDocument(String string, NPOIFSFileSystem nPOIFSFileSystem, InputStream inputStream) throws IOException {
        this._filesystem = nPOIFSFileSystem;
        int n = this.store(inputStream);
        this._property = new DocumentProperty(string, n);
        this._property.setStartBlock(this._stream.getStartBlock());
    }

    public NPOIFSDocument(String string, int n, NPOIFSFileSystem nPOIFSFileSystem, POIFSWriterListener pOIFSWriterListener) throws IOException {
        this._filesystem = nPOIFSFileSystem;
        if (n < 4096) {
            this._stream = new NPOIFSStream(nPOIFSFileSystem.getMiniStore());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new NPOIFSStream(nPOIFSFileSystem);
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
        OutputStream outputStream = this._stream.getOutputStream();
        DocumentOutputStream documentOutputStream = new DocumentOutputStream(outputStream, n);
        POIFSDocumentPath pOIFSDocumentPath = new POIFSDocumentPath(string.split("\\\\"));
        String string2 = pOIFSDocumentPath.getComponent(pOIFSDocumentPath.length() - 1);
        POIFSWriterEvent pOIFSWriterEvent = new POIFSWriterEvent(documentOutputStream, pOIFSDocumentPath, string2, n);
        pOIFSWriterListener.processPOIFSWriterEvent(pOIFSWriterEvent);
        outputStream.close();
        this._property = new DocumentProperty(string, n);
        this._property.setStartBlock(this._stream.getStartBlock());
    }

    private int store(InputStream inputStream) throws IOException {
        int n;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 4097);
        bufferedInputStream.mark(4096);
        if (bufferedInputStream.skip(4096L) < 4096L) {
            this._stream = new NPOIFSStream(this._filesystem.getMiniStore());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new NPOIFSStream(this._filesystem);
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
        bufferedInputStream.reset();
        OutputStream outputStream = this._stream.getOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            n2 += n;
        }
        outputStream.close();
        return n2;
    }

    void free() throws IOException {
        this._stream.free();
        this._property.setStartBlock(-2);
    }

    NPOIFSFileSystem getFileSystem() {
        return this._filesystem;
    }

    int getDocumentBlockSize() {
        return this._block_size;
    }

    Iterator<ByteBuffer> getBlockIterator() {
        if (this.getSize() > 0) {
            return this._stream.getBlockIterator();
        }
        List list = Collections.emptyList();
        return list.iterator();
    }

    public int getSize() {
        return this._property.getSize();
    }

    public void replaceContents(InputStream inputStream) throws IOException {
        this.free();
        int n = this.store(inputStream);
        this._property.setStartBlock(this._stream.getStartBlock());
        this._property.updateSize(n);
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    @Override
    public Object[] getViewableArray() {
        String string;
        Object[] objectArray = new Object[1];
        try {
            if (this.getSize() > 0) {
                byte[] byArray = new byte[this.getSize()];
                int n = 0;
                for (ByteBuffer byteBuffer : this._stream) {
                    int n2 = Math.min(this._block_size, byArray.length - n);
                    byteBuffer.get(byArray, n, n2);
                    n += n2;
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                HexDump.dump(byArray, 0L, byteArrayOutputStream, 0);
                string = byteArrayOutputStream.toString();
            } else {
                string = "<NO DATA>";
            }
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
        }
        objectArray[0] = string;
        return objectArray;
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return true;
    }

    @Override
    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document: \"").append(this._property.getName()).append("\"");
        stringBuffer.append(" size = ").append(this.getSize());
        return stringBuffer.toString();
    }
}

