/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai.org.apache.poi.poifs.property.DocumentProperty;
import ai.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public final class NDocumentInputStream
extends DocumentInputStream {
    private int _current_offset;
    private int _current_block_count;
    private int _marked_offset;
    private int _marked_offset_count;
    private int _document_size;
    private boolean _closed;
    private NPOIFSDocument _document;
    private Iterator<ByteBuffer> _data;
    private ByteBuffer _buffer;

    public NDocumentInputStream(DocumentEntry documentEntry) throws IOException {
        if (!(documentEntry instanceof DocumentNode)) {
            throw new IOException("Cannot open internal document storage, " + documentEntry + " not a Document Node");
        }
        this._current_offset = 0;
        this._current_block_count = 0;
        this._marked_offset = 0;
        this._marked_offset_count = 0;
        this._document_size = documentEntry.getSize();
        this._closed = false;
        DocumentNode documentNode = (DocumentNode)documentEntry;
        DocumentProperty documentProperty = (DocumentProperty)documentNode.getProperty();
        this._document = new NPOIFSDocument(documentProperty, ((DirectoryNode)documentNode.getParent()).getNFileSystem());
        this._data = this._document.getBlockIterator();
    }

    public NDocumentInputStream(NPOIFSDocument nPOIFSDocument) {
        this._current_offset = 0;
        this._current_block_count = 0;
        this._marked_offset = 0;
        this._marked_offset_count = 0;
        this._document_size = nPOIFSDocument.getSize();
        this._closed = false;
        this._document = nPOIFSDocument;
        this._data = this._document.getBlockIterator();
    }

    public int available() {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        return this._document_size - this._current_offset;
    }

    public void close() {
        this._closed = true;
    }

    public void mark(int n) {
        this._marked_offset = this._current_offset;
        this._marked_offset_count = Math.max(0, this._current_block_count - 1);
    }

    public int read() throws IOException {
        this.dieIfClosed();
        if (this.atEOD()) {
            return -1;
        }
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n >= 0) {
            if (byArray[0] < 0) {
                return byArray[0] + 256;
            }
            return byArray[0];
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.dieIfClosed();
        if (byArray == null) {
            throw new IllegalArgumentException("buffer must not be null");
        }
        if (n < 0 || n2 < 0 || byArray.length < n + n2) {
            throw new IndexOutOfBoundsException("can't read past buffer boundaries");
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.atEOD()) {
            return -1;
        }
        int n3 = Math.min(this.available(), n2);
        this.readFully(byArray, n, n3);
        return n3;
    }

    public void reset() {
        int n;
        if (this._marked_offset == 0 && this._marked_offset_count == 0) {
            this._current_block_count = this._marked_offset_count;
            this._current_offset = this._marked_offset;
            this._data = this._document.getBlockIterator();
            this._buffer = null;
            return;
        }
        this._data = this._document.getBlockIterator();
        this._current_offset = 0;
        for (n = 0; n < this._marked_offset_count; ++n) {
            this._buffer = this._data.next();
            this._current_offset += this._buffer.remaining();
        }
        this._current_block_count = this._marked_offset_count;
        if (this._current_offset != this._marked_offset) {
            this._buffer = this._data.next();
            ++this._current_block_count;
            n = this._marked_offset - this._current_offset;
            this._buffer.position(this._buffer.position() + n);
        }
        this._current_offset = this._marked_offset;
    }

    public long skip(long l) throws IOException {
        this.dieIfClosed();
        if (l < 0L) {
            return 0L;
        }
        int n = this._current_offset + (int)l;
        if (n < this._current_offset) {
            n = this._document_size;
        } else if (n > this._document_size) {
            n = this._document_size;
        }
        long l2 = n - this._current_offset;
        byte[] byArray = new byte[(int)l2];
        this.readFully(byArray);
        return l2;
    }

    private void dieIfClosed() throws IOException {
        if (this._closed) {
            throw new IOException("cannot perform requested operation on a closed stream");
        }
    }

    private boolean atEOD() {
        return this._current_offset == this._document_size;
    }

    private void checkAvaliable(int n) {
        if (this._closed) {
            throw new IllegalStateException("cannot perform requested operation on a closed stream");
        }
        if (n > this._document_size - this._current_offset) {
            throw new RuntimeException("Buffer underrun - requested " + n + " bytes but " + (this._document_size - this._current_offset) + " was available");
        }
    }

    public void readFully(byte[] byArray, int n, int n2) {
        int n3;
        this.checkAvaliable(n2);
        for (int i = 0; i < n2; i += n3) {
            if (this._buffer == null || this._buffer.remaining() == 0) {
                ++this._current_block_count;
                this._buffer = this._data.next();
            }
            n3 = Math.min(n2 - i, this._buffer.remaining());
            this._buffer.get(byArray, n + i, n3);
            this._current_offset += n3;
        }
    }

    public byte readByte() {
        return (byte)this.readUByte();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    public long readLong() {
        this.checkAvaliable(8);
        byte[] byArray = new byte[8];
        this.readFully(byArray, 0, 8);
        return LittleEndian.getLong(byArray, 0);
    }

    public short readShort() {
        this.checkAvaliable(2);
        byte[] byArray = new byte[2];
        this.readFully(byArray, 0, 2);
        return LittleEndian.getShort(byArray);
    }

    public int readInt() {
        this.checkAvaliable(4);
        byte[] byArray = new byte[4];
        this.readFully(byArray, 0, 4);
        return LittleEndian.getInt(byArray);
    }

    public int readUShort() {
        this.checkAvaliable(2);
        byte[] byArray = new byte[2];
        this.readFully(byArray, 0, 2);
        return LittleEndian.getUShort(byArray);
    }

    public int readUByte() {
        this.checkAvaliable(1);
        byte[] byArray = new byte[1];
        this.readFully(byArray, 0, 1);
        if (byArray[0] >= 0) {
            return byArray[0];
        }
        return byArray[0] + 256;
    }
}

