/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.hpsf.ClassID;
import ai.org.apache.poi.poifs.dev.POIFSViewable;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.poifs.filesystem.EntryNode;
import ai.org.apache.poi.poifs.filesystem.NPOIFSDocument;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSDocument;
import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.poifs.property.DirectoryProperty;
import ai.org.apache.poi.poifs.property.DocumentProperty;
import ai.org.apache.poi.poifs.property.Property;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryNode
extends EntryNode
implements DirectoryEntry,
POIFSViewable,
Iterable<Entry> {
    private Map<String, Entry> _byname;
    private ArrayList<Entry> _entries;
    private POIFSFileSystem _ofilesystem;
    private NPOIFSFileSystem _nfilesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty directoryProperty, POIFSFileSystem pOIFSFileSystem, DirectoryNode directoryNode) {
        this(directoryProperty, directoryNode, pOIFSFileSystem, null);
    }

    DirectoryNode(DirectoryProperty directoryProperty, NPOIFSFileSystem nPOIFSFileSystem, DirectoryNode directoryNode) {
        this(directoryProperty, directoryNode, null, nPOIFSFileSystem);
    }

    private DirectoryNode(DirectoryProperty directoryProperty, DirectoryNode directoryNode, POIFSFileSystem pOIFSFileSystem, NPOIFSFileSystem nPOIFSFileSystem) {
        super(directoryProperty, directoryNode);
        this._ofilesystem = pOIFSFileSystem;
        this._nfilesystem = nPOIFSFileSystem;
        this._path = directoryNode == null ? new POIFSDocumentPath() : new POIFSDocumentPath(directoryNode._path, new String[]{directoryProperty.getName()});
        this._byname = new HashMap<String, Entry>();
        this._entries = new ArrayList();
        Iterator<Property> iterator = directoryProperty.getChildren();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            EntryNode entryNode = null;
            if (property.isDirectory()) {
                DirectoryProperty directoryProperty2 = (DirectoryProperty)property;
                entryNode = this._ofilesystem != null ? new DirectoryNode(directoryProperty2, this._ofilesystem, this) : new DirectoryNode(directoryProperty2, this._nfilesystem, this);
            } else {
                entryNode = new DocumentNode((DocumentProperty)property, this);
            }
            this._entries.add(entryNode);
            this._byname.put(entryNode.getName(), entryNode);
        }
    }

    public POIFSDocumentPath getPath() {
        return this._path;
    }

    public POIFSFileSystem getFileSystem() {
        return this._ofilesystem;
    }

    public NPOIFSFileSystem getNFileSystem() {
        return this._nfilesystem;
    }

    public DocumentInputStream createDocumentInputStream(String string) throws IOException {
        return this.createDocumentInputStream(this.getEntry(string));
    }

    public DocumentInputStream createDocumentInputStream(Entry entry) throws IOException {
        if (!entry.isDocumentEntry()) {
            throw new IOException("Entry '" + entry.getName() + "' is not a DocumentEntry");
        }
        DocumentEntry documentEntry = (DocumentEntry)entry;
        return new DocumentInputStream(documentEntry);
    }

    DocumentEntry createDocument(POIFSDocument pOIFSDocument) throws IOException {
        DocumentProperty documentProperty = pOIFSDocument.getDocumentProperty();
        DocumentNode documentNode = new DocumentNode(documentProperty, this);
        ((DirectoryProperty)this.getProperty()).addChild(documentProperty);
        this._ofilesystem.addDocument(pOIFSDocument);
        this._entries.add(documentNode);
        this._byname.put(documentProperty.getName(), documentNode);
        return documentNode;
    }

    DocumentEntry createDocument(NPOIFSDocument nPOIFSDocument) throws IOException {
        DocumentProperty documentProperty = nPOIFSDocument.getDocumentProperty();
        DocumentNode documentNode = new DocumentNode(documentProperty, this);
        ((DirectoryProperty)this.getProperty()).addChild(documentProperty);
        this._nfilesystem.addDocument(nPOIFSDocument);
        this._entries.add(documentNode);
        this._byname.put(documentProperty.getName(), documentNode);
        return documentNode;
    }

    boolean changeName(String string, String string2) {
        boolean bl = false;
        EntryNode entryNode = (EntryNode)this._byname.get(string);
        if (entryNode != null && (bl = ((DirectoryProperty)this.getProperty()).changeName(entryNode.getProperty(), string2))) {
            this._byname.remove(string);
            this._byname.put(entryNode.getProperty().getName(), entryNode);
        }
        return bl;
    }

    boolean deleteEntry(EntryNode entryNode) {
        boolean bl = ((DirectoryProperty)this.getProperty()).deleteChild(entryNode.getProperty());
        if (bl) {
            this._entries.remove(entryNode);
            this._byname.remove(entryNode.getName());
            if (this._ofilesystem != null) {
                this._ofilesystem.remove(entryNode);
            } else {
                try {
                    this._nfilesystem.remove(entryNode);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    @Override
    public Iterator<Entry> getEntries() {
        return this._entries.iterator();
    }

    @Override
    public Set<String> getEntryNames() {
        return this._byname.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    @Override
    public int getEntryCount() {
        return this._entries.size();
    }

    @Override
    public boolean hasEntry(String string) {
        return string != null && this._byname.containsKey(string);
    }

    @Override
    public Entry getEntry(String string) throws FileNotFoundException {
        Entry entry = null;
        if (string != null) {
            entry = this._byname.get(string);
        }
        if (entry == null) {
            throw new FileNotFoundException("no such entry: \"" + string + "\", had: " + this._byname.keySet());
        }
        return entry;
    }

    @Override
    public DocumentEntry createDocument(String string, InputStream inputStream) throws IOException {
        if (this._nfilesystem != null) {
            return this.createDocument(new NPOIFSDocument(string, this._nfilesystem, inputStream));
        }
        return this.createDocument(new POIFSDocument(string, inputStream));
    }

    @Override
    public DocumentEntry createDocument(String string, int n, POIFSWriterListener pOIFSWriterListener) throws IOException {
        if (this._nfilesystem != null) {
            return this.createDocument(new NPOIFSDocument(string, n, this._nfilesystem, pOIFSWriterListener));
        }
        return this.createDocument(new POIFSDocument(string, n, this._path, pOIFSWriterListener));
    }

    @Override
    public DirectoryEntry createDirectory(String string) throws IOException {
        DirectoryNode directoryNode;
        DirectoryProperty directoryProperty = new DirectoryProperty(string);
        if (this._ofilesystem != null) {
            directoryNode = new DirectoryNode(directoryProperty, this._ofilesystem, this);
            this._ofilesystem.addDirectory(directoryProperty);
        } else {
            directoryNode = new DirectoryNode(directoryProperty, this._nfilesystem, this);
            this._nfilesystem.addDirectory(directoryProperty);
        }
        ((DirectoryProperty)this.getProperty()).addChild(directoryProperty);
        this._entries.add(directoryNode);
        this._byname.put(string, directoryNode);
        return directoryNode;
    }

    @Override
    public ClassID getStorageClsid() {
        return this.getProperty().getStorageClsid();
    }

    @Override
    public void setStorageClsid(ClassID classID) {
        this.getProperty().setStorageClsid(classID);
    }

    @Override
    public boolean isDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean isDeleteOK() {
        return this.isEmpty();
    }

    @Override
    public Object[] getViewableArray() {
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getProperty());
        Iterator<Entry> iterator = this._entries.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.iterator();
    }

    @Override
    public boolean preferArray() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return this.getName();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries();
    }
}

