/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.filesystem;

import ai.org.apache.poi.poifs.storage.BATBlock;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class BlockStore {
    protected abstract int getBlockStoreBlockSize();

    protected abstract ByteBuffer getBlockAt(int var1) throws IOException;

    protected abstract ByteBuffer createBlockIfNeeded(int var1) throws IOException;

    protected abstract BATBlock.BATBlockAndIndex getBATBlockAndIndex(int var1);

    protected abstract int getNextBlock(int var1);

    protected abstract void setNextBlock(int var1, int var2);

    protected abstract int getFreeBlock() throws IOException;

    protected abstract ChainLoopDetector getChainLoopDetector() throws IOException;

    protected class ChainLoopDetector {
        private boolean[] used_blocks;

        protected ChainLoopDetector(long l) {
            int n = (int)Math.ceil(l / (long)BlockStore.this.getBlockStoreBlockSize());
            this.used_blocks = new boolean[n];
        }

        protected void claim(int n) {
            if (n >= this.used_blocks.length) {
                return;
            }
            if (this.used_blocks[n]) {
                throw new IllegalStateException("Potential loop detected - Block " + n + " was already claimed but was just requested again");
            }
            this.used_blocks[n] = true;
        }
    }
}

