/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.eventfilesystem;

import ai.org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import ai.org.apache.poi.poifs.filesystem.DocumentDescriptor;
import ai.org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class POIFSReaderRegistry {
    private Set omnivorousListeners = new HashSet();
    private Map selectiveListeners = new HashMap();
    private Map chosenDocumentDescriptors = new HashMap();

    POIFSReaderRegistry() {
    }

    void registerListener(POIFSReaderListener pOIFSReaderListener, POIFSDocumentPath pOIFSDocumentPath, String string) {
        if (!this.omnivorousListeners.contains(pOIFSReaderListener)) {
            DocumentDescriptor documentDescriptor;
            HashSet<DocumentDescriptor> hashSet = (HashSet<DocumentDescriptor>)this.selectiveListeners.get(pOIFSReaderListener);
            if (hashSet == null) {
                hashSet = new HashSet<DocumentDescriptor>();
                this.selectiveListeners.put(pOIFSReaderListener, hashSet);
            }
            if (hashSet.add(documentDescriptor = new DocumentDescriptor(pOIFSDocumentPath, string))) {
                HashSet<POIFSReaderListener> hashSet2 = (HashSet<POIFSReaderListener>)this.chosenDocumentDescriptors.get(documentDescriptor);
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<POIFSReaderListener>();
                    this.chosenDocumentDescriptors.put(documentDescriptor, hashSet2);
                }
                hashSet2.add(pOIFSReaderListener);
            }
        }
    }

    void registerListener(POIFSReaderListener pOIFSReaderListener) {
        if (!this.omnivorousListeners.contains(pOIFSReaderListener)) {
            this.removeSelectiveListener(pOIFSReaderListener);
            this.omnivorousListeners.add(pOIFSReaderListener);
        }
    }

    Iterator getListeners(POIFSDocumentPath pOIFSDocumentPath, String string) {
        HashSet hashSet = new HashSet(this.omnivorousListeners);
        Set set = (Set)this.chosenDocumentDescriptors.get(new DocumentDescriptor(pOIFSDocumentPath, string));
        if (set != null) {
            hashSet.addAll(set);
        }
        return hashSet.iterator();
    }

    private void removeSelectiveListener(POIFSReaderListener pOIFSReaderListener) {
        Set set = (Set)this.selectiveListeners.remove(pOIFSReaderListener);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.dropDocument(pOIFSReaderListener, (DocumentDescriptor)iterator.next());
            }
        }
    }

    private void dropDocument(POIFSReaderListener pOIFSReaderListener, DocumentDescriptor documentDescriptor) {
        Set set = (Set)this.chosenDocumentDescriptors.get(documentDescriptor);
        set.remove(pOIFSReaderListener);
        if (set.size() == 0) {
            this.chosenDocumentDescriptors.remove(documentDescriptor);
        }
    }
}

