/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.dev;

import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;

public class POIFSLister {
    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length == 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-size") || stringArray[i].equalsIgnoreCase("-sizes")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-old") || stringArray[i].equalsIgnoreCase("-old-poifs")) {
                bl2 = false;
                continue;
            }
            if (bl2) {
                POIFSLister.viewFile(stringArray[i], bl);
                continue;
            }
            POIFSLister.viewFileOld(stringArray[i], bl);
        }
    }

    public static void viewFile(String string, boolean bl) throws IOException {
        NPOIFSFileSystem nPOIFSFileSystem = new NPOIFSFileSystem(new File(string));
        POIFSLister.displayDirectory(nPOIFSFileSystem.getRoot(), "", bl);
    }

    public static void viewFileOld(String string, boolean bl) throws IOException {
        POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(new FileInputStream(string));
        POIFSLister.displayDirectory(pOIFSFileSystem.getRoot(), "", bl);
    }

    public static void displayDirectory(DirectoryNode directoryNode, String string, boolean bl) {
        System.out.println(string + directoryNode.getName() + " -");
        String string2 = string + "  ";
        boolean bl2 = false;
        Iterator<Entry> iterator = directoryNode.getEntries();
        while (iterator.hasNext()) {
            bl2 = true;
            Entry entry = iterator.next();
            if (entry instanceof DirectoryNode) {
                POIFSLister.displayDirectory((DirectoryNode)entry, string2, bl);
                continue;
            }
            DocumentNode documentNode = (DocumentNode)entry;
            String string3 = documentNode.getName();
            String string4 = "";
            if (string3.charAt(0) < '\n') {
                String string5 = "(0x0" + string3.charAt(0) + ")" + string3.substring(1);
                string3 = string3.substring(1) + " <" + string5 + ">";
            }
            if (bl) {
                string4 = " [" + documentNode.getSize() + " / 0x" + Integer.toHexString(documentNode.getSize()) + "]";
            }
            System.out.println(string2 + string3 + string4);
        }
        if (!bl2) {
            System.out.println(string2 + "(no children)");
        }
    }
}

