/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.dev;

import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.DocumentNode;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.poifs.filesystem.EntryNode;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;

public class POIFSDump {
    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("Dumping " + stringArray[i]);
            FileInputStream fileInputStream = new FileInputStream(stringArray[i]);
            POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(fileInputStream);
            fileInputStream.close();
            DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
            File file = new File(directoryNode.getName());
            file.mkdir();
            POIFSDump.dump(directoryNode, file);
        }
    }

    public static void dump(DirectoryEntry directoryEntry, File file) throws IOException {
        Iterator<Entry> iterator = directoryEntry.getEntries();
        while (iterator.hasNext()) {
            Object object;
            Entry entry;
            Entry entry2 = iterator.next();
            if (entry2 instanceof DocumentNode) {
                entry = (DocumentNode)entry2;
                object = new DocumentInputStream((DocumentEntry)entry);
                byte[] byArray = new byte[((DocumentNode)entry).getSize()];
                ((DocumentInputStream)object).read(byArray);
                ((DocumentInputStream)object).close();
                FileOutputStream fileOutputStream = new FileOutputStream(new File(file, ((EntryNode)entry).getName().trim()));
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                continue;
            }
            if (entry2 instanceof DirectoryEntry) {
                entry = (DirectoryEntry)entry2;
                object = new File(file, entry2.getName());
                ((File)object).mkdir();
                POIFSDump.dump((DirectoryEntry)entry, (File)object);
                continue;
            }
            System.err.println("Skipping unsupported POIFS entry: " + entry2);
        }
    }
}

