/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt.standard;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.ChainingMode;
import ai.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionHeader;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.util.LittleEndianByteArrayOutputStream;

public class StandardEncryptionVerifier
extends EncryptionVerifier
implements EncryptionRecord {
    private static final int SPIN_COUNT = 50000;
    private final int verifierHashSize;

    protected StandardEncryptionVerifier(DocumentInputStream documentInputStream, StandardEncryptionHeader standardEncryptionHeader) {
        int n = documentInputStream.readInt();
        if (n != 16) {
            throw new RuntimeException("Salt size != 16 !?");
        }
        byte[] byArray = new byte[16];
        documentInputStream.readFully(byArray);
        this.setSalt(byArray);
        byte[] byArray2 = new byte[16];
        documentInputStream.readFully(byArray2);
        this.setEncryptedVerifier(byArray2);
        this.verifierHashSize = documentInputStream.readInt();
        byte[] byArray3 = new byte[standardEncryptionHeader.getCipherAlgorithm().encryptedVerifierHashLength];
        documentInputStream.readFully(byArray3);
        this.setEncryptedVerifierHash(byArray3);
        this.setSpinCount(50000);
        this.setCipherAlgorithm(CipherAlgorithm.aes128);
        this.setChainingMode(ChainingMode.ecb);
        this.setEncryptedKey(null);
        this.setHashAlgorithm(HashAlgorithm.sha1);
    }

    protected StandardEncryptionVerifier(CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setHashAlgorithm(hashAlgorithm);
        this.setChainingMode(chainingMode);
        this.setSpinCount(50000);
        this.verifierHashSize = hashAlgorithm.hashSize;
    }

    protected void setSalt(byte[] byArray) {
        if (byArray == null || byArray.length != 16) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setSalt(byArray);
    }

    protected void setEncryptedVerifier(byte[] byArray) {
        super.setEncryptedVerifier(byArray);
    }

    protected void setEncryptedVerifierHash(byte[] byArray) {
        super.setEncryptedVerifierHash(byArray);
    }

    public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
        byte[] byArray = this.getSalt();
        assert (byArray.length == 16);
        littleEndianByteArrayOutputStream.writeInt(byArray.length);
        littleEndianByteArrayOutputStream.write(byArray);
        byte[] byArray2 = this.getEncryptedVerifier();
        assert (byArray2.length == 16);
        littleEndianByteArrayOutputStream.write(byArray2);
        byte[] byArray3 = this.getEncryptedVerifierHash();
        assert (byArray3.length == 32);
        littleEndianByteArrayOutputStream.writeInt(20);
        littleEndianByteArrayOutputStream.write(byArray3);
    }

    protected int getVerifierHashSize() {
        return this.verifierHashSize;
    }
}

