/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt.standard;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.ChainingMode;
import ai.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai.org.apache.poi.poifs.crypt.standard.StandardDecryptor;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionHeader;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptionVerifier;
import ai.org.apache.poi.poifs.crypt.standard.StandardEncryptor;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import java.io.IOException;

public class StandardEncryptionInfoBuilder
implements EncryptionInfoBuilder {
    EncryptionInfo info;
    StandardEncryptionHeader header;
    StandardEncryptionVerifier verifier;
    StandardDecryptor decryptor;
    StandardEncryptor encryptor;

    public void initialize(EncryptionInfo encryptionInfo, DocumentInputStream documentInputStream) throws IOException {
        this.info = encryptionInfo;
        int n = documentInputStream.readInt();
        this.header = new StandardEncryptionHeader(documentInputStream);
        this.verifier = new StandardEncryptionVerifier(documentInputStream, this.header);
        if (encryptionInfo.getVersionMinor() == 2 && (encryptionInfo.getVersionMajor() == 3 || encryptionInfo.getVersionMajor() == 4)) {
            this.decryptor = new StandardDecryptor(encryptionInfo);
        }
    }

    public void initialize(EncryptionInfo encryptionInfo, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) {
        this.info = encryptionInfo;
        if (cipherAlgorithm == null) {
            cipherAlgorithm = CipherAlgorithm.rc4;
        }
        if (hashAlgorithm == null) {
            hashAlgorithm = HashAlgorithm.sha1;
        }
        if (hashAlgorithm != HashAlgorithm.sha1) {
            throw new EncryptedDocumentException("Standard encryption only supports SHA-1.");
        }
        if (chainingMode == null) {
            chainingMode = ChainingMode.ecb;
        }
        if (chainingMode != ChainingMode.ecb) {
            throw new EncryptedDocumentException("Standard encryption only supports ECB chaining.");
        }
        if (n == -1) {
            n = cipherAlgorithm.defaultKeySize;
        }
        if (n2 == -1) {
            n2 = cipherAlgorithm.blockSize;
        }
        boolean bl = false;
        for (int n3 : cipherAlgorithm.allowedKeySize) {
            bl |= n3 == n;
        }
        if (!bl) {
            throw new EncryptedDocumentException("KeySize " + n + " not allowed for Cipher " + cipherAlgorithm.toString());
        }
        this.header = new StandardEncryptionHeader(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.verifier = new StandardEncryptionVerifier(cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.decryptor = new StandardDecryptor(encryptionInfo);
        this.encryptor = new StandardEncryptor(this);
    }

    public StandardEncryptionHeader getHeader() {
        return this.header;
    }

    public StandardEncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public StandardDecryptor getDecryptor() {
        return this.decryptor;
    }

    public StandardEncryptor getEncryptor() {
        return this.encryptor;
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.info;
    }
}

