/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.ChainingMode;
import ai.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai.org.apache.poi.poifs.crypt.Decryptor;
import ai.org.apache.poi.poifs.crypt.EncryptionHeader;
import ai.org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import ai.org.apache.poi.poifs.crypt.EncryptionMode;
import ai.org.apache.poi.poifs.crypt.EncryptionVerifier;
import ai.org.apache.poi.poifs.crypt.Encryptor;
import ai.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import java.io.IOException;

public class EncryptionInfo {
    private final int versionMajor;
    private final int versionMinor;
    private final int encryptionFlags;
    private final EncryptionHeader header;
    private final EncryptionVerifier verifier;
    private final Decryptor decryptor;
    private final Encryptor encryptor;

    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(nPOIFSFileSystem.getRoot());
    }

    public EncryptionInfo(DirectoryNode directoryNode) throws IOException {
        EncryptionInfoBuilder encryptionInfoBuilder;
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("EncryptionInfo");
        this.versionMajor = documentInputStream.readShort();
        this.versionMinor = documentInputStream.readShort();
        this.encryptionFlags = documentInputStream.readInt();
        EncryptionMode encryptionMode = this.versionMajor == EncryptionMode.agile.versionMajor && this.versionMinor == EncryptionMode.agile.versionMinor && this.encryptionFlags == EncryptionMode.agile.encryptionFlags ? EncryptionMode.agile : EncryptionMode.standard;
        try {
            encryptionInfoBuilder = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        encryptionInfoBuilder.initialize(this, documentInputStream);
        this.header = encryptionInfoBuilder.getHeader();
        this.verifier = encryptionInfoBuilder.getVerifier();
        this.decryptor = encryptionInfoBuilder.getDecryptor();
        this.encryptor = encryptionInfoBuilder.getEncryptor();
    }

    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem, EncryptionMode encryptionMode) throws IOException {
        this(pOIFSFileSystem.getRoot(), encryptionMode);
    }

    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem, EncryptionMode encryptionMode) throws IOException {
        this(nPOIFSFileSystem.getRoot(), encryptionMode);
    }

    public EncryptionInfo(DirectoryNode directoryNode, EncryptionMode encryptionMode) throws EncryptedDocumentException {
        this(directoryNode, encryptionMode, null, null, -1, -1, null);
    }

    public EncryptionInfo(POIFSFileSystem pOIFSFileSystem, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) throws EncryptedDocumentException {
        this(pOIFSFileSystem.getRoot(), encryptionMode, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    public EncryptionInfo(NPOIFSFileSystem nPOIFSFileSystem, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) throws EncryptedDocumentException {
        this(nPOIFSFileSystem.getRoot(), encryptionMode, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
    }

    public EncryptionInfo(DirectoryNode directoryNode, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int n, int n2, ChainingMode chainingMode) throws EncryptedDocumentException {
        EncryptionInfoBuilder encryptionInfoBuilder;
        this.versionMajor = encryptionMode.versionMajor;
        this.versionMinor = encryptionMode.versionMinor;
        this.encryptionFlags = encryptionMode.encryptionFlags;
        try {
            encryptionInfoBuilder = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception exception) {
            throw new EncryptedDocumentException(exception);
        }
        encryptionInfoBuilder.initialize(this, cipherAlgorithm, hashAlgorithm, n, n2, chainingMode);
        this.header = encryptionInfoBuilder.getHeader();
        this.verifier = encryptionInfoBuilder.getVerifier();
        this.decryptor = encryptionInfoBuilder.getDecryptor();
        this.encryptor = encryptionInfoBuilder.getEncryptor();
    }

    protected static EncryptionInfoBuilder getBuilder(EncryptionMode encryptionMode) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        EncryptionInfoBuilder encryptionInfoBuilder = (EncryptionInfoBuilder)classLoader.loadClass(encryptionMode.builder).newInstance();
        return encryptionInfoBuilder;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getEncryptionFlags() {
        return this.encryptionFlags;
    }

    public EncryptionHeader getHeader() {
        return this.header;
    }

    public EncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }
}

