/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.poifs.crypt;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.poifs.crypt.standard.EncryptionRecord;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterEvent;
import ai.org.apache.poi.poifs.filesystem.POIFSWriterListener;
import ai.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class DataSpaceMapUtils {
    public static void addDefaultDataSpace(DirectoryEntry directoryEntry) throws IOException {
        DataSpaceMapEntry dataSpaceMapEntry = new DataSpaceMapEntry(new int[]{0}, new String[]{"EncryptedPackage"}, "StrongEncryptionDataSpace");
        DataSpaceMap dataSpaceMap = new DataSpaceMap(new DataSpaceMapEntry[]{dataSpaceMapEntry});
        DataSpaceMapUtils.createEncryptionEntry(directoryEntry, "\u0006DataSpaces/DataSpaceMap", dataSpaceMap);
        DataSpaceDefinition dataSpaceDefinition = new DataSpaceDefinition(new String[]{"StrongEncryptionTransform"});
        DataSpaceMapUtils.createEncryptionEntry(directoryEntry, "\u0006DataSpaces/DataSpaceInfo/StrongEncryptionDataSpace", dataSpaceDefinition);
        TransformInfoHeader transformInfoHeader = new TransformInfoHeader(1, "{FF9A3F03-56EF-4613-BDD5-5A41C1D07246}", "Microsoft.Container.EncryptionTransform", 1, 0, 1, 0, 1, 0);
        IRMDSTransformInfo iRMDSTransformInfo = new IRMDSTransformInfo(transformInfoHeader, 0, null);
        DataSpaceMapUtils.createEncryptionEntry(directoryEntry, "\u0006DataSpaces/TransformInfo/StrongEncryptionTransform/\u0006Primary", iRMDSTransformInfo);
        DataSpaceVersionInfo dataSpaceVersionInfo = new DataSpaceVersionInfo("Microsoft.Container.DataSpaces", 1, 0, 1, 0, 1, 0);
        DataSpaceMapUtils.createEncryptionEntry(directoryEntry, "\u0006DataSpaces/Version", dataSpaceVersionInfo);
    }

    public static DocumentEntry createEncryptionEntry(DirectoryEntry directoryEntry, String string, EncryptionRecord encryptionRecord) throws IOException {
        String[] stringArray = string.split("/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            directoryEntry = directoryEntry.hasEntry(stringArray[i]) ? (DirectoryEntry)directoryEntry.getEntry(stringArray[i]) : directoryEntry.createDirectory(stringArray[i]);
        }
        final byte[] byArray = new byte[5000];
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, 0);
        encryptionRecord.write(littleEndianByteArrayOutputStream);
        String string2 = stringArray[stringArray.length - 1];
        if (directoryEntry.hasEntry(string2)) {
            directoryEntry.getEntry(string2).delete();
        }
        return directoryEntry.createDocument(string2, littleEndianByteArrayOutputStream.getWriteIndex(), new POIFSWriterListener(){

            public void processPOIFSWriterEvent(POIFSWriterEvent pOIFSWriterEvent) {
                try {
                    pOIFSWriterEvent.getStream().write(byArray, 0, pOIFSWriterEvent.getLimit());
                }
                catch (IOException iOException) {
                    throw new EncryptedDocumentException(iOException);
                }
            }
        });
    }

    public static String readUnicodeLPP4(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readInt();
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        if (n % 4 == 2) {
            littleEndianInput.readShort();
        }
        try {
            return new String(byArray, 0, byArray.length, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptedDocumentException(unsupportedEncodingException);
        }
    }

    public static void writeUnicodeLPP4(LittleEndianOutput littleEndianOutput, String string) {
        try {
            byte[] byArray = string.getBytes("UTF-16LE");
            littleEndianOutput.writeInt(byArray.length);
            littleEndianOutput.write(byArray);
            if (byArray.length % 4 == 2) {
                littleEndianOutput.writeShort(0);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptedDocumentException(unsupportedEncodingException);
        }
    }

    public static String readUtf8LPP4(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readInt();
        if (n == 0 || n == 4) {
            int n2 = littleEndianInput.readInt();
            return n == 0 ? null : "";
        }
        byte[] byArray = new byte[n];
        littleEndianInput.readFully(byArray);
        int n3 = n % 4;
        if (n3 > 0) {
            for (int i = 0; i < 4 - n3; ++i) {
                littleEndianInput.readByte();
            }
        }
        try {
            return new String(byArray, 0, byArray.length, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EncryptedDocumentException(unsupportedEncodingException);
        }
    }

    public static void writeUtf8LPP4(LittleEndianOutput littleEndianOutput, String string) {
        if (string == null || "".equals(string)) {
            littleEndianOutput.writeInt(string == null ? 0 : 4);
            littleEndianOutput.writeInt(0);
        } else {
            try {
                byte[] byArray = string.getBytes("UTF-8");
                littleEndianOutput.writeInt(byArray.length);
                littleEndianOutput.write(byArray);
                int n = byArray.length % 4;
                if (n > 0) {
                    for (int i = 0; i < 4 - n; ++i) {
                        littleEndianOutput.writeByte(0);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new EncryptedDocumentException(unsupportedEncodingException);
            }
        }
    }

    public static class DataSpaceVersionInfo
    implements EncryptionRecord {
        String featureIdentifier;
        int readerVersionMajor = 1;
        int readerVersionMinor = 0;
        int updaterVersionMajor = 1;
        int updaterVersionMinor = 0;
        int writerVersionMajor = 1;
        int writerVersionMinor = 0;

        public DataSpaceVersionInfo(LittleEndianInput littleEndianInput) {
            this.featureIdentifier = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
            this.readerVersionMajor = littleEndianInput.readShort();
            this.readerVersionMinor = littleEndianInput.readShort();
            this.updaterVersionMajor = littleEndianInput.readShort();
            this.updaterVersionMinor = littleEndianInput.readShort();
            this.writerVersionMajor = littleEndianInput.readShort();
            this.writerVersionMinor = littleEndianInput.readShort();
        }

        public DataSpaceVersionInfo(String string, int n, int n2, int n3, int n4, int n5, int n6) {
            this.featureIdentifier = string;
            this.readerVersionMajor = n;
            this.readerVersionMinor = n2;
            this.updaterVersionMajor = n3;
            this.updaterVersionMinor = n4;
            this.writerVersionMajor = n5;
            this.writerVersionMinor = n6;
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, this.featureIdentifier);
            littleEndianByteArrayOutputStream.writeShort(this.readerVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.readerVersionMinor);
            littleEndianByteArrayOutputStream.writeShort(this.updaterVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.updaterVersionMinor);
            littleEndianByteArrayOutputStream.writeShort(this.writerVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.writerVersionMinor);
        }
    }

    public static class TransformInfoHeader
    implements EncryptionRecord {
        int transformType;
        String transformerId;
        String transformerName;
        int readerVersionMajor = 1;
        int readerVersionMinor = 0;
        int updaterVersionMajor = 1;
        int updaterVersionMinor = 0;
        int writerVersionMajor = 1;
        int writerVersionMinor = 0;

        public TransformInfoHeader(int n, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.transformType = n;
            this.transformerId = string;
            this.transformerName = string2;
            this.readerVersionMajor = n2;
            this.readerVersionMinor = n3;
            this.updaterVersionMajor = n4;
            this.updaterVersionMinor = n5;
            this.writerVersionMajor = n6;
            this.writerVersionMinor = n7;
        }

        public TransformInfoHeader(LittleEndianInput littleEndianInput) {
            int n = littleEndianInput.readInt();
            this.transformType = littleEndianInput.readInt();
            this.transformerId = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
            this.transformerName = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
            this.readerVersionMajor = littleEndianInput.readShort();
            this.readerVersionMinor = littleEndianInput.readShort();
            this.updaterVersionMajor = littleEndianInput.readShort();
            this.updaterVersionMinor = littleEndianInput.readShort();
            this.writerVersionMajor = littleEndianInput.readShort();
            this.writerVersionMinor = littleEndianInput.readShort();
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            int n = littleEndianByteArrayOutputStream.getWriteIndex();
            LittleEndianOutput littleEndianOutput = littleEndianByteArrayOutputStream.createDelayedOutput(4);
            littleEndianByteArrayOutputStream.writeInt(this.transformType);
            DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, this.transformerId);
            littleEndianOutput.writeInt(littleEndianByteArrayOutputStream.getWriteIndex() - n);
            DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, this.transformerName);
            littleEndianByteArrayOutputStream.writeShort(this.readerVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.readerVersionMinor);
            littleEndianByteArrayOutputStream.writeShort(this.updaterVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.updaterVersionMinor);
            littleEndianByteArrayOutputStream.writeShort(this.writerVersionMajor);
            littleEndianByteArrayOutputStream.writeShort(this.writerVersionMinor);
        }
    }

    public static class IRMDSTransformInfo
    implements EncryptionRecord {
        TransformInfoHeader transformInfoHeader;
        int extensibilityHeader;
        String xrMLLicense;

        public IRMDSTransformInfo(TransformInfoHeader transformInfoHeader, int n, String string) {
            this.transformInfoHeader = transformInfoHeader;
            this.extensibilityHeader = n;
            this.xrMLLicense = string;
        }

        public IRMDSTransformInfo(LittleEndianInput littleEndianInput) {
            this.transformInfoHeader = new TransformInfoHeader(littleEndianInput);
            this.extensibilityHeader = littleEndianInput.readInt();
            this.xrMLLicense = DataSpaceMapUtils.readUtf8LPP4(littleEndianInput);
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            this.transformInfoHeader.write(littleEndianByteArrayOutputStream);
            littleEndianByteArrayOutputStream.writeInt(this.extensibilityHeader);
            DataSpaceMapUtils.writeUtf8LPP4(littleEndianByteArrayOutputStream, this.xrMLLicense);
            littleEndianByteArrayOutputStream.writeInt(4);
        }
    }

    public static class DataSpaceDefinition
    implements EncryptionRecord {
        String[] transformer;

        public DataSpaceDefinition(String[] stringArray) {
            this.transformer = stringArray;
        }

        public DataSpaceDefinition(LittleEndianInput littleEndianInput) {
            int n = littleEndianInput.readInt();
            int n2 = littleEndianInput.readInt();
            this.transformer = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this.transformer[i] = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
            }
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            littleEndianByteArrayOutputStream.writeInt(8);
            littleEndianByteArrayOutputStream.writeInt(this.transformer.length);
            for (String string : this.transformer) {
                DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, string);
            }
        }
    }

    public static class DataSpaceMapEntry
    implements EncryptionRecord {
        int[] referenceComponentType;
        String[] referenceComponent;
        String dataSpaceName;

        public DataSpaceMapEntry(int[] nArray, String[] stringArray, String string) {
            this.referenceComponentType = nArray;
            this.referenceComponent = stringArray;
            this.dataSpaceName = string;
        }

        public DataSpaceMapEntry(LittleEndianInput littleEndianInput) {
            int n = littleEndianInput.readInt();
            int n2 = littleEndianInput.readInt();
            this.referenceComponentType = new int[n2];
            this.referenceComponent = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this.referenceComponentType[i] = littleEndianInput.readInt();
                this.referenceComponent[i] = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
            }
            this.dataSpaceName = DataSpaceMapUtils.readUnicodeLPP4(littleEndianInput);
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            int n = littleEndianByteArrayOutputStream.getWriteIndex();
            LittleEndianOutput littleEndianOutput = littleEndianByteArrayOutputStream.createDelayedOutput(4);
            littleEndianByteArrayOutputStream.writeInt(this.referenceComponent.length);
            for (int i = 0; i < this.referenceComponent.length; ++i) {
                littleEndianByteArrayOutputStream.writeInt(this.referenceComponentType[i]);
                DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, this.referenceComponent[i]);
            }
            DataSpaceMapUtils.writeUnicodeLPP4(littleEndianByteArrayOutputStream, this.dataSpaceName);
            littleEndianOutput.writeInt(littleEndianByteArrayOutputStream.getWriteIndex() - n);
        }
    }

    public static class DataSpaceMap
    implements EncryptionRecord {
        DataSpaceMapEntry[] entries;

        public DataSpaceMap(DataSpaceMapEntry[] dataSpaceMapEntryArray) {
            this.entries = dataSpaceMapEntryArray;
        }

        public DataSpaceMap(LittleEndianInput littleEndianInput) {
            int n = littleEndianInput.readInt();
            int n2 = littleEndianInput.readInt();
            this.entries = new DataSpaceMapEntry[n2];
            for (int i = 0; i < n2; ++i) {
                this.entries[i] = new DataSpaceMapEntry(littleEndianInput);
            }
        }

        public void write(LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream) {
            littleEndianByteArrayOutputStream.writeInt(8);
            littleEndianByteArrayOutputStream.writeInt(this.entries.length);
            for (DataSpaceMapEntry dataSpaceMapEntry : this.entries) {
                dataSpaceMapEntry.write(littleEndianByteArrayOutputStream);
            }
        }
    }
}

