/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

public abstract class HeaderFooter
implements ai.org.apache.poi.ss.usermodel.HeaderFooter {
    protected HeaderFooter() {
    }

    protected abstract String getRawText();

    private String[] splitParts() {
        String string = this.getRawText();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        block5: while (string.length() > 1) {
            if (string.charAt(0) != '&') {
                string3 = string;
                break;
            }
            int n = string.length();
            switch (string.charAt(1)) {
                case 'L': {
                    if (string.indexOf("&C") >= 0) {
                        n = Math.min(n, string.indexOf("&C"));
                    }
                    if (string.indexOf("&R") >= 0) {
                        n = Math.min(n, string.indexOf("&R"));
                    }
                    string2 = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
                case 'C': {
                    if (string.indexOf("&L") >= 0) {
                        n = Math.min(n, string.indexOf("&L"));
                    }
                    if (string.indexOf("&R") >= 0) {
                        n = Math.min(n, string.indexOf("&R"));
                    }
                    string3 = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
                case 'R': {
                    if (string.indexOf("&C") >= 0) {
                        n = Math.min(n, string.indexOf("&C"));
                    }
                    if (string.indexOf("&L") >= 0) {
                        n = Math.min(n, string.indexOf("&L"));
                    }
                    string4 = string.substring(2, n);
                    string = string.substring(n);
                    continue block5;
                }
            }
            string3 = string;
            break;
        }
        return new String[]{string2, string3, string4};
    }

    public final String getLeft() {
        return this.splitParts()[0];
    }

    public final void setLeft(String string) {
        this.updatePart(0, string);
    }

    public final String getCenter() {
        return this.splitParts()[1];
    }

    public final void setCenter(String string) {
        this.updatePart(1, string);
    }

    public final String getRight() {
        return this.splitParts()[2];
    }

    public final void setRight(String string) {
        this.updatePart(2, string);
    }

    private void updatePart(int n, String string) {
        String[] stringArray = this.splitParts();
        stringArray[n] = string == null ? "" : string;
        this.updateHeaderFooterText(stringArray);
    }

    private void updateHeaderFooterText(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string2.length() < 1 && string.length() < 1 && string3.length() < 1) {
            this.setHeaderFooterText("");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("&C");
        stringBuilder.append(string2);
        stringBuilder.append("&L");
        stringBuilder.append(string);
        stringBuilder.append("&R");
        stringBuilder.append(string3);
        String string4 = stringBuilder.toString();
        this.setHeaderFooterText(string4);
    }

    protected abstract void setHeaderFooterText(String var1);

    public static String fontSize(short s) {
        return "&" + s;
    }

    public static String font(String string, String string2) {
        return "&\"" + string + "," + string2 + "\"";
    }

    public static String page() {
        return MarkupTag.PAGE_FIELD.getRepresentation();
    }

    public static String numPages() {
        return MarkupTag.NUM_PAGES_FIELD.getRepresentation();
    }

    public static String date() {
        return MarkupTag.DATE_FIELD.getRepresentation();
    }

    public static String time() {
        return MarkupTag.TIME_FIELD.getRepresentation();
    }

    public static String file() {
        return MarkupTag.FILE_FIELD.getRepresentation();
    }

    public static String tab() {
        return MarkupTag.SHEET_NAME_FIELD.getRepresentation();
    }

    public static String startBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String endBold() {
        return MarkupTag.BOLD_FIELD.getRepresentation();
    }

    public static String startUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String endUnderline() {
        return MarkupTag.UNDERLINE_FIELD.getRepresentation();
    }

    public static String startDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String endDoubleUnderline() {
        return MarkupTag.DOUBLE_UNDERLINE_FIELD.getRepresentation();
    }

    public static String stripFields(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = string;
        for (MarkupTag markupTag : MarkupTag.values()) {
            int n;
            String string3 = markupTag.getRepresentation();
            while ((n = string2.indexOf(string3)) > -1) {
                string2 = string2.substring(0, n) + string2.substring(n + string3.length());
            }
        }
        string2 = string2.replaceAll("\\&\\d+", "");
        string2 = string2.replaceAll("\\&\".*?,.*?\"", "");
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MarkupTag {
        SHEET_NAME_FIELD("&A", false),
        DATE_FIELD("&D", false),
        FILE_FIELD("&F", false),
        FULL_FILE_FIELD("&Z", false),
        PAGE_FIELD("&P", false),
        TIME_FIELD("&T", false),
        NUM_PAGES_FIELD("&N", false),
        PICTURE_FIELD("&G", false),
        BOLD_FIELD("&B", true),
        ITALIC_FIELD("&I", true),
        STRIKETHROUGH_FIELD("&S", true),
        SUBSCRIPT_FIELD("&Y", true),
        SUPERSCRIPT_FIELD("&X", true),
        UNDERLINE_FIELD("&U", true),
        DOUBLE_UNDERLINE_FIELD("&E", true);

        private final String _representation;
        private final boolean _occursInPairs;

        private MarkupTag(String string2, boolean bl) {
            this._representation = string2;
            this._occursInPairs = bl;
        }

        public String getRepresentation() {
            return this._representation;
        }

        public boolean occursPairs() {
            return this._occursInPairs;
        }
    }
}

