/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.hssf.model.DrawingManager2;
import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.model.InternalSheet;
import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.AutoFilterInfoRecord;
import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.record.DrawingRecord;
import ai.org.apache.poi.hssf.record.EscherAggregate;
import ai.org.apache.poi.hssf.record.ExtendedFormatRecord;
import ai.org.apache.poi.hssf.record.NameRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.record.SCLRecord;
import ai.org.apache.poi.hssf.record.WSBoolRecord;
import ai.org.apache.poi.hssf.record.aggregates.DataValidityTable;
import ai.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.WorksheetProtectionBlock;
import ai.org.apache.poi.hssf.usermodel.DVConstraint;
import ai.org.apache.poi.hssf.usermodel.HSSFAutoFilter;
import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFCellStyle;
import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFComment;
import ai.org.apache.poi.hssf.usermodel.HSSFDataValidation;
import ai.org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import ai.org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import ai.org.apache.poi.hssf.usermodel.HSSFFooter;
import ai.org.apache.poi.hssf.usermodel.HSSFHeader;
import ai.org.apache.poi.hssf.usermodel.HSSFHyperlink;
import ai.org.apache.poi.hssf.usermodel.HSSFName;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import ai.org.apache.poi.hssf.usermodel.HSSFShapeGroup;
import ai.org.apache.poi.hssf.usermodel.HSSFSheetConditionalFormatting;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.hssf.util.PaneInformation;
import ai.org.apache.poi.hssf.util.Region;
import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.formula.FormulaShifter;
import ai.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.formula.ptg.UnionPtg;
import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellRange;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.DataValidation;
import ai.org.apache.poi.ss.usermodel.DataValidationHelper;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.ss.util.CellRangeAddressList;
import ai.org.apache.poi.ss.util.CellReference;
import ai.org.apache.poi.ss.util.SSCellRange;
import ai.org.apache.poi.ss.util.SheetUtil;
import ai.org.apache.poi.util.Configurator;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFSheet
implements Sheet {
    private static final POILogger log = POILogFactory.getLogger(HSSFSheet.class);
    private static final int DEBUG = 1;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    public static final int INITIAL_CAPACITY = Configurator.getIntValue("HSSFSheet.RowInitialCapacity", 20);
    private final InternalSheet _sheet;
    private final TreeMap<Integer, HSSFRow> _rows;
    protected final InternalWorkbook _book;
    protected final HSSFWorkbook _workbook;
    private HSSFPatriarch _patriarch;
    private int _firstrow;
    private int _lastrow;

    protected HSSFSheet(HSSFWorkbook hSSFWorkbook) {
        this._sheet = InternalSheet.createSheet();
        this._rows = new TreeMap();
        this._workbook = hSSFWorkbook;
        this._book = hSSFWorkbook.getWorkbook();
    }

    protected HSSFSheet(HSSFWorkbook hSSFWorkbook, InternalSheet internalSheet) {
        this._sheet = internalSheet;
        this._rows = new TreeMap();
        this._workbook = hSSFWorkbook;
        this._book = hSSFWorkbook.getWorkbook();
        this.setPropertiesFromSheet(internalSheet);
    }

    HSSFSheet cloneSheet(HSSFWorkbook hSSFWorkbook) {
        this.getDrawingPatriarch();
        HSSFSheet hSSFSheet = new HSSFSheet(hSSFWorkbook, this._sheet.cloneSheet());
        int n = hSSFSheet._sheet.findFirstRecordLocBySid((short)236);
        DrawingRecord drawingRecord = (DrawingRecord)hSSFSheet._sheet.findFirstRecordBySid((short)236);
        if (null != drawingRecord) {
            hSSFSheet._sheet.getRecords().remove(drawingRecord);
        }
        if (this.getDrawingPatriarch() != null) {
            HSSFPatriarch hSSFPatriarch = HSSFPatriarch.createPatriarch(this.getDrawingPatriarch(), hSSFSheet);
            hSSFSheet._sheet.getRecords().add(n, hSSFPatriarch._getBoundAggregate());
            hSSFSheet._patriarch = hSSFPatriarch;
        }
        return hSSFSheet;
    }

    protected void preSerialize() {
        if (this._patriarch != null) {
            this._patriarch.preSerialize();
        }
    }

    @Override
    public HSSFWorkbook getWorkbook() {
        return this._workbook;
    }

    private void setPropertiesFromSheet(InternalSheet internalSheet) {
        boolean bl;
        RowRecord rowRecord = internalSheet.getNextRow();
        boolean bl2 = bl = rowRecord != null;
        while (rowRecord != null) {
            this.createRowFromRecord(rowRecord);
            rowRecord = internalSheet.getNextRow();
        }
        Iterator<CellValueRecordInterface> iterator = internalSheet.getCellValueIterator();
        long l = System.currentTimeMillis();
        if (log.check(1)) {
            log.log(1, (Object)"Time at start of cell creating in HSSF sheet = ", l);
        }
        HSSFRow hSSFRow = null;
        while (iterator.hasNext()) {
            CellValueRecordInterface cellValueRecordInterface = iterator.next();
            long l2 = System.currentTimeMillis();
            HSSFRow hSSFRow2 = hSSFRow;
            if (hSSFRow2 == null || hSSFRow2.getRowNum() != cellValueRecordInterface.getRow()) {
                hSSFRow = hSSFRow2 = this.getRow(cellValueRecordInterface.getRow());
                if (hSSFRow2 == null) {
                    if (bl) {
                        throw new RuntimeException("Unexpected missing row when some rows already present");
                    }
                    RowRecord rowRecord2 = new RowRecord(cellValueRecordInterface.getRow());
                    internalSheet.addRow(rowRecord2);
                    hSSFRow2 = this.createRowFromRecord(rowRecord2);
                }
            }
            if (log.check(1)) {
                if (cellValueRecordInterface instanceof Record) {
                    log.log(1, "record id = " + Integer.toHexString(((Record)((Object)cellValueRecordInterface)).getSid()));
                } else {
                    log.log(1, "record = " + cellValueRecordInterface);
                }
            }
            hSSFRow2.createCellFromRecord(cellValueRecordInterface);
            if (!log.check(1)) continue;
            log.log(1, (Object)"record took ", System.currentTimeMillis() - l2);
        }
        if (log.check(1)) {
            log.log(1, (Object)"total sheet cell creation took ", System.currentTimeMillis() - l);
        }
    }

    @Override
    public HSSFRow createRow(int n) {
        HSSFRow hSSFRow = new HSSFRow(this._workbook, this, n);
        hSSFRow.setHeight(this.getDefaultRowHeight());
        hSSFRow.getRowRecord().setBadFontHeight(false);
        this.addRow(hSSFRow, true);
        return hSSFRow;
    }

    private HSSFRow createRowFromRecord(RowRecord rowRecord) {
        HSSFRow hSSFRow = new HSSFRow(this._workbook, this, rowRecord);
        this.addRow(hSSFRow, false);
        return hSSFRow;
    }

    @Override
    public void removeRow(Row row) {
        HSSFRow hSSFRow = (HSSFRow)row;
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        for (Object object : row) {
            HSSFCell hSSFCell = (HSSFCell)object;
            if (!hSSFCell.isPartOfArrayFormulaGroup()) continue;
            String string = "Row[rownum=" + row.getRowNum() + "] contains cell(s) included in a multi-cell array formula. You cannot change part of an array.";
            hSSFCell.notifyArrayFormulaChanging(string);
        }
        if (this._rows.size() > 0) {
            Object object;
            Integer n = row.getRowNum();
            object = this._rows.remove(n);
            if (object != row) {
                throw new IllegalArgumentException("Specified row does not belong to this sheet");
            }
            if (hSSFRow.getRowNum() == this.getLastRowNum()) {
                this._lastrow = this.findLastRow(this._lastrow);
            }
            if (hSSFRow.getRowNum() == this.getFirstRowNum()) {
                this._firstrow = this.findFirstRow(this._firstrow);
            }
            this._sheet.removeRow(hSSFRow.getRowRecord());
        }
    }

    private int findLastRow(int n) {
        if (n < 1) {
            return 0;
        }
        int n2 = n - 1;
        HSSFRow hSSFRow = this.getRow(n2);
        while (hSSFRow == null && n2 > 0) {
            hSSFRow = this.getRow(--n2);
        }
        if (hSSFRow == null) {
            return 0;
        }
        return n2;
    }

    private int findFirstRow(int n) {
        int n2 = n + 1;
        HSSFRow hSSFRow = this.getRow(n2);
        while (hSSFRow == null && n2 <= this.getLastRowNum()) {
            hSSFRow = this.getRow(++n2);
        }
        if (n2 > this.getLastRowNum()) {
            return 0;
        }
        return n2;
    }

    private void addRow(HSSFRow hSSFRow, boolean bl) {
        boolean bl2;
        this._rows.put(hSSFRow.getRowNum(), hSSFRow);
        if (bl) {
            this._sheet.addRow(hSSFRow.getRowRecord());
        }
        boolean bl3 = bl2 = this._rows.size() == 1;
        if (hSSFRow.getRowNum() > this.getLastRowNum() || bl2) {
            this._lastrow = hSSFRow.getRowNum();
        }
        if (hSSFRow.getRowNum() < this.getFirstRowNum() || bl2) {
            this._firstrow = hSSFRow.getRowNum();
        }
    }

    @Override
    public HSSFRow getRow(int n) {
        return this._rows.get(n);
    }

    @Override
    public int getPhysicalNumberOfRows() {
        return this._rows.size();
    }

    @Override
    public int getFirstRowNum() {
        return this._firstrow;
    }

    @Override
    public int getLastRowNum() {
        return this._lastrow;
    }

    public List<HSSFDataValidation> getDataValidations() {
        DataValidityTable dataValidityTable = this._sheet.getOrCreateDataValidityTable();
        final ArrayList<HSSFDataValidation> arrayList = new ArrayList<HSSFDataValidation>();
        RecordAggregate.RecordVisitor recordVisitor = new RecordAggregate.RecordVisitor(){
            private HSSFEvaluationWorkbook book;
            {
                this.book = HSSFEvaluationWorkbook.create(HSSFSheet.this.getWorkbook());
            }

            public void visitRecord(Record record) {
                if (!(record instanceof DVRecord)) {
                    return;
                }
                DVRecord dVRecord = (DVRecord)record;
                CellRangeAddressList cellRangeAddressList = dVRecord.getCellRangeAddress().copy();
                DVConstraint dVConstraint = DVConstraint.createDVConstraint(dVRecord, this.book);
                HSSFDataValidation hSSFDataValidation = new HSSFDataValidation(cellRangeAddressList, dVConstraint);
                hSSFDataValidation.setErrorStyle(dVRecord.getErrorStyle());
                hSSFDataValidation.setEmptyCellAllowed(dVRecord.getEmptyCellAllowed());
                hSSFDataValidation.setSuppressDropDownArrow(dVRecord.getSuppressDropdownArrow());
                hSSFDataValidation.createPromptBox(dVRecord.getPromptTitle(), dVRecord.getPromptText());
                hSSFDataValidation.setShowPromptBox(dVRecord.getShowPromptOnCellSelected());
                hSSFDataValidation.createErrorBox(dVRecord.getErrorTitle(), dVRecord.getErrorText());
                hSSFDataValidation.setShowErrorBox(dVRecord.getShowErrorOnInvalidValue());
                arrayList.add(hSSFDataValidation);
            }
        };
        dataValidityTable.visitContainedRecords(recordVisitor);
        return arrayList;
    }

    @Override
    public void addValidationData(DataValidation dataValidation) {
        if (dataValidation == null) {
            throw new IllegalArgumentException("objValidation must not be null");
        }
        HSSFDataValidation hSSFDataValidation = (HSSFDataValidation)dataValidation;
        DataValidityTable dataValidityTable = this._sheet.getOrCreateDataValidityTable();
        DVRecord dVRecord = hSSFDataValidation.createDVRecord(this);
        dataValidityTable.addDataValidation(dVRecord);
    }

    public void setColumnHidden(short s, boolean bl) {
        this.setColumnHidden(s & 0xFFFF, bl);
    }

    public boolean isColumnHidden(short s) {
        return this.isColumnHidden(s & 0xFFFF);
    }

    public void setColumnWidth(short s, short s2) {
        this.setColumnWidth(s & 0xFFFF, s2 & 0xFFFF);
    }

    public short getColumnWidth(short s) {
        return (short)this.getColumnWidth(s & 0xFFFF);
    }

    public void setDefaultColumnWidth(short s) {
        this.setDefaultColumnWidth(s & 0xFFFF);
    }

    @Override
    public void setColumnHidden(int n, boolean bl) {
        this._sheet.setColumnHidden(n, bl);
    }

    @Override
    public boolean isColumnHidden(int n) {
        return this._sheet.isColumnHidden(n);
    }

    @Override
    public void setColumnWidth(int n, int n2) {
        this._sheet.setColumnWidth(n, n2);
    }

    @Override
    public int getColumnWidth(int n) {
        return this._sheet.getColumnWidth(n);
    }

    @Override
    public float getColumnWidthInPixels(int n) {
        int n2;
        int n3 = this.getColumnWidth(n);
        float f = n3 == (n2 = this.getDefaultColumnWidth() * 256) ? 32.0f : 36.56f;
        return (float)n3 / f;
    }

    @Override
    public int getDefaultColumnWidth() {
        return this._sheet.getDefaultColumnWidth();
    }

    @Override
    public void setDefaultColumnWidth(int n) {
        this._sheet.setDefaultColumnWidth(n);
    }

    @Override
    public short getDefaultRowHeight() {
        return this._sheet.getDefaultRowHeight();
    }

    @Override
    public float getDefaultRowHeightInPoints() {
        return (float)this._sheet.getDefaultRowHeight() / 20.0f;
    }

    @Override
    public void setDefaultRowHeight(short s) {
        this._sheet.setDefaultRowHeight(s);
    }

    @Override
    public void setDefaultRowHeightInPoints(float f) {
        this._sheet.setDefaultRowHeight((short)(f * 20.0f));
    }

    @Override
    public HSSFCellStyle getColumnStyle(int n) {
        short s = this._sheet.getXFIndexForColAt((short)n);
        if (s == 15) {
            return null;
        }
        ExtendedFormatRecord extendedFormatRecord = this._book.getExFormatAt(s);
        return new HSSFCellStyle(s, extendedFormatRecord, this._book);
    }

    public boolean isGridsPrinted() {
        return this._sheet.isGridsPrinted();
    }

    public void setGridsPrinted(boolean bl) {
        this._sheet.setGridsPrinted(bl);
    }

    public int addMergedRegion(ai.org.apache.poi.ss.util.Region region) {
        return this._sheet.addMergedRegion(region.getRowFrom(), region.getColumnFrom(), region.getRowTo(), region.getColumnTo());
    }

    @Override
    public int addMergedRegion(CellRangeAddress cellRangeAddress) {
        cellRangeAddress.validate(SpreadsheetVersion.EXCEL97);
        this.validateArrayFormulas(cellRangeAddress);
        return this._sheet.addMergedRegion(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastRow(), cellRangeAddress.getLastColumn());
    }

    private void validateArrayFormulas(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                CellRangeAddress cellRangeAddress2;
                HSSFCell hSSFCell;
                HSSFRow hSSFRow = this.getRow(i);
                if (hSSFRow == null || (hSSFCell = hSSFRow.getCell(j)) == null || !hSSFCell.isPartOfArrayFormulaGroup() || (cellRangeAddress2 = hSSFCell.getArrayFormulaRange()).getNumberOfCells() <= 1 || !cellRangeAddress2.isInRange(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn()) && !cellRangeAddress2.isInRange(cellRangeAddress.getFirstRow(), cellRangeAddress.getFirstColumn())) continue;
                String string = "The range " + cellRangeAddress.formatAsString() + " intersects with a multi-cell array formula. " + "You cannot merge cells of an array.";
                throw new IllegalStateException(string);
            }
        }
    }

    @Override
    public void setForceFormulaRecalculation(boolean bl) {
        this._sheet.setUncalced(bl);
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        return this._sheet.getUncalced();
    }

    @Override
    public void setVerticallyCenter(boolean bl) {
        this._sheet.getPageSettings().getVCenter().setVCenter(bl);
    }

    public boolean getVerticallyCenter(boolean bl) {
        return this.getVerticallyCenter();
    }

    @Override
    public boolean getVerticallyCenter() {
        return this._sheet.getPageSettings().getVCenter().getVCenter();
    }

    @Override
    public void setHorizontallyCenter(boolean bl) {
        this._sheet.getPageSettings().getHCenter().setHCenter(bl);
    }

    @Override
    public boolean getHorizontallyCenter() {
        return this._sheet.getPageSettings().getHCenter().getHCenter();
    }

    @Override
    public void setRightToLeft(boolean bl) {
        this._sheet.getWindowTwo().setArabic(bl);
    }

    @Override
    public boolean isRightToLeft() {
        return this._sheet.getWindowTwo().getArabic();
    }

    @Override
    public void removeMergedRegion(int n) {
        this._sheet.removeMergedRegion(n);
    }

    @Override
    public int getNumMergedRegions() {
        return this._sheet.getNumMergedRegions();
    }

    public Region getMergedRegionAt(int n) {
        CellRangeAddress cellRangeAddress = this.getMergedRegion(n);
        return new Region(cellRangeAddress.getFirstRow(), (short)cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastRow(), (short)cellRangeAddress.getLastColumn());
    }

    @Override
    public CellRangeAddress getMergedRegion(int n) {
        return this._sheet.getMergedRegionAt(n);
    }

    @Override
    public Iterator<Row> rowIterator() {
        Iterator<Row> iterator = this._rows.values().iterator();
        return iterator;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    InternalSheet getSheet() {
        return this._sheet;
    }

    public void setAlternativeExpression(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAlternateExpression(bl);
    }

    public void setAlternativeFormula(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAlternateFormula(bl);
    }

    @Override
    public void setAutobreaks(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setAutobreaks(bl);
    }

    public void setDialog(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setDialog(bl);
    }

    @Override
    public void setDisplayGuts(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setDisplayGuts(bl);
    }

    @Override
    public void setFitToPage(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setFitToPage(bl);
    }

    @Override
    public void setRowSumsBelow(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setRowSumsBelow(bl);
        wSBoolRecord.setAlternateExpression(bl);
    }

    @Override
    public void setRowSumsRight(boolean bl) {
        WSBoolRecord wSBoolRecord = (WSBoolRecord)this._sheet.findFirstRecordBySid((short)129);
        wSBoolRecord.setRowSumsRight(bl);
    }

    public boolean getAlternateExpression() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateExpression();
    }

    public boolean getAlternateFormula() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAlternateFormula();
    }

    @Override
    public boolean getAutobreaks() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getAutobreaks();
    }

    public boolean getDialog() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDialog();
    }

    @Override
    public boolean getDisplayGuts() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getDisplayGuts();
    }

    @Override
    public boolean isDisplayZeros() {
        return this._sheet.getWindowTwo().getDisplayZeros();
    }

    @Override
    public void setDisplayZeros(boolean bl) {
        this._sheet.getWindowTwo().setDisplayZeros(bl);
    }

    @Override
    public boolean getFitToPage() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getFitToPage();
    }

    @Override
    public boolean getRowSumsBelow() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsBelow();
    }

    @Override
    public boolean getRowSumsRight() {
        return ((WSBoolRecord)this._sheet.findFirstRecordBySid((short)129)).getRowSumsRight();
    }

    @Override
    public boolean isPrintGridlines() {
        return this.getSheet().getPrintGridlines().getPrintGridlines();
    }

    @Override
    public void setPrintGridlines(boolean bl) {
        this.getSheet().getPrintGridlines().setPrintGridlines(bl);
    }

    @Override
    public HSSFPrintSetup getPrintSetup() {
        return new HSSFPrintSetup(this._sheet.getPageSettings().getPrintSetup());
    }

    @Override
    public HSSFHeader getHeader() {
        return new HSSFHeader(this._sheet.getPageSettings());
    }

    @Override
    public HSSFFooter getFooter() {
        return new HSSFFooter(this._sheet.getPageSettings());
    }

    @Override
    public boolean isSelected() {
        return this.getSheet().getWindowTwo().getSelected();
    }

    @Override
    public void setSelected(boolean bl) {
        this.getSheet().getWindowTwo().setSelected(bl);
    }

    public boolean isActive() {
        return this.getSheet().getWindowTwo().isActive();
    }

    public void setActive(boolean bl) {
        this.getSheet().getWindowTwo().setActive(bl);
    }

    @Override
    public double getMargin(short s) {
        switch (s) {
            case 5: {
                return this._sheet.getPageSettings().getPrintSetup().getFooterMargin();
            }
            case 4: {
                return this._sheet.getPageSettings().getPrintSetup().getHeaderMargin();
            }
        }
        return this._sheet.getPageSettings().getMargin(s);
    }

    @Override
    public void setMargin(short s, double d) {
        switch (s) {
            case 5: {
                this._sheet.getPageSettings().getPrintSetup().setFooterMargin(d);
                break;
            }
            case 4: {
                this._sheet.getPageSettings().getPrintSetup().setHeaderMargin(d);
                break;
            }
            default: {
                this._sheet.getPageSettings().setMargin(s, d);
            }
        }
    }

    private WorksheetProtectionBlock getProtectionBlock() {
        return this._sheet.getProtectionBlock();
    }

    @Override
    public boolean getProtect() {
        return this.getProtectionBlock().isSheetProtected();
    }

    public short getPassword() {
        return (short)this.getProtectionBlock().getPasswordHash();
    }

    public boolean getObjectProtect() {
        return this.getProtectionBlock().isObjectProtected();
    }

    @Override
    public boolean getScenarioProtect() {
        return this.getProtectionBlock().isScenarioProtected();
    }

    @Override
    public void protectSheet(String string) {
        this.getProtectionBlock().protectSheet(string, true, true);
    }

    @Override
    public void setZoom(int n, int n2) {
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("Numerator must be greater than 0 and less than 65536");
        }
        if (n2 < 1 || n2 > 65535) {
            throw new IllegalArgumentException("Denominator must be greater than 0 and less than 65536");
        }
        SCLRecord sCLRecord = new SCLRecord();
        sCLRecord.setNumerator((short)n);
        sCLRecord.setDenominator((short)n2);
        this.getSheet().setSCLRecord(sCLRecord);
    }

    @Override
    public short getTopRow() {
        return this._sheet.getTopRow();
    }

    @Override
    public short getLeftCol() {
        return this._sheet.getLeftCol();
    }

    @Override
    public void showInPane(int n, int n2) {
        int n3 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n > n3) {
            throw new IllegalArgumentException("Maximum row number is " + n3);
        }
        this.showInPane((short)n, (short)n2);
    }

    @Override
    public void showInPane(short s, short s2) {
        this._sheet.setTopRow(s);
        this._sheet.setLeftCol(s2);
    }

    protected void shiftMerged(int n, int n2, int n3, boolean bl) {
        ArrayList<CellRangeAddress> arrayList = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < this.getNumMergedRegions(); ++i) {
            boolean bl2;
            CellRangeAddress cellRangeAddress = this.getMergedRegion(i);
            boolean bl3 = cellRangeAddress.getFirstRow() >= n || cellRangeAddress.getLastRow() >= n;
            boolean bl4 = bl2 = cellRangeAddress.getFirstRow() <= n2 || cellRangeAddress.getLastRow() <= n2;
            if (!bl3 || !bl2 || SheetUtil.containsCell(cellRangeAddress, n - 1, 0) || SheetUtil.containsCell(cellRangeAddress, n2 + 1, 0)) continue;
            cellRangeAddress.setFirstRow(cellRangeAddress.getFirstRow() + n3);
            cellRangeAddress.setLastRow(cellRangeAddress.getLastRow() + n3);
            arrayList.add(cellRangeAddress);
            this.removeMergedRegion(i);
            --i;
        }
        for (CellRangeAddress cellRangeAddress : arrayList) {
            this.addMergedRegion(cellRangeAddress);
        }
    }

    @Override
    public void shiftRows(int n, int n2, int n3) {
        this.shiftRows(n, n2, n3, false, false);
    }

    @Override
    public void shiftRows(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.shiftRows(n, n2, n3, bl, bl2, true);
    }

    public void shiftRows(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        Object object3;
        int n4;
        block18: {
            block17: {
                int n5;
                int n6;
                if (n3 < 0) {
                    n6 = n;
                    n5 = 1;
                } else if (n3 > 0) {
                    n6 = n2;
                    n5 = -1;
                } else {
                    return;
                }
                NoteRecord[] noteRecordArray = bl3 ? this._sheet.getNoteRecords() : NoteRecord.EMPTY_ARRAY;
                this.shiftMerged(n, n2, n3, true);
                this._sheet.getPageSettings().shiftRowBreaks(n, n2, n3);
                for (n4 = n6; n4 >= n && n4 <= n2 && n4 >= 0 && n4 < 65536; n4 += n5) {
                    Object object4;
                    HSSFRow hSSFRow;
                    object3 = this.getRow(n4);
                    if (object3 != null) {
                        this.notifyRowShifting((HSSFRow)object3);
                    }
                    if ((hSSFRow = this.getRow(n4 + n3)) == null) {
                        hSSFRow = this.createRow(n4 + n3);
                    }
                    hSSFRow.removeAllCells();
                    if (object3 == null) continue;
                    if (bl) {
                        hSSFRow.setHeight(((HSSFRow)object3).getHeight());
                    }
                    if (bl2) {
                        ((HSSFRow)object3).setHeight((short)255);
                    }
                    object2 = ((HSSFRow)object3).cellIterator();
                    while (object2.hasNext()) {
                        HSSFCell hSSFCell = (HSSFCell)object2.next();
                        ((HSSFRow)object3).removeCell(hSSFCell);
                        object4 = hSSFCell.getCellValueRecord();
                        object4.setRow(n4 + n3);
                        hSSFRow.createCellFromRecord((CellValueRecordInterface)object4);
                        this._sheet.addValueRecord(n4 + n3, (CellValueRecordInterface)object4);
                        object = hSSFCell.getHyperlink();
                        if (object == null) continue;
                        ((HSSFHyperlink)object).setFirstRow(((HSSFHyperlink)object).getFirstRow() + n3);
                        ((HSSFHyperlink)object).setLastRow(((HSSFHyperlink)object).getLastRow() + n3);
                    }
                    ((HSSFRow)object3).removeAllCells();
                    if (!bl3) continue;
                    object2 = this.createDrawingPatriarch();
                    for (int i = ((HSSFPatriarch)object2).getChildren().size() - 1; i >= 0; --i) {
                        object4 = ((HSSFPatriarch)object2).getChildren().get(i);
                        if (!(object4 instanceof HSSFComment) || ((HSSFComment)(object = (HSSFComment)object4)).getRow() != n4) continue;
                        ((HSSFComment)object).setRow(n4 + n3);
                    }
                }
                if (n3 <= 0) break block17;
                if (n == this._firstrow) {
                    this._firstrow = Math.max(n + n3, 0);
                    for (n4 = n + 1; n4 < n + n3; ++n4) {
                        if (this.getRow(n4) == null) continue;
                        this._firstrow = n4;
                        break;
                    }
                }
                if (n2 + n3 <= this._lastrow) break block18;
                this._lastrow = Math.min(n2 + n3, SpreadsheetVersion.EXCEL97.getLastRowIndex());
                break block18;
            }
            if (n + n3 < this._firstrow) {
                this._firstrow = Math.max(n + n3, 0);
            }
            if (n2 == this._lastrow) {
                this._lastrow = Math.min(n2 + n3, SpreadsheetVersion.EXCEL97.getLastRowIndex());
                for (n4 = n2 - 1; n4 > n2 + n3; ++n4) {
                    if (this.getRow(n4) == null) continue;
                    this._lastrow = n4;
                    break;
                }
            }
        }
        n4 = this._workbook.getSheetIndex(this);
        object3 = this._workbook.getSheetName(n4);
        short s = this._book.checkExternSheet(n4);
        object2 = FormulaShifter.createForRowShift(s, (String)object3, n, n2, n3);
        this._sheet.updateFormulasAfterCellShift((FormulaShifter)object2, s);
        int n7 = this._workbook.getNumberOfSheets();
        for (int i = 0; i < n7; ++i) {
            object = this._workbook.getSheetAt(i).getSheet();
            if (object == this._sheet) continue;
            short s2 = this._book.checkExternSheet(i);
            ((InternalSheet)object).updateFormulasAfterCellShift((FormulaShifter)object2, s2);
        }
        this._workbook.getWorkbook().updateNamesAfterCellShift((FormulaShifter)object2);
    }

    protected void insertChartRecords(List<Record> list) {
        int n = this._sheet.findFirstRecordLocBySid((short)574);
        this._sheet.getRecords().addAll(n, list);
    }

    private void notifyRowShifting(HSSFRow hSSFRow) {
        String string = "Row[rownum=" + hSSFRow.getRowNum() + "] contains cell(s) included in a multi-cell array formula. " + "You cannot change part of an array.";
        for (Cell cell : hSSFRow) {
            HSSFCell hSSFCell = (HSSFCell)cell;
            if (!hSSFCell.isPartOfArrayFormulaGroup()) continue;
            hSSFCell.notifyArrayFormulaChanging(string);
        }
    }

    @Override
    public void createFreezePane(int n, int n2, int n3, int n4) {
        this.validateColumn(n);
        this.validateRow(n2);
        if (n3 < n) {
            throw new IllegalArgumentException("leftmostColumn parameter must not be less than colSplit parameter");
        }
        if (n4 < n2) {
            throw new IllegalArgumentException("topRow parameter must not be less than leftmostColumn parameter");
        }
        this.getSheet().createFreezePane(n, n2, n4, n3);
    }

    @Override
    public void createFreezePane(int n, int n2) {
        this.createFreezePane(n, n2, n, n2);
    }

    @Override
    public void createSplitPane(int n, int n2, int n3, int n4, int n5) {
        this.getSheet().createSplitPane(n, n2, n4, n3, n5);
    }

    @Override
    public PaneInformation getPaneInformation() {
        return this.getSheet().getPaneInformation();
    }

    @Override
    public void setDisplayGridlines(boolean bl) {
        this._sheet.setDisplayGridlines(bl);
    }

    @Override
    public boolean isDisplayGridlines() {
        return this._sheet.isDisplayGridlines();
    }

    @Override
    public void setDisplayFormulas(boolean bl) {
        this._sheet.setDisplayFormulas(bl);
    }

    @Override
    public boolean isDisplayFormulas() {
        return this._sheet.isDisplayFormulas();
    }

    @Override
    public void setDisplayRowColHeadings(boolean bl) {
        this._sheet.setDisplayRowColHeadings(bl);
    }

    @Override
    public boolean isDisplayRowColHeadings() {
        return this._sheet.isDisplayRowColHeadings();
    }

    @Override
    public void setRowBreak(int n) {
        this.validateRow(n);
        this._sheet.getPageSettings().setRowBreak(n, (short)0, (short)255);
    }

    @Override
    public boolean isRowBroken(int n) {
        return this._sheet.getPageSettings().isRowBroken(n);
    }

    @Override
    public void removeRowBreak(int n) {
        this._sheet.getPageSettings().removeRowBreak(n);
    }

    @Override
    public int[] getRowBreaks() {
        return this._sheet.getPageSettings().getRowBreaks();
    }

    @Override
    public int[] getColumnBreaks() {
        return this._sheet.getPageSettings().getColumnBreaks();
    }

    @Override
    public void setColumnBreak(int n) {
        this.validateColumn((short)n);
        this._sheet.getPageSettings().setColumnBreak((short)n, (short)0, (short)SpreadsheetVersion.EXCEL97.getLastRowIndex());
    }

    @Override
    public boolean isColumnBroken(int n) {
        return this._sheet.getPageSettings().isColumnBroken(n);
    }

    @Override
    public void removeColumnBreak(int n) {
        this._sheet.getPageSettings().removeColumnBreak(n);
    }

    protected void validateRow(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n > n2) {
            throw new IllegalArgumentException("Maximum row number is " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Minumum row number is 0");
        }
    }

    protected void validateColumn(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        if (n > n2) {
            throw new IllegalArgumentException("Maximum column number is " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Minimum column number is 0");
        }
    }

    public void dumpDrawingRecords(boolean bl) {
        this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        EscherAggregate escherAggregate = (EscherAggregate)this.getSheet().findFirstRecordBySid((short)9876);
        List<EscherRecord> list = escherAggregate.getEscherRecords();
        PrintWriter printWriter = new PrintWriter(System.out);
        for (EscherRecord escherRecord : list) {
            if (bl) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(printWriter, 0);
        }
        printWriter.flush();
    }

    public EscherAggregate getDrawingEscherAggregate() {
        this._book.findDrawingGroup();
        if (this._book.getDrawingManager() == null) {
            return null;
        }
        int n = this._sheet.aggregateDrawingRecords(this._book.getDrawingManager(), false);
        if (n == -1) {
            return null;
        }
        EscherAggregate escherAggregate = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876);
        return escherAggregate;
    }

    public HSSFPatriarch getDrawingPatriarch() {
        this._patriarch = this.getPatriarch(false);
        return this._patriarch;
    }

    @Override
    public HSSFPatriarch createDrawingPatriarch() {
        this._patriarch = this.getPatriarch(true);
        return this._patriarch;
    }

    private HSSFPatriarch getPatriarch(boolean bl) {
        EscherAggregate escherAggregate;
        HSSFPatriarch hSSFPatriarch = null;
        if (this._patriarch != null) {
            return this._patriarch;
        }
        DrawingManager2 drawingManager2 = this._book.findDrawingGroup();
        if (null == drawingManager2) {
            if (!bl) {
                return null;
            }
            this._book.createDrawingGroup();
            drawingManager2 = this._book.getDrawingManager();
        }
        if (null == (escherAggregate = (EscherAggregate)this._sheet.findFirstRecordBySid((short)9876))) {
            int n = this._sheet.aggregateDrawingRecords(drawingManager2, false);
            if (-1 == n) {
                if (bl) {
                    n = this._sheet.aggregateDrawingRecords(drawingManager2, true);
                    escherAggregate = (EscherAggregate)this._sheet.getRecords().get(n);
                    hSSFPatriarch = new HSSFPatriarch(this, escherAggregate);
                    hSSFPatriarch.afterCreate();
                    return hSSFPatriarch;
                }
                return null;
            }
            escherAggregate = (EscherAggregate)this._sheet.getRecords().get(n);
        }
        return new HSSFPatriarch(this, escherAggregate);
    }

    public void setColumnGroupCollapsed(short s, boolean bl) {
        this.setColumnGroupCollapsed(s & 0xFFFF, bl);
    }

    public void groupColumn(short s, short s2) {
        this.groupColumn(s & 0xFFFF, s2 & 0xFFFF);
    }

    public void ungroupColumn(short s, short s2) {
        this.ungroupColumn(s & 0xFFFF, s2 & 0xFFFF);
    }

    @Override
    public void setColumnGroupCollapsed(int n, boolean bl) {
        this._sheet.setColumnGroupCollapsed(n, bl);
    }

    @Override
    public void groupColumn(int n, int n2) {
        this._sheet.groupColumnRange(n, n2, true);
    }

    @Override
    public void ungroupColumn(int n, int n2) {
        this._sheet.groupColumnRange(n, n2, false);
    }

    @Override
    public void groupRow(int n, int n2) {
        this._sheet.groupRowRange(n, n2, true);
    }

    @Override
    public void ungroupRow(int n, int n2) {
        this._sheet.groupRowRange(n, n2, false);
    }

    @Override
    public void setRowGroupCollapsed(int n, boolean bl) {
        if (bl) {
            this._sheet.getRowsAggregate().collapseRow(n);
        } else {
            this._sheet.getRowsAggregate().expandRow(n);
        }
    }

    @Override
    public void setDefaultColumnStyle(int n, CellStyle cellStyle) {
        this._sheet.setDefaultColumnStyle(n, ((HSSFCellStyle)cellStyle).getIndex());
    }

    @Override
    public void autoSizeColumn(int n) {
        this.autoSizeColumn(n, false);
    }

    @Override
    public void autoSizeColumn(int n, boolean bl) {
        double d = SheetUtil.getColumnWidth(this, n, bl);
        if (d != -1.0) {
            int n2 = 65280;
            if ((d *= 256.0) > (double)n2) {
                d = n2;
            }
            this.setColumnWidth(n, (int)d);
        }
    }

    @Override
    public HSSFComment getCellComment(int n, int n2) {
        return this.findCellComment(n, n2);
    }

    @Override
    public HSSFSheetConditionalFormatting getSheetConditionalFormatting() {
        return new HSSFSheetConditionalFormatting(this);
    }

    @Override
    public String getSheetName() {
        HSSFWorkbook hSSFWorkbook = this.getWorkbook();
        int n = hSSFWorkbook.getSheetIndex(this);
        return hSSFWorkbook.getSheetName(n);
    }

    private CellRange<HSSFCell> getCellRange(CellRangeAddress cellRangeAddress) {
        int n = cellRangeAddress.getFirstRow();
        int n2 = cellRangeAddress.getFirstColumn();
        int n3 = cellRangeAddress.getLastRow();
        int n4 = cellRangeAddress.getLastColumn();
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        ArrayList<HSSFCell> arrayList = new ArrayList<HSSFCell>(n5 * n6);
        for (int i = n; i <= n3; ++i) {
            for (int j = n2; j <= n4; ++j) {
                HSSFCell hSSFCell;
                HSSFRow hSSFRow = this.getRow(i);
                if (hSSFRow == null) {
                    hSSFRow = this.createRow(i);
                }
                if ((hSSFCell = hSSFRow.getCell(j)) == null) {
                    hSSFCell = hSSFRow.createCell(j);
                }
                arrayList.add(hSSFCell);
            }
        }
        return SSCellRange.create(n, n2, n5, n6, arrayList, HSSFCell.class);
    }

    public CellRange<HSSFCell> setArrayFormula(String string, CellRangeAddress cellRangeAddress) {
        int n = this._workbook.getSheetIndex(this);
        Ptg[] ptgArray = HSSFFormulaParser.parse(string, this._workbook, 2, n);
        CellRange<HSSFCell> cellRange = this.getCellRange(cellRangeAddress);
        for (HSSFCell object2 : cellRange) {
            object2.setCellArrayFormula(cellRangeAddress);
        }
        HSSFCell hSSFCell = cellRange.getTopLeftCell();
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)hSSFCell.getCellValueRecord();
        formulaRecordAggregate.setArrayFormula(cellRangeAddress, ptgArray);
        return cellRange;
    }

    public CellRange<HSSFCell> removeArrayFormula(Cell cell) {
        if (cell.getSheet() != this) {
            throw new IllegalArgumentException("Specified cell does not belong to this sheet.");
        }
        CellValueRecordInterface cellValueRecordInterface = ((HSSFCell)cell).getCellValueRecord();
        if (!(cellValueRecordInterface instanceof FormulaRecordAggregate)) {
            String string = new CellReference(cell).formatAsString();
            throw new IllegalArgumentException("Cell " + string + " is not part of an array formula.");
        }
        FormulaRecordAggregate formulaRecordAggregate = (FormulaRecordAggregate)cellValueRecordInterface;
        CellRangeAddress cellRangeAddress = formulaRecordAggregate.removeArrayFormula(cell.getRowIndex(), cell.getColumnIndex());
        CellRange<HSSFCell> cellRange = this.getCellRange(cellRangeAddress);
        for (Cell cell2 : cellRange) {
            cell2.setCellType(3);
        }
        return cellRange;
    }

    @Override
    public DataValidationHelper getDataValidationHelper() {
        return new HSSFDataValidationHelper(this);
    }

    @Override
    public HSSFAutoFilter setAutoFilter(CellRangeAddress cellRangeAddress) {
        int n;
        int n2;
        InternalWorkbook internalWorkbook = this._workbook.getWorkbook();
        NameRecord nameRecord = internalWorkbook.getSpecificBuiltinRecord((byte)13, (n2 = this._workbook.getSheetIndex(this)) + 1);
        if (nameRecord == null) {
            nameRecord = internalWorkbook.createBuiltInName((byte)13, n2 + 1);
        }
        if ((n = cellRangeAddress.getFirstRow()) == -1) {
            n = 0;
        }
        Area3DPtg area3DPtg = new Area3DPtg(n, cellRangeAddress.getLastRow(), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn(), false, false, false, false, n2);
        nameRecord.setNameDefinition(new Ptg[]{area3DPtg});
        AutoFilterInfoRecord autoFilterInfoRecord = new AutoFilterInfoRecord();
        int n3 = 1 + cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn();
        autoFilterInfoRecord.setNumEntries((short)n3);
        int n4 = this._sheet.findFirstRecordLocBySid((short)512);
        this._sheet.getRecords().add(n4, autoFilterInfoRecord);
        HSSFPatriarch hSSFPatriarch = this.createDrawingPatriarch();
        for (int i = cellRangeAddress.getFirstColumn(); i <= cellRangeAddress.getLastColumn(); ++i) {
            hSSFPatriarch.createComboBox(new HSSFClientAnchor(0, 0, 0, 0, (short)i, n, (short)(i + 1), n + 1));
        }
        return new HSSFAutoFilter(this);
    }

    protected HSSFComment findCellComment(int n, int n2) {
        HSSFPatriarch hSSFPatriarch = this.getDrawingPatriarch();
        if (null == hSSFPatriarch) {
            hSSFPatriarch = this.createDrawingPatriarch();
        }
        return this.lookForComment(hSSFPatriarch, n, n2);
    }

    private HSSFComment lookForComment(HSSFShapeContainer hSSFShapeContainer, int n, int n2) {
        for (HSSFShape hSSFShape : hSSFShapeContainer.getChildren()) {
            HSSFComment hSSFComment;
            HSSFShape hSSFShape2 = hSSFShape;
            if (!(hSSFShape2 instanceof HSSFShapeGroup ? null != (hSSFComment = this.lookForComment((HSSFShapeContainer)((Object)hSSFShape2), n, n2)) : hSSFShape2 instanceof HSSFComment && (hSSFComment = (HSSFComment)hSSFShape2).hasPosition() && hSSFComment.getColumn() == n2 && hSSFComment.getRow() == n)) continue;
            return hSSFComment;
        }
        return null;
    }

    @Override
    public CellRangeAddress getRepeatingRows() {
        return this.getRepeatingRowsOrColums(true);
    }

    @Override
    public CellRangeAddress getRepeatingColumns() {
        return this.getRepeatingRowsOrColums(false);
    }

    @Override
    public void setRepeatingRows(CellRangeAddress cellRangeAddress) {
        CellRangeAddress cellRangeAddress2 = this.getRepeatingColumns();
        this.setRepeatingRowsAndColumns(cellRangeAddress, cellRangeAddress2);
    }

    @Override
    public void setRepeatingColumns(CellRangeAddress cellRangeAddress) {
        CellRangeAddress cellRangeAddress2 = this.getRepeatingRows();
        this.setRepeatingRowsAndColumns(cellRangeAddress2, cellRangeAddress);
    }

    private void setRepeatingRowsAndColumns(CellRangeAddress cellRangeAddress, CellRangeAddress cellRangeAddress2) {
        Object object;
        int n = this._workbook.getSheetIndex(this);
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        int n3 = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (cellRangeAddress != null) {
            n6 = cellRangeAddress.getFirstRow();
            n7 = cellRangeAddress.getLastRow();
            if (n6 == -1 && n7 != -1 || n6 > n7 || n6 < 0 || n6 > n2 || n7 < 0 || n7 > n2) {
                throw new IllegalArgumentException("Invalid row range specification");
            }
        }
        if (cellRangeAddress2 != null) {
            n4 = cellRangeAddress2.getFirstColumn();
            n5 = cellRangeAddress2.getLastColumn();
            if (n4 == -1 && n5 != -1 || n4 > n5 || n4 < 0 || n4 > n3 || n5 < 0 || n5 > n3) {
                throw new IllegalArgumentException("Invalid column range specification");
            }
        }
        short s = this._workbook.getWorkbook().checkExternSheet(n);
        boolean bl = cellRangeAddress != null && cellRangeAddress2 != null;
        boolean bl2 = cellRangeAddress == null && cellRangeAddress2 == null;
        HSSFName hSSFName = this._workbook.getBuiltInName((byte)7, n);
        if (bl2) {
            if (hSSFName != null) {
                this._workbook.removeName(hSSFName);
            }
            return;
        }
        if (hSSFName == null) {
            hSSFName = this._workbook.createBuiltInName((byte)7, n);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl) {
            arrayList.add(new MemFuncPtg(23));
        }
        if (cellRangeAddress2 != null) {
            object = new Area3DPtg(0, n2, n4, n5, false, false, false, false, s);
            arrayList.add(object);
        }
        if (cellRangeAddress != null) {
            object = new Area3DPtg(n6, n7, 0, n3, false, false, false, false, s);
            arrayList.add(object);
        }
        if (bl) {
            arrayList.add(UnionPtg.instance);
        }
        object = new Ptg[arrayList.size()];
        arrayList.toArray((T[])object);
        hSSFName.setNameDefinition((Ptg[])object);
        HSSFPrintSetup hSSFPrintSetup = this.getPrintSetup();
        hSSFPrintSetup.setValidSettings(false);
        this.setActive(true);
    }

    private CellRangeAddress getRepeatingRowsOrColums(boolean bl) {
        NameRecord nameRecord = this.getBuiltinNameRecord((byte)7);
        if (nameRecord == null) {
            return null;
        }
        Ptg[] ptgArray = nameRecord.getNameDefinition();
        if (ptgArray == null) {
            return null;
        }
        int n = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        int n2 = SpreadsheetVersion.EXCEL97.getLastColumnIndex();
        for (Ptg ptg : ptgArray) {
            if (!(ptg instanceof Area3DPtg)) continue;
            Area3DPtg area3DPtg = (Area3DPtg)ptg;
            if (area3DPtg.getFirstColumn() == 0 && area3DPtg.getLastColumn() == n2) {
                if (!bl) continue;
                CellRangeAddress cellRangeAddress = new CellRangeAddress(area3DPtg.getFirstRow(), area3DPtg.getLastRow(), -1, -1);
                return cellRangeAddress;
            }
            if (area3DPtg.getFirstRow() != 0 || area3DPtg.getLastRow() != n || bl) continue;
            CellRangeAddress cellRangeAddress = new CellRangeAddress(-1, -1, area3DPtg.getFirstColumn(), area3DPtg.getLastColumn());
            return cellRangeAddress;
        }
        return null;
    }

    private NameRecord getBuiltinNameRecord(byte by) {
        int n = this._workbook.getSheetIndex(this);
        int n2 = this._workbook.findExistingBuiltinNameRecordIdx(n, by);
        if (n2 == -1) {
            return null;
        }
        return this._workbook.getNameRecord(n2);
    }
}

