/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.InternalWorkbook;
import ai.org.apache.poi.hssf.record.LabelSSTRecord;
import ai.org.apache.poi.hssf.record.common.UnicodeString;
import ai.org.apache.poi.hssf.usermodel.HSSFFont;
import ai.org.apache.poi.ss.usermodel.Font;
import ai.org.apache.poi.ss.usermodel.RichTextString;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSSFRichTextString
implements Comparable<HSSFRichTextString>,
RichTextString {
    public static final short NO_FONT = 0;
    private UnicodeString _string;
    private InternalWorkbook _book;
    private LabelSSTRecord _record;

    public HSSFRichTextString() {
        this("");
    }

    public HSSFRichTextString(String string) {
        this._string = string == null ? new UnicodeString("") : new UnicodeString(string);
    }

    HSSFRichTextString(InternalWorkbook internalWorkbook, LabelSSTRecord labelSSTRecord) {
        this.setWorkbookReferences(internalWorkbook, labelSSTRecord);
        this._string = internalWorkbook.getSSTString(labelSSTRecord.getSSTIndex());
    }

    void setWorkbookReferences(InternalWorkbook internalWorkbook, LabelSSTRecord labelSSTRecord) {
        this._book = internalWorkbook;
        this._record = labelSSTRecord;
    }

    private UnicodeString cloneStringIfRequired() {
        if (this._book == null) {
            return this._string;
        }
        UnicodeString unicodeString = (UnicodeString)this._string.clone();
        return unicodeString;
    }

    private void addToSSTIfRequired() {
        if (this._book != null) {
            int n = this._book.addSSTString(this._string);
            this._record.setSSTIndex(n);
            this._string = this._book.getSSTString(n);
        }
    }

    @Override
    public void applyFont(int n, int n2, short s) {
        if (n > n2) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
        if (n < 0 || n2 > this.length()) {
            throw new IllegalArgumentException("Start and end index not in range.");
        }
        if (n == n2) {
            return;
        }
        short s2 = 0;
        if (n2 != this.length()) {
            s2 = this.getFontAtIndex(n2);
        }
        this._string = this.cloneStringIfRequired();
        Iterator<UnicodeString.FormatRun> iterator = this._string.formatIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                UnicodeString.FormatRun formatRun = iterator.next();
                if (formatRun.getCharacterPos() < n || formatRun.getCharacterPos() >= n2) continue;
                iterator.remove();
            }
        }
        this._string.addFormatRun(new UnicodeString.FormatRun((short)n, s));
        if (n2 != this.length()) {
            this._string.addFormatRun(new UnicodeString.FormatRun((short)n2, s2));
        }
        this.addToSSTIfRequired();
    }

    @Override
    public void applyFont(int n, int n2, Font font) {
        this.applyFont(n, n2, ((HSSFFont)font).getIndex());
    }

    @Override
    public void applyFont(Font font) {
        this.applyFont(0, this._string.getCharCount(), font);
    }

    @Override
    public void clearFormatting() {
        this._string = this.cloneStringIfRequired();
        this._string.clearFormatting();
        this.addToSSTIfRequired();
    }

    @Override
    public String getString() {
        return this._string.getString();
    }

    UnicodeString getUnicodeString() {
        return this.cloneStringIfRequired();
    }

    UnicodeString getRawUnicodeString() {
        return this._string;
    }

    void setUnicodeString(UnicodeString unicodeString) {
        this._string = unicodeString;
    }

    @Override
    public int length() {
        return this._string.getCharCount();
    }

    public short getFontAtIndex(int n) {
        UnicodeString.FormatRun formatRun;
        int n2 = this._string.getFormatRunCount();
        UnicodeString.FormatRun formatRun2 = null;
        for (int i = 0; i < n2 && (formatRun = this._string.getFormatRun(i)).getCharacterPos() <= n; ++i) {
            formatRun2 = formatRun;
        }
        if (formatRun2 == null) {
            return 0;
        }
        return formatRun2.getFontIndex();
    }

    @Override
    public int numFormattingRuns() {
        return this._string.getFormatRunCount();
    }

    @Override
    public int getIndexOfFormattingRun(int n) {
        UnicodeString.FormatRun formatRun = this._string.getFormatRun(n);
        return formatRun.getCharacterPos();
    }

    public short getFontOfFormattingRun(int n) {
        UnicodeString.FormatRun formatRun = this._string.getFormatRun(n);
        return formatRun.getFontIndex();
    }

    @Override
    public int compareTo(HSSFRichTextString hSSFRichTextString) {
        return this._string.compareTo(hSSFRichTextString._string);
    }

    public boolean equals(Object object) {
        if (object instanceof HSSFRichTextString) {
            return this._string.equals(((HSSFRichTextString)object)._string);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        return this._string.toString();
    }

    @Override
    public void applyFont(short s) {
        this.applyFont(0, this._string.getCharCount(), s);
    }
}

