/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.EscherArrayProperty;
import ai.org.apache.poi.ddf.EscherBoolProperty;
import ai.org.apache.poi.ddf.EscherClientDataRecord;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherOptRecord;
import ai.org.apache.poi.ddf.EscherRGBProperty;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.ddf.EscherShapePathProperty;
import ai.org.apache.poi.ddf.EscherSimpleProperty;
import ai.org.apache.poi.ddf.EscherSpRecord;
import ai.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai.org.apache.poi.hssf.record.EndSubRecord;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.record.TextObjectRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFSimpleShape;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;

public class HSSFPolygon
extends HSSFSimpleShape {
    private static POILogger logger = POILogFactory.getLogger(HSSFPolygon.class);
    public static final short OBJECT_TYPE_MICROSOFT_OFFICE_DRAWING = 30;

    public HSSFPolygon(EscherContainerRecord escherContainerRecord, ObjRecord objRecord, TextObjectRecord textObjectRecord) {
        super(escherContainerRecord, objRecord, textObjectRecord);
    }

    public HSSFPolygon(EscherContainerRecord escherContainerRecord, ObjRecord objRecord) {
        super(escherContainerRecord, objRecord);
    }

    HSSFPolygon(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
    }

    protected TextObjectRecord createTextObjRecord() {
        return null;
    }

    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherContainerRecord.setRecordId((short)-4092);
        escherContainerRecord.setOptions((short)15);
        escherSpRecord.setRecordId((short)-4086);
        escherSpRecord.setOptions((short)2);
        if (this.getParent() == null) {
            escherSpRecord.setFlags(2560);
        } else {
            escherSpRecord.setFlags(2562);
        }
        escherOptRecord.setRecordId((short)-4085);
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(4, false, false, 0));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(322, false, false, 100));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(323, false, false, 100));
        escherOptRecord.setEscherProperty(new EscherShapePathProperty(324, 4));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(383, false, false, 65537));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(464, false, false, 0));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(465, false, false, 0));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(471, false, false, 0));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(462, 0));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(511, 524296));
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(459, 9525));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(385, 0x8000009));
        escherOptRecord.setEscherProperty(new EscherRGBProperty(448, 0x8000040));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(447, 1));
        escherOptRecord.setEscherProperty(new EscherBoolProperty(959, 524288));
        EscherRecord escherRecord = this.getAnchor().getEscherAnchor();
        escherClientDataRecord.setRecordId((short)-4079);
        escherClientDataRecord.setOptions((short)0);
        escherContainerRecord.addChildRecord(escherSpRecord);
        escherContainerRecord.addChildRecord(escherOptRecord);
        escherContainerRecord.addChildRecord(escherRecord);
        escherContainerRecord.addChildRecord(escherClientDataRecord);
        return escherContainerRecord;
    }

    protected ObjRecord createObjRecord() {
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)30);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(true);
        commonObjectDataSubRecord.setAutoline(true);
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    protected void afterRemove(HSSFPatriarch hSSFPatriarch) {
        hSSFPatriarch._getBoundAggregate().removeShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079));
    }

    public int[] getXPoints() {
        EscherArrayProperty escherArrayProperty = (EscherArrayProperty)this.getOptRecord().lookup(325);
        if (null == escherArrayProperty) {
            return new int[0];
        }
        int[] nArray = new int[escherArrayProperty.getNumberOfElementsInArray() - 1];
        for (int i = 0; i < escherArrayProperty.getNumberOfElementsInArray() - 1; ++i) {
            byte[] byArray = escherArrayProperty.getElement(i);
            short s = LittleEndian.getShort(byArray, 0);
            nArray[i] = s;
        }
        return nArray;
    }

    public int[] getYPoints() {
        EscherArrayProperty escherArrayProperty = (EscherArrayProperty)this.getOptRecord().lookup(325);
        if (null == escherArrayProperty) {
            return new int[0];
        }
        int[] nArray = new int[escherArrayProperty.getNumberOfElementsInArray() - 1];
        for (int i = 0; i < escherArrayProperty.getNumberOfElementsInArray() - 1; ++i) {
            byte[] byArray = escherArrayProperty.getElement(i);
            short s = LittleEndian.getShort(byArray, 2);
            nArray[i] = s;
        }
        return nArray;
    }

    public void setPoints(int[] nArray, int[] nArray2) {
        byte[] byArray;
        int n;
        if (nArray.length != nArray2.length) {
            logger.log(7, "xPoint.length must be equal to yPoints.length");
            return;
        }
        if (nArray.length == 0) {
            logger.log(7, "HSSFPolygon must have at least one point");
        }
        EscherArrayProperty escherArrayProperty = new EscherArrayProperty(325, false, new byte[0]);
        escherArrayProperty.setNumberOfElementsInArray(nArray.length + 1);
        escherArrayProperty.setNumberOfElementsInMemory(nArray.length + 1);
        escherArrayProperty.setSizeOfElements(65520);
        for (n = 0; n < nArray.length; ++n) {
            byArray = new byte[4];
            LittleEndian.putShort(byArray, 0, (short)nArray[n]);
            LittleEndian.putShort(byArray, 2, (short)nArray2[n]);
            escherArrayProperty.setElement(n, byArray);
        }
        n = nArray.length;
        byArray = new byte[4];
        LittleEndian.putShort(byArray, 0, (short)nArray[0]);
        LittleEndian.putShort(byArray, 2, (short)nArray2[0]);
        escherArrayProperty.setElement(n, byArray);
        this.setPropertyValue(escherArrayProperty);
        EscherArrayProperty escherArrayProperty2 = new EscherArrayProperty(326, false, null);
        escherArrayProperty2.setSizeOfElements(2);
        escherArrayProperty2.setNumberOfElementsInArray(nArray.length * 2 + 4);
        escherArrayProperty2.setNumberOfElementsInMemory(nArray.length * 2 + 4);
        escherArrayProperty2.setElement(0, new byte[]{0, 64});
        escherArrayProperty2.setElement(1, new byte[]{0, -84});
        for (int i = 0; i < nArray.length; ++i) {
            escherArrayProperty2.setElement(2 + i * 2, new byte[]{1, 0});
            escherArrayProperty2.setElement(3 + i * 2, new byte[]{0, -84});
        }
        escherArrayProperty2.setElement(escherArrayProperty2.getNumberOfElementsInArray() - 2, new byte[]{1, 96});
        escherArrayProperty2.setElement(escherArrayProperty2.getNumberOfElementsInArray() - 1, new byte[]{0, -128});
        this.setPropertyValue(escherArrayProperty2);
    }

    public void setPolygonDrawArea(int n, int n2) {
        this.setPropertyValue(new EscherSimpleProperty(322, n));
        this.setPropertyValue(new EscherSimpleProperty(323, n2));
    }

    public int getDrawAreaWidth() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(322);
        return escherSimpleProperty == null ? 100 : escherSimpleProperty.getPropertyValue();
    }

    public int getDrawAreaHeight() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(323);
        return escherSimpleProperty == null ? 100 : escherSimpleProperty.getPropertyValue();
    }
}

