/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai.org.apache.poi.ddf.EscherBSERecord;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherRecord;
import ai.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import ai.org.apache.poi.hssf.record.EscherAggregate;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.record.SubRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFPicture;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.poifs.filesystem.DirectoryEntry;
import ai.org.apache.poi.poifs.filesystem.Entry;
import ai.org.apache.poi.util.HexDump;
import java.io.IOException;

public final class HSSFObjectData
extends HSSFPicture {
    private final DirectoryEntry _root;

    public HSSFObjectData(EscherContainerRecord escherContainerRecord, ObjRecord objRecord, DirectoryEntry directoryEntry) {
        super(escherContainerRecord, objRecord);
        this._root = directoryEntry;
    }

    public String getOLE2ClassName() {
        return this.findObjectRecord().getOLEClassName();
    }

    public DirectoryEntry getDirectory() throws IOException {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        int n = embeddedObjectRefSubRecord.getStreamId();
        String string = "MBD" + HexDump.toHex(n);
        Entry entry = this._root.getEntry(string);
        if (entry instanceof DirectoryEntry) {
            return (DirectoryEntry)entry;
        }
        throw new IOException("Stream " + string + " was not an OLE2 directory");
    }

    public byte[] getObjectData() {
        return this.findObjectRecord().getObjectData();
    }

    public boolean hasDirectoryEntry() {
        EmbeddedObjectRefSubRecord embeddedObjectRefSubRecord = this.findObjectRecord();
        Integer n = embeddedObjectRefSubRecord.getStreamId();
        return n != null && n != 0;
    }

    protected EmbeddedObjectRefSubRecord findObjectRecord() {
        for (SubRecord subRecord : this.getObjRecord().getSubRecords()) {
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            return (EmbeddedObjectRefSubRecord)subRecord;
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }

    protected EscherContainerRecord createSpContainer() {
        throw new IllegalStateException("HSSFObjectData cannot be created from scratch");
    }

    protected ObjRecord createObjRecord() {
        throw new IllegalStateException("HSSFObjectData cannot be created from scratch");
    }

    protected void afterRemove(HSSFPatriarch hSSFPatriarch) {
        throw new IllegalStateException("HSSFObjectData cannot be created from scratch");
    }

    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        EscherAggregate escherAggregate = hSSFPatriarch._getBoundAggregate();
        escherAggregate.associateShapeToObjRecord((EscherRecord)this.getEscherContainer().getChildById((short)-4079), this.getObjRecord());
        EscherBSERecord escherBSERecord = hSSFPatriarch.getSheet().getWorkbook().getWorkbook().getBSERecord(this.getPictureIndex());
        escherBSERecord.setRef(escherBSERecord.getRef() + 1);
    }

    protected HSSFShape cloneShape() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        byte[] byArray = this.getEscherContainer().serialize();
        escherContainerRecord.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        ObjRecord objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        return new HSSFObjectData(escherContainerRecord, objRecord, this._root);
    }
}

