/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.record.HyperlinkRecord;
import ai.org.apache.poi.ss.usermodel.Hyperlink;

public class HSSFHyperlink
implements Hyperlink {
    public static final int LINK_URL = 1;
    public static final int LINK_DOCUMENT = 2;
    public static final int LINK_EMAIL = 3;
    public static final int LINK_FILE = 4;
    protected HyperlinkRecord record = null;
    protected int link_type;

    public HSSFHyperlink(int n) {
        this.link_type = n;
        this.record = new HyperlinkRecord();
        switch (n) {
            case 1: 
            case 3: {
                this.record.newUrlLink();
                break;
            }
            case 4: {
                this.record.newFileLink();
                break;
            }
            case 2: {
                this.record.newDocumentLink();
            }
        }
    }

    protected HSSFHyperlink(HyperlinkRecord hyperlinkRecord) {
        this.record = hyperlinkRecord;
        this.link_type = hyperlinkRecord.isFileLink() ? 4 : (hyperlinkRecord.isDocumentLink() ? 2 : (hyperlinkRecord.getAddress() != null && hyperlinkRecord.getAddress().startsWith("mailto:") ? 3 : 1));
    }

    public int getFirstRow() {
        return this.record.getFirstRow();
    }

    public void setFirstRow(int n) {
        this.record.setFirstRow(n);
    }

    public int getLastRow() {
        return this.record.getLastRow();
    }

    public void setLastRow(int n) {
        this.record.setLastRow(n);
    }

    public int getFirstColumn() {
        return this.record.getFirstColumn();
    }

    public void setFirstColumn(int n) {
        this.record.setFirstColumn((short)n);
    }

    public int getLastColumn() {
        return this.record.getLastColumn();
    }

    public void setLastColumn(int n) {
        this.record.setLastColumn((short)n);
    }

    public String getAddress() {
        return this.record.getAddress();
    }

    public String getTextMark() {
        return this.record.getTextMark();
    }

    public void setTextMark(String string) {
        this.record.setTextMark(string);
    }

    public String getShortFilename() {
        return this.record.getShortFilename();
    }

    public void setShortFilename(String string) {
        this.record.setShortFilename(string);
    }

    public void setAddress(String string) {
        this.record.setAddress(string);
    }

    public String getLabel() {
        return this.record.getLabel();
    }

    public void setLabel(String string) {
        this.record.setLabel(string);
    }

    public int getType() {
        return this.link_type;
    }
}

