/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFEvaluationCell;
import ai.org.apache.poi.hssf.usermodel.HSSFEvaluationWorkbook;
import ai.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai.org.apache.poi.hssf.usermodel.HSSFRow;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import ai.org.apache.poi.ss.formula.IStabilityClassifier;
import ai.org.apache.poi.ss.formula.WorkbookEvaluator;
import ai.org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai.org.apache.poi.ss.formula.eval.StringValueEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.udf.UDFFinder;
import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellValue;
import ai.org.apache.poi.ss.usermodel.FormulaEvaluator;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.usermodel.Workbook;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HSSFFormulaEvaluator
implements FormulaEvaluator,
WorkbookEvaluatorProvider {
    private WorkbookEvaluator _bookEvaluator;
    private HSSFWorkbook _book;

    @Deprecated
    public HSSFFormulaEvaluator(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook) {
        this(hSSFWorkbook);
        this._book = hSSFWorkbook;
    }

    public HSSFFormulaEvaluator(HSSFWorkbook hSSFWorkbook) {
        this(hSSFWorkbook, null);
        this._book = hSSFWorkbook;
    }

    public HSSFFormulaEvaluator(HSSFWorkbook hSSFWorkbook, IStabilityClassifier iStabilityClassifier) {
        this(hSSFWorkbook, iStabilityClassifier, null);
    }

    private HSSFFormulaEvaluator(HSSFWorkbook hSSFWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        this._bookEvaluator = new WorkbookEvaluator(HSSFEvaluationWorkbook.create(hSSFWorkbook), iStabilityClassifier, uDFFinder);
    }

    public static HSSFFormulaEvaluator create(HSSFWorkbook hSSFWorkbook, IStabilityClassifier iStabilityClassifier, UDFFinder uDFFinder) {
        return new HSSFFormulaEvaluator(hSSFWorkbook, iStabilityClassifier, uDFFinder);
    }

    public static void setupEnvironment(String[] stringArray, HSSFFormulaEvaluator[] hSSFFormulaEvaluatorArray) {
        WorkbookEvaluator[] workbookEvaluatorArray = new WorkbookEvaluator[hSSFFormulaEvaluatorArray.length];
        for (int i = 0; i < workbookEvaluatorArray.length; ++i) {
            workbookEvaluatorArray[i] = hSSFFormulaEvaluatorArray[i]._bookEvaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(stringArray, workbookEvaluatorArray);
    }

    @Override
    public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> map) {
        CollaboratingWorkbooksEnvironment.setupFormulaEvaluator(map);
    }

    @Override
    public WorkbookEvaluator _getWorkbookEvaluator() {
        return this._bookEvaluator;
    }

    @Deprecated
    public void setCurrentRow(HSSFRow hSSFRow) {
    }

    @Override
    public void clearAllCachedResultValues() {
        this._bookEvaluator.clearAllCachedResultValues();
    }

    public void notifyUpdateCell(HSSFCell hSSFCell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell(hSSFCell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    public void notifyDeleteCell(HSSFCell hSSFCell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell(hSSFCell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new HSSFEvaluationCell((HSSFCell)cell));
    }

    @Override
    public CellValue evaluate(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 4: {
                return CellValue.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return CellValue.getError(cell.getErrorCellValue());
            }
            case 2: {
                return this.evaluateFormulaCellValue(cell);
            }
            case 0: {
                return new CellValue(cell.getNumericCellValue());
            }
            case 1: {
                return new CellValue(cell.getRichStringCellValue().getString());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    @Override
    public int evaluateFormulaCell(Cell cell) {
        if (cell == null || cell.getCellType() != 2) {
            return -1;
        }
        CellValue cellValue = this.evaluateFormulaCellValue(cell);
        HSSFFormulaEvaluator.setCellValue(cell, cellValue);
        return cellValue.getCellType();
    }

    @Override
    public HSSFCell evaluateInCell(Cell cell) {
        if (cell == null) {
            return null;
        }
        HSSFCell hSSFCell = (HSSFCell)cell;
        if (cell.getCellType() == 2) {
            CellValue cellValue = this.evaluateFormulaCellValue(cell);
            HSSFFormulaEvaluator.setCellValue(cell, cellValue);
            HSSFFormulaEvaluator.setCellType(cell, cellValue);
        }
        return hSSFCell;
    }

    private static void setCellType(Cell cell, CellValue cellValue) {
        int n = cellValue.getCellType();
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                cell.setCellType(n);
                return;
            }
        }
        throw new IllegalStateException("Unexpected cell value type (" + n + ")");
    }

    private static void setCellValue(Cell cell, CellValue cellValue) {
        int n = cellValue.getCellType();
        switch (n) {
            case 4: {
                cell.setCellValue(cellValue.getBooleanValue());
                break;
            }
            case 5: {
                cell.setCellErrorValue(cellValue.getErrorValue());
                break;
            }
            case 0: {
                cell.setCellValue(cellValue.getNumberValue());
                break;
            }
            case 1: {
                cell.setCellValue(new HSSFRichTextString(cellValue.getStringValue()));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected cell value type (" + n + ")");
            }
        }
    }

    public static void evaluateAllFormulaCells(HSSFWorkbook hSSFWorkbook) {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(hSSFWorkbook, new HSSFFormulaEvaluator(hSSFWorkbook));
    }

    public static void evaluateAllFormulaCells(Workbook workbook) {
        FormulaEvaluator formulaEvaluator = workbook.getCreationHelper().createFormulaEvaluator();
        HSSFFormulaEvaluator.evaluateAllFormulaCells(workbook, formulaEvaluator);
    }

    private static void evaluateAllFormulaCells(Workbook workbook, FormulaEvaluator formulaEvaluator) {
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            for (Row row : sheet) {
                for (Cell cell : row) {
                    if (cell.getCellType() != 2) continue;
                    formulaEvaluator.evaluateFormulaCell(cell);
                }
            }
        }
    }

    @Override
    public void evaluateAll() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells(this._book, this);
    }

    private CellValue evaluateFormulaCellValue(Cell cell) {
        ValueEval valueEval = this._bookEvaluator.evaluate(new HSSFEvaluationCell((HSSFCell)cell));
        if (valueEval instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            return CellValue.valueOf(boolEval.getBooleanValue());
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            return new CellValue(numericValueEval.getNumberValue());
        }
        if (valueEval instanceof StringValueEval) {
            StringValueEval stringValueEval = (StringValueEval)valueEval;
            return new CellValue(stringValueEval.getStringValue());
        }
        if (valueEval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)valueEval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + valueEval.getClass().getName() + ")");
    }

    @Override
    public void setIgnoreMissingWorkbooks(boolean bl) {
        this._bookEvaluator.setIgnoreMissingWorkbooks(bl);
    }

    @Override
    public void setDebugEvaluationOutputForNextEval(boolean bl) {
        this._bookEvaluator.setDebugEvaluationOutputForNextEval(bl);
    }
}

