/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.usermodel.HSSFCell;
import ai.org.apache.poi.hssf.usermodel.HSSFEvaluationSheet;
import ai.org.apache.poi.ss.formula.EvaluationCell;
import ai.org.apache.poi.ss.formula.EvaluationSheet;

final class HSSFEvaluationCell
implements EvaluationCell {
    private final EvaluationSheet _evalSheet;
    private final HSSFCell _cell;

    public HSSFEvaluationCell(HSSFCell hSSFCell, EvaluationSheet evaluationSheet) {
        this._cell = hSSFCell;
        this._evalSheet = evaluationSheet;
    }

    public HSSFEvaluationCell(HSSFCell hSSFCell) {
        this(hSSFCell, new HSSFEvaluationSheet(hSSFCell.getSheet()));
    }

    public Object getIdentityKey() {
        return this._cell;
    }

    public HSSFCell getHSSFCell() {
        return this._cell;
    }

    public boolean getBooleanCellValue() {
        return this._cell.getBooleanCellValue();
    }

    public int getCellType() {
        return this._cell.getCellType();
    }

    public int getColumnIndex() {
        return this._cell.getColumnIndex();
    }

    public int getErrorCellValue() {
        return this._cell.getErrorCellValue();
    }

    public double getNumericCellValue() {
        return this._cell.getNumericCellValue();
    }

    public int getRowIndex() {
        return this._cell.getRowIndex();
    }

    public EvaluationSheet getSheet() {
        return this._evalSheet;
    }

    public String getStringCellValue() {
        return this._cell.getRichStringCellValue().getString();
    }

    public int getCachedFormulaResultType() {
        return this._cell.getCachedFormulaResultType();
    }
}

