/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai.org.apache.poi.ddf.EscherBSERecord;
import ai.org.apache.poi.ddf.EscherContainerRecord;
import ai.org.apache.poi.ddf.EscherOptRecord;
import ai.org.apache.poi.ddf.EscherSimpleProperty;
import ai.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai.org.apache.poi.hssf.record.EndSubRecord;
import ai.org.apache.poi.hssf.record.NoteRecord;
import ai.org.apache.poi.hssf.record.NoteStructureSubRecord;
import ai.org.apache.poi.hssf.record.ObjRecord;
import ai.org.apache.poi.hssf.record.TextObjectRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.hssf.usermodel.HSSFPatriarch;
import ai.org.apache.poi.hssf.usermodel.HSSFShape;
import ai.org.apache.poi.hssf.usermodel.HSSFTextbox;
import ai.org.apache.poi.ss.usermodel.ClientAnchor;
import ai.org.apache.poi.ss.usermodel.Comment;

public class HSSFComment
extends HSSFTextbox
implements Comment {
    private static final int FILL_TYPE_SOLID = 0;
    private static final int FILL_TYPE_PICTURE = 3;
    private static final int GROUP_SHAPE_PROPERTY_DEFAULT_VALUE = 655362;
    private static final int GROUP_SHAPE_HIDDEN_MASK = 0x1000002;
    private static final int GROUP_SHAPE_NOT_HIDDEN_MASK = -16777219;
    private NoteRecord _note;

    public HSSFComment(EscherContainerRecord escherContainerRecord, ObjRecord objRecord, TextObjectRecord textObjectRecord, NoteRecord noteRecord) {
        super(escherContainerRecord, objRecord, textObjectRecord);
        this._note = noteRecord;
    }

    public HSSFComment(HSSFShape hSSFShape, HSSFAnchor hSSFAnchor) {
        super(hSSFShape, hSSFAnchor);
        this._note = this.createNoteRecord();
        this.setFillColor(0x8000050);
        this.setVisible(false);
        this.setAuthor("");
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectType((short)25);
    }

    protected HSSFComment(NoteRecord noteRecord, TextObjectRecord textObjectRecord) {
        this(null, new HSSFClientAnchor());
        this._note = noteRecord;
    }

    void afterInsert(HSSFPatriarch hSSFPatriarch) {
        super.afterInsert(hSSFPatriarch);
        hSSFPatriarch._getBoundAggregate().addTailRecord(this.getNoteRecord());
    }

    protected EscherContainerRecord createSpContainer() {
        EscherContainerRecord escherContainerRecord = super.createSpContainer();
        EscherOptRecord escherOptRecord = (EscherOptRecord)escherContainerRecord.getChildById((short)-4085);
        escherOptRecord.removeEscherProperty(129);
        escherOptRecord.removeEscherProperty(131);
        escherOptRecord.removeEscherProperty(130);
        escherOptRecord.removeEscherProperty(132);
        escherOptRecord.setEscherProperty(new EscherSimpleProperty(959, false, false, 655362));
        return escherContainerRecord;
    }

    protected ObjRecord createObjRecord() {
        ObjRecord objRecord = new ObjRecord();
        CommonObjectDataSubRecord commonObjectDataSubRecord = new CommonObjectDataSubRecord();
        commonObjectDataSubRecord.setObjectType((short)202);
        commonObjectDataSubRecord.setLocked(true);
        commonObjectDataSubRecord.setPrintable(true);
        commonObjectDataSubRecord.setAutofill(false);
        commonObjectDataSubRecord.setAutoline(true);
        NoteStructureSubRecord noteStructureSubRecord = new NoteStructureSubRecord();
        EndSubRecord endSubRecord = new EndSubRecord();
        objRecord.addSubRecord(commonObjectDataSubRecord);
        objRecord.addSubRecord(noteStructureSubRecord);
        objRecord.addSubRecord(endSubRecord);
        return objRecord;
    }

    private NoteRecord createNoteRecord() {
        NoteRecord noteRecord = new NoteRecord();
        noteRecord.setFlags((short)0);
        noteRecord.setAuthor("");
        return noteRecord;
    }

    void setShapeId(int n) {
        super.setShapeId(n);
        CommonObjectDataSubRecord commonObjectDataSubRecord = (CommonObjectDataSubRecord)this.getObjRecord().getSubRecords().get(0);
        commonObjectDataSubRecord.setObjectId((short)(n % 1024));
        this._note.setShapeId(n % 1024);
    }

    public void setVisible(boolean bl) {
        this._note.setFlags(bl ? (short)2 : 0);
        this.setHidden(!bl);
    }

    public boolean isVisible() {
        return this._note.getFlags() == 2;
    }

    public int getRow() {
        return this._note.getRow();
    }

    public void setRow(int n) {
        this._note.setRow(n);
    }

    public int getColumn() {
        return this._note.getColumn();
    }

    public void setColumn(int n) {
        this._note.setColumn(n);
    }

    @Deprecated
    public void setColumn(short s) {
        this.setColumn((int)s);
    }

    public String getAuthor() {
        return this._note.getAuthor();
    }

    public void setAuthor(String string) {
        if (this._note != null) {
            this._note.setAuthor(string);
        }
    }

    protected NoteRecord getNoteRecord() {
        return this._note;
    }

    public boolean hasPosition() {
        if (this._note == null) {
            return false;
        }
        return this.getColumn() >= 0 && this.getRow() >= 0;
    }

    public ClientAnchor getClientAnchor() {
        HSSFAnchor hSSFAnchor = super.getAnchor();
        if (hSSFAnchor instanceof ClientAnchor) {
            return (ClientAnchor)((Object)hSSFAnchor);
        }
        throw new IllegalStateException("Anchor can not be changed in " + ClientAnchor.class.getSimpleName());
    }

    public void setShapeType(int n) {
        throw new IllegalStateException("Shape type can not be changed in " + this.getClass().getSimpleName());
    }

    public void afterRemove(HSSFPatriarch hSSFPatriarch) {
        super.afterRemove(hSSFPatriarch);
        hSSFPatriarch._getBoundAggregate().removeTailRecord(this.getNoteRecord());
    }

    protected HSSFShape cloneShape() {
        TextObjectRecord textObjectRecord = (TextObjectRecord)this.getTextObjectRecord().cloneViaReserialise();
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        byte[] byArray = this.getEscherContainer().serialize();
        escherContainerRecord.fillFields(byArray, 0, new DefaultEscherRecordFactory());
        ObjRecord objRecord = (ObjRecord)this.getObjRecord().cloneViaReserialise();
        NoteRecord noteRecord = (NoteRecord)this.getNoteRecord().cloneViaReserialise();
        return new HSSFComment(escherContainerRecord, objRecord, textObjectRecord, noteRecord);
    }

    public void setBackgroundImage(int n) {
        this.setPropertyValue(new EscherSimpleProperty(390, false, true, n));
        this.setPropertyValue(new EscherSimpleProperty(384, false, false, 3));
        EscherBSERecord escherBSERecord = this.getPatriarch().getSheet().getWorkbook().getWorkbook().getBSERecord(n);
        escherBSERecord.setRef(escherBSERecord.getRef() + 1);
    }

    public void resetBackgroundImage() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(390);
        if (null != escherSimpleProperty) {
            EscherBSERecord escherBSERecord = this.getPatriarch().getSheet().getWorkbook().getWorkbook().getBSERecord(escherSimpleProperty.getPropertyValue());
            escherBSERecord.setRef(escherBSERecord.getRef() - 1);
            this.getOptRecord().removeEscherProperty(390);
        }
        this.setPropertyValue(new EscherSimpleProperty(384, false, false, 0));
    }

    public int getBackgroundImageId() {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(390);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    private void setHidden(boolean bl) {
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)this.getOptRecord().lookup(959);
        if (bl) {
            this.setPropertyValue(new EscherSimpleProperty(959, false, false, escherSimpleProperty.getPropertyValue() | 0x1000002));
        } else {
            this.setPropertyValue(new EscherSimpleProperty(959, false, false, escherSimpleProperty.getPropertyValue() & 0xFEFFFFFD));
        }
    }
}

