/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.usermodel;

import ai.org.apache.poi.hssf.model.HSSFFormulaParser;
import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.usermodel.HSSFDateUtil;
import ai.org.apache.poi.hssf.usermodel.HSSFSheet;
import ai.org.apache.poi.hssf.usermodel.HSSFWorkbook;
import ai.org.apache.poi.ss.formula.FormulaRenderer;
import ai.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai.org.apache.poi.ss.formula.ptg.NumberPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.formula.ptg.StringPtg;
import ai.org.apache.poi.ss.usermodel.DataValidationConstraint;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class DVConstraint
implements DataValidationConstraint {
    private static final DataValidationConstraint.ValidationType VT = null;
    private final int _validationType;
    private int _operator;
    private String[] _explicitListValues;
    private String _formula1;
    private String _formula2;
    private Double _value1;
    private Double _value2;

    private DVConstraint(int n, int n2, String string, String string2, Double d, Double d2, String[] stringArray) {
        this._validationType = n;
        this._operator = n2;
        this._formula1 = string;
        this._formula2 = string2;
        this._value1 = d;
        this._value2 = d2;
        this._explicitListValues = stringArray;
    }

    private DVConstraint(String string, String[] stringArray) {
        this(3, 0, string, null, null, null, stringArray);
    }

    public static DVConstraint createNumericConstraint(int n, int n2, String string, String string2) {
        String string3;
        switch (n) {
            case 0: {
                if (string == null && string2 == null) break;
                throw new IllegalArgumentException("expr1 and expr2 must be null for validation type 'any'");
            }
            case 1: 
            case 2: 
            case 6: {
                if (string == null) {
                    throw new IllegalArgumentException("expr1 must be supplied");
                }
                DataValidationConstraint.OperatorType.validateSecondArg(n2, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation Type (" + n + ") not supported with this method");
            }
        }
        Double d = (string3 = DVConstraint.getFormulaFromTextExpression(string)) == null ? DVConstraint.convertNumber(string) : null;
        String string4 = DVConstraint.getFormulaFromTextExpression(string2);
        Double d2 = string4 == null ? DVConstraint.convertNumber(string2) : null;
        return new DVConstraint(n, n2, string3, string4, d, d2, null);
    }

    public static DVConstraint createFormulaListConstraint(String string) {
        return new DVConstraint(string, null);
    }

    public static DVConstraint createExplicitListConstraint(String[] stringArray) {
        return new DVConstraint(null, stringArray);
    }

    public static DVConstraint createTimeConstraint(int n, String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("expr1 must be supplied");
        }
        DataValidationConstraint.OperatorType.validateSecondArg(n, string);
        String string3 = DVConstraint.getFormulaFromTextExpression(string);
        Double d = string3 == null ? DVConstraint.convertTime(string) : null;
        String string4 = DVConstraint.getFormulaFromTextExpression(string2);
        Double d2 = string4 == null ? DVConstraint.convertTime(string2) : null;
        return new DVConstraint(5, n, string3, string4, d, d2, null);
    }

    public static DVConstraint createDateConstraint(int n, String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("expr1 must be supplied");
        }
        DataValidationConstraint.OperatorType.validateSecondArg(n, string2);
        SimpleDateFormat simpleDateFormat = string3 == null ? null : new SimpleDateFormat(string3);
        String string4 = DVConstraint.getFormulaFromTextExpression(string);
        Double d = string4 == null ? DVConstraint.convertDate(string, simpleDateFormat) : null;
        String string5 = DVConstraint.getFormulaFromTextExpression(string2);
        Double d2 = string5 == null ? DVConstraint.convertDate(string2, simpleDateFormat) : null;
        return new DVConstraint(4, n, string4, string5, d, d2, null);
    }

    private static String getFormulaFromTextExpression(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() < 1) {
            throw new IllegalArgumentException("Empty string is not a valid formula/value expression");
        }
        if (string.charAt(0) == '=') {
            return string.substring(1);
        }
        return null;
    }

    private static Double convertNumber(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("The supplied text '" + string + "' could not be parsed as a number");
        }
    }

    private static Double convertTime(String string) {
        if (string == null) {
            return null;
        }
        return new Double(HSSFDateUtil.convertTime(string));
    }

    private static Double convertDate(String string, SimpleDateFormat simpleDateFormat) {
        Date date;
        if (string == null) {
            return null;
        }
        if (simpleDateFormat == null) {
            date = HSSFDateUtil.parseYYYYMMDDDate(string);
        } else {
            try {
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                throw new RuntimeException("Failed to parse date '" + string + "' using specified format '" + simpleDateFormat + "'", parseException);
            }
        }
        return new Double(HSSFDateUtil.getExcelDate(date));
    }

    public static DVConstraint createCustomFormulaConstraint(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formula must be supplied");
        }
        return new DVConstraint(7, 0, string, null, null, null, null);
    }

    public int getValidationType() {
        return this._validationType;
    }

    public boolean isListValidationType() {
        return this._validationType == 3;
    }

    public boolean isExplicitList() {
        return this._validationType == 3 && this._explicitListValues != null;
    }

    public int getOperator() {
        return this._operator;
    }

    public void setOperator(int n) {
        this._operator = n;
    }

    public String[] getExplicitListValues() {
        return this._explicitListValues;
    }

    public void setExplicitListValues(String[] stringArray) {
        if (this._validationType != 3) {
            throw new RuntimeException("Cannot setExplicitListValues on non-list constraint");
        }
        this._formula1 = null;
        this._explicitListValues = stringArray;
    }

    public String getFormula1() {
        return this._formula1;
    }

    public void setFormula1(String string) {
        this._value1 = null;
        this._explicitListValues = null;
        this._formula1 = string;
    }

    public String getFormula2() {
        return this._formula2;
    }

    public void setFormula2(String string) {
        this._value2 = null;
        this._formula2 = string;
    }

    public Double getValue1() {
        return this._value1;
    }

    public void setValue1(double d) {
        this._formula1 = null;
        this._value1 = new Double(d);
    }

    public Double getValue2() {
        return this._value2;
    }

    public void setValue2(double d) {
        this._formula2 = null;
        this._value2 = new Double(d);
    }

    FormulaPair createFormulas(HSSFSheet hSSFSheet) {
        Ptg[] ptgArray;
        Ptg[] ptgArray2;
        if (this.isListValidationType()) {
            ptgArray2 = this.createListFormula(hSSFSheet);
            ptgArray = Ptg.EMPTY_PTG_ARRAY;
        } else {
            ptgArray2 = DVConstraint.convertDoubleFormula(this._formula1, this._value1, hSSFSheet);
            ptgArray = DVConstraint.convertDoubleFormula(this._formula2, this._value2, hSSFSheet);
        }
        return new FormulaPair(ptgArray2, ptgArray);
    }

    private Ptg[] createListFormula(HSSFSheet hSSFSheet) {
        if (this._explicitListValues == null) {
            HSSFWorkbook hSSFWorkbook = hSSFSheet.getWorkbook();
            return HSSFFormulaParser.parse(this._formula1, hSSFWorkbook, 5, hSSFWorkbook.getSheetIndex(hSSFSheet));
        }
        StringBuffer stringBuffer = new StringBuffer(this._explicitListValues.length * 16);
        for (int i = 0; i < this._explicitListValues.length; ++i) {
            if (i > 0) {
                stringBuffer.append('\u0000');
            }
            stringBuffer.append(this._explicitListValues[i]);
        }
        return new Ptg[]{new StringPtg(stringBuffer.toString())};
    }

    private static Ptg[] convertDoubleFormula(String string, Double d, HSSFSheet hSSFSheet) {
        if (string == null) {
            if (d == null) {
                return Ptg.EMPTY_PTG_ARRAY;
            }
            return new Ptg[]{new NumberPtg(d)};
        }
        if (d != null) {
            throw new IllegalStateException("Both formula and value cannot be present");
        }
        HSSFWorkbook hSSFWorkbook = hSSFSheet.getWorkbook();
        return HSSFFormulaParser.parse(string, hSSFWorkbook, 0, hSSFWorkbook.getSheetIndex(hSSFSheet));
    }

    static DVConstraint createDVConstraint(DVRecord dVRecord, FormulaRenderingWorkbook formulaRenderingWorkbook) {
        switch (dVRecord.getDataType()) {
            case 0: {
                return new DVConstraint(0, dVRecord.getConditionOperator(), null, null, null, null, null);
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                FormulaValuePair formulaValuePair = DVConstraint.toFormulaString(dVRecord.getFormula1(), formulaRenderingWorkbook);
                FormulaValuePair formulaValuePair2 = DVConstraint.toFormulaString(dVRecord.getFormula2(), formulaRenderingWorkbook);
                return new DVConstraint(dVRecord.getDataType(), dVRecord.getConditionOperator(), formulaValuePair.formula(), formulaValuePair2.formula(), formulaValuePair.value(), formulaValuePair2.value(), null);
            }
            case 3: {
                if (dVRecord.getListExplicitFormula()) {
                    String string = DVConstraint.toFormulaString(dVRecord.getFormula1(), formulaRenderingWorkbook).string();
                    if (string.startsWith("\"")) {
                        string = string.substring(1);
                    }
                    if (string.endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    String[] stringArray = string.split(Pattern.quote("\u0000"));
                    return DVConstraint.createExplicitListConstraint(stringArray);
                }
                String string = DVConstraint.toFormulaString(dVRecord.getFormula1(), formulaRenderingWorkbook).string();
                return DVConstraint.createFormulaListConstraint(string);
            }
            case 7: {
                return DVConstraint.createCustomFormulaConstraint(DVConstraint.toFormulaString(dVRecord.getFormula1(), formulaRenderingWorkbook).string());
            }
        }
        throw new UnsupportedOperationException(MessageFormat.format("validationType={0}", dVRecord.getDataType()));
    }

    private static FormulaValuePair toFormulaString(Ptg[] ptgArray, FormulaRenderingWorkbook formulaRenderingWorkbook) {
        FormulaValuePair formulaValuePair = new FormulaValuePair();
        if (ptgArray != null && ptgArray.length > 0) {
            String string = FormulaRenderer.toFormulaString(formulaRenderingWorkbook, ptgArray);
            if (ptgArray.length == 1 && ptgArray[0].getClass() == NumberPtg.class) {
                formulaValuePair._value = string;
            } else {
                formulaValuePair._formula = string;
            }
        }
        return formulaValuePair;
    }

    private static class FormulaValuePair {
        private String _formula;
        private String _value;

        private FormulaValuePair() {
        }

        public String formula() {
            return this._formula;
        }

        public Double value() {
            if (this._value == null) {
                return null;
            }
            return new Double(this._value);
        }

        public String string() {
            if (this._formula != null) {
                return this._formula;
            }
            if (this._value != null) {
                return this._value;
            }
            return null;
        }
    }

    public static final class FormulaPair {
        private final Ptg[] _formula1;
        private final Ptg[] _formula2;

        public FormulaPair(Ptg[] ptgArray, Ptg[] ptgArray2) {
            this._formula1 = ptgArray;
            this._formula2 = ptgArray2;
        }

        public Ptg[] getFormula1() {
            return this._formula1;
        }

        public Ptg[] getFormula2() {
            return this._formula2;
        }
    }
}

