/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.pivottable;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class StreamIDRecord
extends StandardRecord {
    public static final short sid = 213;
    private int idstm;

    public StreamIDRecord(RecordInputStream recordInputStream) {
        this.idstm = recordInputStream.readShort();
    }

    protected void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.idstm);
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 213;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SXIDSTM]\n");
        stringBuffer.append("    .idstm      =").append(HexDump.shortToHex(this.idstm)).append('\n');
        stringBuffer.append("[/SXIDSTM]\n");
        return stringBuffer.toString();
    }
}

