/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.crypto;

import ai.org.apache.poi.EncryptedDocumentException;
import ai.org.apache.poi.hssf.record.BiffHeaderInput;
import ai.org.apache.poi.hssf.record.crypto.Biff8Cipher;
import ai.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai.org.apache.poi.hssf.record.crypto.Biff8RC4;
import ai.org.apache.poi.hssf.record.crypto.Biff8RC4Key;
import ai.org.apache.poi.hssf.record.crypto.Biff8XOR;
import ai.org.apache.poi.hssf.record.crypto.Biff8XORKey;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianInputStream;
import java.io.InputStream;

public final class Biff8DecryptingStream
implements BiffHeaderInput,
LittleEndianInput {
    private final LittleEndianInput _le;
    private final Biff8Cipher _cipher;

    public Biff8DecryptingStream(InputStream inputStream, int n, Biff8EncryptionKey biff8EncryptionKey) {
        if (biff8EncryptionKey instanceof Biff8RC4Key) {
            this._cipher = new Biff8RC4(n, (Biff8RC4Key)biff8EncryptionKey);
        } else if (biff8EncryptionKey instanceof Biff8XORKey) {
            this._cipher = new Biff8XOR(n, (Biff8XORKey)biff8EncryptionKey);
        } else {
            throw new EncryptedDocumentException("Crypto API not supported yet.");
        }
        this._le = inputStream instanceof LittleEndianInput ? (LittleEndianInput)((Object)inputStream) : new LittleEndianInputStream(inputStream);
    }

    public int available() {
        return this._le.available();
    }

    public int readRecordSID() {
        int n = this._le.readUShort();
        this._cipher.skipTwoBytes();
        this._cipher.startRecord(n);
        return n;
    }

    public int readDataSize() {
        int n = this._le.readUShort();
        this._cipher.skipTwoBytes();
        this._cipher.setNextRecordSize(n);
        return n;
    }

    public double readDouble() {
        long l = this.readLong();
        double d = Double.longBitsToDouble(l);
        if (Double.isNaN(d)) {
            throw new RuntimeException("Did not expect to read NaN");
        }
        return d;
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this._le.readFully(byArray, n, n2);
        this._cipher.xor(byArray, n, n2);
    }

    public int readUByte() {
        return this._cipher.xorByte(this._le.readUByte());
    }

    public byte readByte() {
        return (byte)this._cipher.xorByte(this._le.readUByte());
    }

    public int readUShort() {
        return this._cipher.xorShort(this._le.readUShort());
    }

    public short readShort() {
        return (short)this._cipher.xorShort(this._le.readUShort());
    }

    public int readInt() {
        return this._cipher.xorInt(this._le.readInt());
    }

    public long readLong() {
        return this._cipher.xorLong(this._le.readLong());
    }
}

