/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.common;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordInput;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import ai.org.apache.poi.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeString
implements Comparable<UnicodeString> {
    private static POILogger _logger = POILogFactory.getLogger(UnicodeString.class);
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List<FormatRun> field_4_format_runs;
    private ExtRst field_5_ext_rst;
    private static final BitField highByte = BitFieldFactory.getInstance(1);
    private static final BitField extBit = BitFieldFactory.getInstance(4);
    private static final BitField richText = BitFieldFactory.getInstance(8);

    private UnicodeString() {
    }

    public UnicodeString(String string) {
        this.setString(string);
    }

    public int hashCode() {
        int n = 0;
        if (this.field_3_string != null) {
            n = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + n;
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        if (!(object instanceof UnicodeString)) {
            return false;
        }
        UnicodeString unicodeString = (UnicodeString)object;
        boolean bl2 = bl = this.field_1_charCount == unicodeString.field_1_charCount && this.field_2_optionflags == unicodeString.field_2_optionflags && this.field_3_string.equals(unicodeString.field_3_string);
        if (!bl) {
            return false;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs != null || this.field_4_format_runs != null && unicodeString.field_4_format_runs == null) {
            return false;
        }
        int n2 = this.field_4_format_runs.size();
        if (n2 != unicodeString.field_4_format_runs.size()) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            FormatRun formatRun;
            FormatRun formatRun2 = this.field_4_format_runs.get(n);
            if (formatRun2.equals(formatRun = unicodeString.field_4_format_runs.get(n))) continue;
            return false;
        }
        if (this.field_5_ext_rst != null || unicodeString.field_5_ext_rst != null) {
            if (this.field_5_ext_rst != null && unicodeString.field_5_ext_rst != null) {
                n = this.field_5_ext_rst.compareTo(unicodeString.field_5_ext_rst);
                if (n != 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public UnicodeString(RecordInputStream recordInputStream) {
        this.field_1_charCount = recordInputStream.readShort();
        this.field_2_optionflags = recordInputStream.readByte();
        int n = 0;
        int n2 = 0;
        if (this.isRichText()) {
            n = recordInputStream.readShort();
        }
        if (this.isExtendedText()) {
            n2 = recordInputStream.readInt();
        }
        boolean bl = (this.field_2_optionflags & 1) == 0;
        this.field_3_string = bl ? recordInputStream.readCompressedUnicode(this.getCharCount()) : recordInputStream.readUnicodeLEString(this.getCharCount());
        if (this.isRichText() && n > 0) {
            this.field_4_format_runs = new ArrayList<FormatRun>(n);
            for (int i = 0; i < n; ++i) {
                this.field_4_format_runs.add(new FormatRun(recordInputStream));
            }
        }
        if (this.isExtendedText() && n2 > 0) {
            this.field_5_ext_rst = new ExtRst(new ContinuableRecordInput(recordInputStream), n2);
            if (this.field_5_ext_rst.getDataSize() + 4 != n2) {
                _logger.log(5, "ExtRst was supposed to be " + n2 + " bytes long, but seems to actually be " + (this.field_5_ext_rst.getDataSize() + 4));
            }
        }
    }

    public int getCharCount() {
        if (this.field_1_charCount < 0) {
            return this.field_1_charCount + 65536;
        }
        return this.field_1_charCount;
    }

    public short getCharCountShort() {
        return this.field_1_charCount;
    }

    public void setCharCount(short s) {
        this.field_1_charCount = s;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte by) {
        this.field_2_optionflags = by;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            bl = true;
            break;
        }
        this.field_2_optionflags = bl ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int n) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (n < 0 || n >= this.field_4_format_runs.size()) {
            return null;
        }
        return this.field_4_format_runs.get(n);
    }

    private int findFormatRunAt(int n) {
        int n2 = this.field_4_format_runs.size();
        for (int i = 0; i < n2; ++i) {
            FormatRun formatRun = this.field_4_format_runs.get(i);
            if (formatRun._character == n) {
                return i;
            }
            if (formatRun._character <= n) continue;
            return -1;
        }
        return -1;
    }

    public void addFormatRun(FormatRun formatRun) {
        int n;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList<FormatRun>();
        }
        if ((n = this.findFormatRunAt(formatRun._character)) != -1) {
            this.field_4_format_runs.remove(n);
        }
        this.field_4_format_runs.add(formatRun);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator<FormatRun> formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun formatRun) {
        this.field_4_format_runs.remove(formatRun);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    public ExtRst getExtendedRst() {
        return this.field_5_ext_rst;
    }

    void setExtendedRst(ExtRst extRst) {
        this.field_2_optionflags = extRst != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = extRst;
    }

    public void swapFontUse(short s, short s2) {
        for (FormatRun formatRun : this.field_4_format_runs) {
            if (formatRun._fontIndex != s) continue;
            formatRun._fontIndex = s2;
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[UNICODESTRING]\n");
        stringBuffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        stringBuffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        stringBuffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            for (int i = 0; i < this.field_4_format_runs.size(); ++i) {
                FormatRun formatRun = this.field_4_format_runs.get(i);
                stringBuffer.append("      .format_run" + i + "          = ").append(formatRun.toString()).append("\n");
            }
        }
        if (this.field_5_ext_rst != null) {
            stringBuffer.append("    .field_5_ext_rst          = ").append("\n");
            stringBuffer.append(this.field_5_ext_rst.toString()).append("\n");
        }
        stringBuffer.append("[/UNICODESTRING]\n");
        return stringBuffer.toString();
    }

    public void serialize(ContinuableRecordOutput continuableRecordOutput) {
        int n = 0;
        int n2 = 0;
        if (this.isRichText() && this.field_4_format_runs != null) {
            n = this.field_4_format_runs.size();
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            n2 = 4 + this.field_5_ext_rst.getDataSize();
        }
        continuableRecordOutput.writeString(this.field_3_string, n, n2);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (continuableRecordOutput.getAvailableSpace() < 4) {
                    continuableRecordOutput.writeContinue();
                }
                FormatRun formatRun = this.field_4_format_runs.get(i);
                formatRun.serialize(continuableRecordOutput);
            }
        }
        if (n2 > 0) {
            this.field_5_ext_rst.serialize(continuableRecordOutput);
        }
    }

    @Override
    public int compareTo(UnicodeString unicodeString) {
        int n = this.getString().compareTo(unicodeString.getString());
        if (n != 0) {
            return n;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && unicodeString.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && unicodeString.field_4_format_runs == null) {
            return -1;
        }
        int n2 = this.field_4_format_runs.size();
        if (n2 != unicodeString.field_4_format_runs.size()) {
            return n2 - unicodeString.field_4_format_runs.size();
        }
        for (int i = 0; i < n2; ++i) {
            FormatRun formatRun;
            FormatRun formatRun2 = this.field_4_format_runs.get(i);
            n = formatRun2.compareTo(formatRun = unicodeString.field_4_format_runs.get(i));
            if (n == 0) continue;
            return n;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && unicodeString.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && unicodeString.field_5_ext_rst == null) {
            return -1;
        }
        n = this.field_5_ext_rst.compareTo(unicodeString.field_5_ext_rst);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    private boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    private boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString unicodeString = new UnicodeString();
        unicodeString.field_1_charCount = this.field_1_charCount;
        unicodeString.field_2_optionflags = this.field_2_optionflags;
        unicodeString.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            unicodeString.field_4_format_runs = new ArrayList<FormatRun>();
            for (FormatRun formatRun : this.field_4_format_runs) {
                unicodeString.field_4_format_runs.add(new FormatRun(formatRun._character, formatRun._fontIndex));
            }
        }
        if (this.field_5_ext_rst != null) {
            unicodeString.field_5_ext_rst = this.field_5_ext_rst.clone();
        }
        return unicodeString;
    }

    public static class PhRun {
        private int phoneticTextFirstCharacterOffset;
        private int realTextFirstCharacterOffset;
        private int realTextLength;

        public PhRun(int n, int n2, int n3) {
            this.phoneticTextFirstCharacterOffset = n;
            this.realTextFirstCharacterOffset = n2;
            this.realTextLength = n3;
        }

        private PhRun(LittleEndianInput littleEndianInput) {
            this.phoneticTextFirstCharacterOffset = littleEndianInput.readUShort();
            this.realTextFirstCharacterOffset = littleEndianInput.readUShort();
            this.realTextLength = littleEndianInput.readUShort();
        }

        private void serialize(ContinuableRecordOutput continuableRecordOutput) {
            continuableRecordOutput.writeContinueIfRequired(6);
            continuableRecordOutput.writeShort(this.phoneticTextFirstCharacterOffset);
            continuableRecordOutput.writeShort(this.realTextFirstCharacterOffset);
            continuableRecordOutput.writeShort(this.realTextLength);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtRst
    implements Comparable<ExtRst> {
        private short reserved;
        private short formattingFontIndex;
        private short formattingOptions;
        private int numberOfRuns;
        private String phoneticText;
        private PhRun[] phRuns;
        private byte[] extraData;

        private void populateEmpty() {
            this.reserved = 1;
            this.phoneticText = "";
            this.phRuns = new PhRun[0];
            this.extraData = new byte[0];
        }

        protected ExtRst() {
            this.populateEmpty();
        }

        protected ExtRst(LittleEndianInput littleEndianInput, int n) {
            int n2;
            this.reserved = littleEndianInput.readShort();
            if (this.reserved == -1) {
                this.populateEmpty();
                return;
            }
            if (this.reserved != 1) {
                _logger.log(5, "Warning - ExtRst has wrong magic marker, expecting 1 but found " + this.reserved + " - ignoring");
                for (int i = 0; i < n - 2; ++i) {
                    littleEndianInput.readByte();
                }
                this.populateEmpty();
                return;
            }
            short s = littleEndianInput.readShort();
            this.formattingFontIndex = littleEndianInput.readShort();
            this.formattingOptions = littleEndianInput.readShort();
            this.numberOfRuns = littleEndianInput.readUShort();
            short s2 = littleEndianInput.readShort();
            short s3 = littleEndianInput.readShort();
            if (s2 == 0 && s3 > 0) {
                s3 = 0;
            }
            if (s2 != s3) {
                throw new IllegalStateException("The two length fields of the Phonetic Text don't agree! " + s2 + " vs " + s3);
            }
            this.phoneticText = StringUtil.readUnicodeLE(littleEndianInput, s2);
            int n3 = s - 4 - 6 - 2 * this.phoneticText.length();
            int n4 = n3 / 6;
            this.phRuns = new PhRun[n4];
            for (n2 = 0; n2 < this.phRuns.length; ++n2) {
                this.phRuns[n2] = new PhRun(littleEndianInput);
            }
            n2 = n3 - n4 * 6;
            if (n2 < 0) {
                _logger.log(5, "Warning - ExtRst overran by " + (0 - n2) + " bytes");
                n2 = 0;
            }
            this.extraData = new byte[n2];
            for (int i = 0; i < this.extraData.length; ++i) {
                this.extraData[i] = littleEndianInput.readByte();
            }
        }

        protected int getDataSize() {
            return 10 + 2 * this.phoneticText.length() + 6 * this.phRuns.length + this.extraData.length;
        }

        protected void serialize(ContinuableRecordOutput continuableRecordOutput) {
            int n = this.getDataSize();
            continuableRecordOutput.writeContinueIfRequired(8);
            continuableRecordOutput.writeShort(this.reserved);
            continuableRecordOutput.writeShort(n);
            continuableRecordOutput.writeShort(this.formattingFontIndex);
            continuableRecordOutput.writeShort(this.formattingOptions);
            continuableRecordOutput.writeContinueIfRequired(6);
            continuableRecordOutput.writeShort(this.numberOfRuns);
            continuableRecordOutput.writeShort(this.phoneticText.length());
            continuableRecordOutput.writeShort(this.phoneticText.length());
            continuableRecordOutput.writeContinueIfRequired(this.phoneticText.length() * 2);
            StringUtil.putUnicodeLE(this.phoneticText, continuableRecordOutput);
            for (int i = 0; i < this.phRuns.length; ++i) {
                this.phRuns[i].serialize(continuableRecordOutput);
            }
            continuableRecordOutput.write(this.extraData);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExtRst)) {
                return false;
            }
            ExtRst extRst = (ExtRst)object;
            return this.compareTo(extRst) == 0;
        }

        @Override
        public int compareTo(ExtRst extRst) {
            int n = this.reserved - extRst.reserved;
            if (n != 0) {
                return n;
            }
            n = this.formattingFontIndex - extRst.formattingFontIndex;
            if (n != 0) {
                return n;
            }
            n = this.formattingOptions - extRst.formattingOptions;
            if (n != 0) {
                return n;
            }
            n = this.numberOfRuns - extRst.numberOfRuns;
            if (n != 0) {
                return n;
            }
            n = this.phoneticText.compareTo(extRst.phoneticText);
            if (n != 0) {
                return n;
            }
            n = this.phRuns.length - extRst.phRuns.length;
            if (n != 0) {
                return n;
            }
            for (int i = 0; i < this.phRuns.length; ++i) {
                n = this.phRuns[i].phoneticTextFirstCharacterOffset - extRst.phRuns[i].phoneticTextFirstCharacterOffset;
                if (n != 0) {
                    return n;
                }
                n = this.phRuns[i].realTextFirstCharacterOffset - extRst.phRuns[i].realTextFirstCharacterOffset;
                if (n != 0) {
                    return n;
                }
                n = this.phRuns[i].realTextLength - extRst.phRuns[i].realTextLength;
                if (n == 0) continue;
                return n;
            }
            n = Arrays.hashCode(this.extraData) - Arrays.hashCode(extRst.extraData);
            return n;
        }

        public int hashCode() {
            int n = this.reserved;
            n = 31 * n + this.formattingFontIndex;
            n = 31 * n + this.formattingOptions;
            n = 31 * n + this.numberOfRuns;
            n = 31 * n + this.phoneticText.hashCode();
            if (this.phRuns != null) {
                for (PhRun phRun : this.phRuns) {
                    n = 31 * n + phRun.phoneticTextFirstCharacterOffset;
                    n = 31 * n + phRun.realTextFirstCharacterOffset;
                    n = 31 * n + phRun.realTextLength;
                }
            }
            return n;
        }

        protected ExtRst clone() {
            ExtRst extRst = new ExtRst();
            extRst.reserved = this.reserved;
            extRst.formattingFontIndex = this.formattingFontIndex;
            extRst.formattingOptions = this.formattingOptions;
            extRst.numberOfRuns = this.numberOfRuns;
            extRst.phoneticText = this.phoneticText;
            extRst.phRuns = new PhRun[this.phRuns.length];
            for (int i = 0; i < extRst.phRuns.length; ++i) {
                extRst.phRuns[i] = new PhRun(this.phRuns[i].phoneticTextFirstCharacterOffset, this.phRuns[i].realTextFirstCharacterOffset, this.phRuns[i].realTextLength);
            }
            return extRst;
        }

        public short getFormattingFontIndex() {
            return this.formattingFontIndex;
        }

        public short getFormattingOptions() {
            return this.formattingOptions;
        }

        public int getNumberOfRuns() {
            return this.numberOfRuns;
        }

        public String getPhoneticText() {
            return this.phoneticText;
        }

        public PhRun[] getPhRuns() {
            return this.phRuns;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatRun
    implements Comparable<FormatRun> {
        final short _character;
        short _fontIndex;

        public FormatRun(short s, short s2) {
            this._character = s;
            this._fontIndex = s2;
        }

        public FormatRun(LittleEndianInput littleEndianInput) {
            this(littleEndianInput.readShort(), littleEndianInput.readShort());
        }

        public short getCharacterPos() {
            return this._character;
        }

        public short getFontIndex() {
            return this._fontIndex;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FormatRun)) {
                return false;
            }
            FormatRun formatRun = (FormatRun)object;
            return this._character == formatRun._character && this._fontIndex == formatRun._fontIndex;
        }

        @Override
        public int compareTo(FormatRun formatRun) {
            if (this._character == formatRun._character && this._fontIndex == formatRun._fontIndex) {
                return 0;
            }
            if (this._character == formatRun._character) {
                return this._fontIndex - formatRun._fontIndex;
            }
            return this._character - formatRun._character;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }

        public String toString() {
            return "character=" + this._character + ",fontIndex=" + this._fontIndex;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._character);
            littleEndianOutput.writeShort(this._fontIndex);
        }
    }
}

