/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.common;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.common.SharedFeature;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class FeatProtection
implements SharedFeature {
    public static long NO_SELF_RELATIVE_SECURITY_FEATURE = 0L;
    public static long HAS_SELF_RELATIVE_SECURITY_FEATURE = 1L;
    private int fSD;
    private int passwordVerifier;
    private String title;
    private byte[] securityDescriptor;

    public FeatProtection() {
        this.securityDescriptor = new byte[0];
    }

    public FeatProtection(RecordInputStream recordInputStream) {
        this.fSD = recordInputStream.readInt();
        this.passwordVerifier = recordInputStream.readInt();
        this.title = StringUtil.readUnicodeString(recordInputStream);
        this.securityDescriptor = recordInputStream.readRemainder();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [FEATURE PROTECTION]\n");
        stringBuffer.append("   Self Relative = " + this.fSD);
        stringBuffer.append("   Password Verifier = " + this.passwordVerifier);
        stringBuffer.append("   Title = " + this.title);
        stringBuffer.append("   Security Descriptor Size = " + this.securityDescriptor.length);
        stringBuffer.append(" [/FEATURE PROTECTION]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.fSD);
        littleEndianOutput.writeInt(this.passwordVerifier);
        StringUtil.writeUnicodeString(littleEndianOutput, this.title);
        littleEndianOutput.write(this.securityDescriptor);
    }

    public int getDataSize() {
        return 8 + StringUtil.getEncodedSize(this.title) + this.securityDescriptor.length;
    }

    public int getPasswordVerifier() {
        return this.passwordVerifier;
    }

    public void setPasswordVerifier(int n) {
        this.passwordVerifier = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getFSD() {
        return this.fSD;
    }
}

