/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class SeriesTextRecord
extends StandardRecord {
    public static final short sid = 4109;
    private static final int MAX_LEN = 255;
    private int field_1_id;
    private boolean is16bit;
    private String field_4_text;

    public SeriesTextRecord() {
        this.field_4_text = "";
        this.is16bit = false;
    }

    public SeriesTextRecord(RecordInputStream recordInputStream) {
        this.field_1_id = recordInputStream.readUShort();
        int n = recordInputStream.readUByte();
        this.is16bit = (recordInputStream.readUByte() & 1) != 0;
        this.field_4_text = this.is16bit ? recordInputStream.readUnicodeLEString(n) : recordInputStream.readCompressedUnicode(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SERIESTEXT]\n");
        stringBuffer.append("  .id     =").append(HexDump.shortToHex(this.getId())).append('\n');
        stringBuffer.append("  .textLen=").append(this.field_4_text.length()).append('\n');
        stringBuffer.append("  .is16bit=").append(this.is16bit).append('\n');
        stringBuffer.append("  .text   =").append(" (").append(this.getText()).append(" )").append('\n');
        stringBuffer.append("[/SERIESTEXT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_id);
        littleEndianOutput.writeByte(this.field_4_text.length());
        if (this.is16bit) {
            littleEndianOutput.writeByte(1);
            StringUtil.putUnicodeLE(this.field_4_text, littleEndianOutput);
        } else {
            littleEndianOutput.writeByte(0);
            StringUtil.putCompressedUnicode(this.field_4_text, littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 4 + this.field_4_text.length() * (this.is16bit ? 2 : 1);
    }

    public short getSid() {
        return 4109;
    }

    public Object clone() {
        SeriesTextRecord seriesTextRecord = new SeriesTextRecord();
        seriesTextRecord.field_1_id = this.field_1_id;
        seriesTextRecord.is16bit = this.is16bit;
        seriesTextRecord.field_4_text = this.field_4_text;
        return seriesTextRecord;
    }

    public int getId() {
        return this.field_1_id;
    }

    public void setId(int n) {
        this.field_1_id = n;
    }

    public String getText() {
        return this.field_4_text;
    }

    public void setText(String string) {
        if (string.length() > 255) {
            throw new IllegalArgumentException("Text is too long (" + string.length() + ">" + 255 + ")");
        }
        this.field_4_text = string;
        this.is16bit = StringUtil.hasMultibyte(string);
    }
}

