/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class FontBasisRecord
extends StandardRecord {
    public static final short sid = 4192;
    private short field_1_xBasis;
    private short field_2_yBasis;
    private short field_3_heightBasis;
    private short field_4_scale;
    private short field_5_indexToFontTable;

    public FontBasisRecord() {
    }

    public FontBasisRecord(RecordInputStream recordInputStream) {
        this.field_1_xBasis = recordInputStream.readShort();
        this.field_2_yBasis = recordInputStream.readShort();
        this.field_3_heightBasis = recordInputStream.readShort();
        this.field_4_scale = recordInputStream.readShort();
        this.field_5_indexToFontTable = recordInputStream.readShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[FBI]\n");
        stringBuffer.append("    .xBasis               = ").append("0x").append(HexDump.toHex(this.getXBasis())).append(" (").append(this.getXBasis()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .yBasis               = ").append("0x").append(HexDump.toHex(this.getYBasis())).append(" (").append(this.getYBasis()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .heightBasis          = ").append("0x").append(HexDump.toHex(this.getHeightBasis())).append(" (").append(this.getHeightBasis()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .scale                = ").append("0x").append(HexDump.toHex(this.getScale())).append(" (").append(this.getScale()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("    .indexToFontTable     = ").append("0x").append(HexDump.toHex(this.getIndexToFontTable())).append(" (").append(this.getIndexToFontTable()).append(" )");
        stringBuffer.append(System.getProperty("line.separator"));
        stringBuffer.append("[/FBI]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_xBasis);
        littleEndianOutput.writeShort(this.field_2_yBasis);
        littleEndianOutput.writeShort(this.field_3_heightBasis);
        littleEndianOutput.writeShort(this.field_4_scale);
        littleEndianOutput.writeShort(this.field_5_indexToFontTable);
    }

    protected int getDataSize() {
        return 10;
    }

    public short getSid() {
        return 4192;
    }

    public Object clone() {
        FontBasisRecord fontBasisRecord = new FontBasisRecord();
        fontBasisRecord.field_1_xBasis = this.field_1_xBasis;
        fontBasisRecord.field_2_yBasis = this.field_2_yBasis;
        fontBasisRecord.field_3_heightBasis = this.field_3_heightBasis;
        fontBasisRecord.field_4_scale = this.field_4_scale;
        fontBasisRecord.field_5_indexToFontTable = this.field_5_indexToFontTable;
        return fontBasisRecord;
    }

    public short getXBasis() {
        return this.field_1_xBasis;
    }

    public void setXBasis(short s) {
        this.field_1_xBasis = s;
    }

    public short getYBasis() {
        return this.field_2_yBasis;
    }

    public void setYBasis(short s) {
        this.field_2_yBasis = s;
    }

    public short getHeightBasis() {
        return this.field_3_heightBasis;
    }

    public void setHeightBasis(short s) {
        this.field_3_heightBasis = s;
    }

    public short getScale() {
        return this.field_4_scale;
    }

    public void setScale(short s) {
        this.field_4_scale = s;
    }

    public short getIndexToFontTable() {
        return this.field_5_indexToFontTable;
    }

    public void setIndexToFontTable(short s) {
        this.field_5_indexToFontTable = s;
    }
}

