/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;

public class ChartTitleFormatRecord
extends StandardRecord {
    public static final short sid = 4176;
    private CTFormat[] _formats;

    public ChartTitleFormatRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.readUShort();
        this._formats = new CTFormat[n];
        for (int i = 0; i < n; ++i) {
            this._formats[i] = new CTFormat(recordInputStream);
        }
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this._formats.length);
        for (int i = 0; i < this._formats.length; ++i) {
            this._formats[i].serialize(littleEndianOutput);
        }
    }

    protected int getDataSize() {
        return 2 + 4 * this._formats.length;
    }

    public short getSid() {
        return 4176;
    }

    public int getFormatCount() {
        return this._formats.length;
    }

    public void modifyFormatRun(short s, short s2) {
        int n = 0;
        for (int i = 0; i < this._formats.length; ++i) {
            CTFormat cTFormat = this._formats[i];
            if (n != 0) {
                cTFormat.setOffset(cTFormat.getOffset() + n);
                continue;
            }
            if (s != cTFormat.getOffset() || i >= this._formats.length - 1) continue;
            CTFormat cTFormat2 = this._formats[i + 1];
            n = s2 - (cTFormat2.getOffset() - cTFormat.getOffset());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHARTTITLEFORMAT]\n");
        stringBuffer.append("    .format_runs       = ").append(this._formats.length).append("\n");
        for (int i = 0; i < this._formats.length; ++i) {
            CTFormat cTFormat = this._formats[i];
            stringBuffer.append("       .char_offset= ").append(cTFormat.getOffset());
            stringBuffer.append(",.fontidx= ").append(cTFormat.getFontIndex());
            stringBuffer.append("\n");
        }
        stringBuffer.append("[/CHARTTITLEFORMAT]\n");
        return stringBuffer.toString();
    }

    private static final class CTFormat {
        public static final int ENCODED_SIZE = 4;
        private int _offset;
        private int _fontIndex;

        protected CTFormat(short s, short s2) {
            this._offset = s;
            this._fontIndex = s2;
        }

        public CTFormat(RecordInputStream recordInputStream) {
            this._offset = recordInputStream.readShort();
            this._fontIndex = recordInputStream.readShort();
        }

        public int getOffset() {
            return this._offset;
        }

        public void setOffset(int n) {
            this._offset = n;
        }

        public int getFontIndex() {
            return this._fontIndex;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._offset);
            littleEndianOutput.writeShort(this._fontIndex);
        }
    }
}

