/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.chart;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class ChartFormatRecord
extends StandardRecord {
    public static final short sid = 4116;
    private static final BitField varyDisplayPattern = BitFieldFactory.getInstance(1);
    private int field1_x_position;
    private int field2_y_position;
    private int field3_width;
    private int field4_height;
    private int field5_grbit;
    private int field6_unknown;

    public ChartFormatRecord() {
    }

    public ChartFormatRecord(RecordInputStream recordInputStream) {
        this.field1_x_position = recordInputStream.readInt();
        this.field2_y_position = recordInputStream.readInt();
        this.field3_width = recordInputStream.readInt();
        this.field4_height = recordInputStream.readInt();
        this.field5_grbit = recordInputStream.readUShort();
        this.field6_unknown = recordInputStream.readUShort();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CHARTFORMAT]\n");
        stringBuffer.append("    .xPosition       = ").append(this.getXPosition()).append("\n");
        stringBuffer.append("    .yPosition       = ").append(this.getYPosition()).append("\n");
        stringBuffer.append("    .width           = ").append(this.getWidth()).append("\n");
        stringBuffer.append("    .height          = ").append(this.getHeight()).append("\n");
        stringBuffer.append("    .grBit           = ").append(HexDump.intToHex(this.field5_grbit)).append("\n");
        stringBuffer.append("[/CHARTFORMAT]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.getXPosition());
        littleEndianOutput.writeInt(this.getYPosition());
        littleEndianOutput.writeInt(this.getWidth());
        littleEndianOutput.writeInt(this.getHeight());
        littleEndianOutput.writeShort(this.field5_grbit);
        littleEndianOutput.writeShort(this.field6_unknown);
    }

    protected int getDataSize() {
        return 20;
    }

    public short getSid() {
        return 4116;
    }

    public int getXPosition() {
        return this.field1_x_position;
    }

    public void setXPosition(int n) {
        this.field1_x_position = n;
    }

    public int getYPosition() {
        return this.field2_y_position;
    }

    public void setYPosition(int n) {
        this.field2_y_position = n;
    }

    public int getWidth() {
        return this.field3_width;
    }

    public void setWidth(int n) {
        this.field3_width = n;
    }

    public int getHeight() {
        return this.field4_height;
    }

    public void setHeight(int n) {
        this.field4_height = n;
    }

    public boolean getVaryDisplayPattern() {
        return varyDisplayPattern.isSet(this.field5_grbit);
    }

    public void setVaryDisplayPattern(boolean bl) {
        this.field5_grbit = varyDisplayPattern.setBoolean(this.field5_grbit, bl);
    }
}

