/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.aggregates;

import ai.org.apache.poi.hssf.record.ArrayRecord;
import ai.org.apache.poi.hssf.record.SharedFormulaRecord;
import ai.org.apache.poi.hssf.record.SharedValueRecordBase;
import ai.org.apache.poi.hssf.record.TableRecord;
import ai.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import ai.org.apache.poi.hssf.util.CellRangeAddress8Bit;
import ai.org.apache.poi.ss.util.CellReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharedValueManager {
    private final List<ArrayRecord> _arrayRecords;
    private final TableRecord[] _tableRecords;
    private final Map<SharedFormulaRecord, SharedFormulaGroup> _groupsBySharedFormulaRecord;
    private Map<Integer, SharedFormulaGroup> _groupsCache;

    public static SharedValueManager createEmpty() {
        return new SharedValueManager(new SharedFormulaRecord[0], new CellReference[0], new ArrayRecord[0], new TableRecord[0]);
    }

    private SharedValueManager(SharedFormulaRecord[] sharedFormulaRecordArray, CellReference[] cellReferenceArray, ArrayRecord[] arrayRecordArray, TableRecord[] tableRecordArray) {
        int n = sharedFormulaRecordArray.length;
        if (n != cellReferenceArray.length) {
            throw new IllegalArgumentException("array sizes don't match: " + n + "!=" + cellReferenceArray.length + ".");
        }
        this._arrayRecords = SharedValueManager.toList(arrayRecordArray);
        this._tableRecords = tableRecordArray;
        HashMap<SharedFormulaRecord, SharedFormulaGroup> hashMap = new HashMap<SharedFormulaRecord, SharedFormulaGroup>(n * 3 / 2);
        for (int i = 0; i < n; ++i) {
            SharedFormulaRecord sharedFormulaRecord = sharedFormulaRecordArray[i];
            hashMap.put(sharedFormulaRecord, new SharedFormulaGroup(sharedFormulaRecord, cellReferenceArray[i]));
        }
        this._groupsBySharedFormulaRecord = hashMap;
    }

    private static <Z> List<Z> toList(Z[] ZArray) {
        ArrayList<Z> arrayList = new ArrayList<Z>(ZArray.length);
        for (int i = 0; i < ZArray.length; ++i) {
            arrayList.add(ZArray[i]);
        }
        return arrayList;
    }

    public static SharedValueManager create(SharedFormulaRecord[] sharedFormulaRecordArray, CellReference[] cellReferenceArray, ArrayRecord[] arrayRecordArray, TableRecord[] tableRecordArray) {
        if (sharedFormulaRecordArray.length + cellReferenceArray.length + arrayRecordArray.length + tableRecordArray.length < 1) {
            return SharedValueManager.createEmpty();
        }
        return new SharedValueManager(sharedFormulaRecordArray, cellReferenceArray, arrayRecordArray, tableRecordArray);
    }

    public SharedFormulaRecord linkSharedFormulaRecord(CellReference cellReference, FormulaRecordAggregate formulaRecordAggregate) {
        SharedFormulaGroup sharedFormulaGroup = this.findFormulaGroupForCell(cellReference);
        if (null == sharedFormulaGroup) {
            throw new RuntimeException("Failed to find a matching shared formula record");
        }
        sharedFormulaGroup.add(formulaRecordAggregate);
        return sharedFormulaGroup.getSFR();
    }

    private SharedFormulaGroup findFormulaGroupForCell(CellReference cellReference) {
        if (null == this._groupsCache) {
            this._groupsCache = new HashMap<Integer, SharedFormulaGroup>(this._groupsBySharedFormulaRecord.size());
            for (SharedFormulaGroup sharedFormulaGroup : this._groupsBySharedFormulaRecord.values()) {
                this._groupsCache.put(this.getKeyForCache(sharedFormulaGroup._firstCell), sharedFormulaGroup);
            }
        }
        SharedFormulaGroup sharedFormulaGroup = this._groupsCache.get(this.getKeyForCache(cellReference));
        return sharedFormulaGroup;
    }

    private Integer getKeyForCache(CellReference cellReference) {
        return new Integer(cellReference.getCol() + 1 << 16 | cellReference.getRow());
    }

    public SharedValueRecordBase getRecordForFirstCell(FormulaRecordAggregate formulaRecordAggregate) {
        Object object;
        CellReference cellReference = formulaRecordAggregate.getFormulaRecord().getFormula().getExpReference();
        if (cellReference == null) {
            return null;
        }
        int n = cellReference.getRow();
        short s = cellReference.getCol();
        if (formulaRecordAggregate.getRow() != n || formulaRecordAggregate.getColumn() != s) {
            return null;
        }
        if (!this._groupsBySharedFormulaRecord.isEmpty() && null != (object = this.findFormulaGroupForCell(cellReference))) {
            return ((SharedFormulaGroup)object).getSFR();
        }
        for (TableRecord tableRecord : this._tableRecords) {
            if (!tableRecord.isFirstCell(n, s)) continue;
            return tableRecord;
        }
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isFirstCell(n, s)) continue;
            return arrayRecord;
        }
        return null;
    }

    public void unlink(SharedFormulaRecord sharedFormulaRecord) {
        SharedFormulaGroup sharedFormulaGroup = this._groupsBySharedFormulaRecord.remove(sharedFormulaRecord);
        if (sharedFormulaGroup == null) {
            throw new IllegalStateException("Failed to find formulas for shared formula");
        }
        this._groupsCache = null;
        sharedFormulaGroup.unlinkSharedFormulas();
    }

    public void addArrayRecord(ArrayRecord arrayRecord) {
        this._arrayRecords.add(arrayRecord);
    }

    public CellRangeAddress8Bit removeArrayFormula(int n, int n2) {
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isInRange(n, n2)) continue;
            this._arrayRecords.remove(arrayRecord);
            return arrayRecord.getRange();
        }
        String string = new CellReference(n, n2, false, false).formatAsString();
        throw new IllegalArgumentException("Specified cell " + (String)string + " is not part of an array formula.");
    }

    public ArrayRecord getArrayRecord(int n, int n2) {
        for (ArrayRecord arrayRecord : this._arrayRecords) {
            if (!arrayRecord.isFirstCell(n, n2)) continue;
            return arrayRecord;
        }
        return null;
    }

    private static final class SharedFormulaGroup {
        private final SharedFormulaRecord _sfr;
        private final FormulaRecordAggregate[] _frAggs;
        private int _numberOfFormulas;
        private final CellReference _firstCell;

        public SharedFormulaGroup(SharedFormulaRecord sharedFormulaRecord, CellReference cellReference) {
            if (!sharedFormulaRecord.isInRange(cellReference.getRow(), cellReference.getCol())) {
                throw new IllegalArgumentException("First formula cell " + cellReference.formatAsString() + " is not shared formula range " + sharedFormulaRecord.getRange().toString() + ".");
            }
            this._sfr = sharedFormulaRecord;
            this._firstCell = cellReference;
            int n = sharedFormulaRecord.getLastColumn() - sharedFormulaRecord.getFirstColumn() + 1;
            int n2 = sharedFormulaRecord.getLastRow() - sharedFormulaRecord.getFirstRow() + 1;
            this._frAggs = new FormulaRecordAggregate[n * n2];
            this._numberOfFormulas = 0;
        }

        public void add(FormulaRecordAggregate formulaRecordAggregate) {
            if (this._numberOfFormulas == 0 && (this._firstCell.getRow() != formulaRecordAggregate.getRow() || this._firstCell.getCol() != formulaRecordAggregate.getColumn())) {
                throw new IllegalStateException("shared formula coding error: " + this._firstCell.getCol() + '/' + this._firstCell.getRow() + " != " + formulaRecordAggregate.getColumn() + '/' + formulaRecordAggregate.getRow());
            }
            if (this._numberOfFormulas >= this._frAggs.length) {
                throw new RuntimeException("Too many formula records for shared formula group");
            }
            this._frAggs[this._numberOfFormulas++] = formulaRecordAggregate;
        }

        public void unlinkSharedFormulas() {
            for (int i = 0; i < this._numberOfFormulas; ++i) {
                this._frAggs[i].unlinkSharedFormula();
            }
        }

        public SharedFormulaRecord getSFR() {
            return this._sfr;
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this._sfr.getRange().toString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

