/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.aggregates;

import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.record.CellValueRecordInterface;
import ai.org.apache.poi.hssf.record.DBCellRecord;
import ai.org.apache.poi.hssf.record.DimensionsRecord;
import ai.org.apache.poi.hssf.record.FormulaRecord;
import ai.org.apache.poi.hssf.record.IndexRecord;
import ai.org.apache.poi.hssf.record.MulBlankRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RowRecord;
import ai.org.apache.poi.hssf.record.UnknownRecord;
import ai.org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.SharedValueManager;
import ai.org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.formula.FormulaShifter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowRecordsAggregate
extends RecordAggregate {
    private int _firstrow = -1;
    private int _lastrow = -1;
    private final Map<Integer, RowRecord> _rowRecords;
    private final ValueRecordsAggregate _valuesAgg;
    private final List<Record> _unknownRecords;
    private final SharedValueManager _sharedValueManager;
    private RowRecord[] _rowRecordValues = null;

    public RowRecordsAggregate() {
        this(SharedValueManager.createEmpty());
    }

    private RowRecordsAggregate(SharedValueManager sharedValueManager) {
        if (sharedValueManager == null) {
            throw new IllegalArgumentException("SharedValueManager must be provided.");
        }
        this._rowRecords = new TreeMap<Integer, RowRecord>();
        this._valuesAgg = new ValueRecordsAggregate();
        this._unknownRecords = new ArrayList<Record>();
        this._sharedValueManager = sharedValueManager;
    }

    public RowRecordsAggregate(RecordStream recordStream, SharedValueManager sharedValueManager) {
        this(sharedValueManager);
        block5: while (recordStream.hasNext()) {
            Record record = recordStream.getNext();
            switch (record.getSid()) {
                case 520: {
                    this.insertRow((RowRecord)record);
                    continue block5;
                }
                case 81: {
                    this.addUnknownRecord(record);
                    continue block5;
                }
                case 215: {
                    continue block5;
                }
            }
            if (record instanceof UnknownRecord) {
                this.addUnknownRecord(record);
                while (recordStream.peekNextSid() == 60) {
                    this.addUnknownRecord(recordStream.getNext());
                }
                continue;
            }
            if (record instanceof MulBlankRecord) {
                this._valuesAgg.addMultipleBlanks((MulBlankRecord)record);
                continue;
            }
            if (!(record instanceof CellValueRecordInterface)) {
                throw new RuntimeException("Unexpected record type (" + record.getClass().getName() + ")");
            }
            this._valuesAgg.construct((CellValueRecordInterface)((Object)record), recordStream, sharedValueManager);
        }
    }

    private void addUnknownRecord(Record record) {
        this._unknownRecords.add(record);
    }

    public void insertRow(RowRecord rowRecord) {
        this._rowRecords.put(rowRecord.getRowNumber(), rowRecord);
        this._rowRecordValues = null;
        if (rowRecord.getRowNumber() < this._firstrow || this._firstrow == -1) {
            this._firstrow = rowRecord.getRowNumber();
        }
        if (rowRecord.getRowNumber() > this._lastrow || this._lastrow == -1) {
            this._lastrow = rowRecord.getRowNumber();
        }
    }

    public void removeRow(RowRecord rowRecord) {
        int n = rowRecord.getRowNumber();
        this._valuesAgg.removeAllCellsValuesForRow(n);
        Integer n2 = n;
        RowRecord rowRecord2 = this._rowRecords.remove(n2);
        if (rowRecord2 == null) {
            throw new RuntimeException("Invalid row index (" + n2 + ")");
        }
        if (rowRecord != rowRecord2) {
            this._rowRecords.put(n2, rowRecord2);
            throw new RuntimeException("Attempt to remove row that does not belong to this sheet");
        }
        this._rowRecordValues = null;
    }

    public RowRecord getRow(int n) {
        int n2 = SpreadsheetVersion.EXCEL97.getLastRowIndex();
        if (n < 0 || n > n2) {
            throw new IllegalArgumentException("The row number must be between 0 and " + n2);
        }
        return this._rowRecords.get(n);
    }

    public int getPhysicalNumberOfRows() {
        return this._rowRecords.size();
    }

    public int getFirstRowNum() {
        return this._firstrow;
    }

    public int getLastRowNum() {
        return this._lastrow;
    }

    public int getRowBlockCount() {
        int n = this._rowRecords.size() / 32;
        if (this._rowRecords.size() % 32 != 0) {
            ++n;
        }
        return n;
    }

    private int getRowBlockSize(int n) {
        return 20 * this.getRowCountForBlock(n);
    }

    public int getRowCountForBlock(int n) {
        int n2 = n * 32;
        int n3 = n2 + 32 - 1;
        if (n3 >= this._rowRecords.size()) {
            n3 = this._rowRecords.size() - 1;
        }
        return n3 - n2 + 1;
    }

    private int getStartRowNumberForBlock(int n) {
        int n2 = n * 32;
        if (this._rowRecordValues == null) {
            this._rowRecordValues = this._rowRecords.values().toArray(new RowRecord[this._rowRecords.size()]);
        }
        try {
            return this._rowRecordValues[n2].getRowNumber();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Did not find start row for block " + n);
        }
    }

    private int getEndRowNumberForBlock(int n) {
        int n2 = (n + 1) * 32 - 1;
        if (n2 >= this._rowRecords.size()) {
            n2 = this._rowRecords.size() - 1;
        }
        if (this._rowRecordValues == null) {
            this._rowRecordValues = this._rowRecords.values().toArray(new RowRecord[this._rowRecords.size()]);
        }
        try {
            return this._rowRecordValues[n2].getRowNumber();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new RuntimeException("Did not find end row for block " + n);
        }
    }

    private int visitRowRecordsForBlock(int n, RecordAggregate.RecordVisitor recordVisitor) {
        int n2;
        int n3 = n * 32;
        int n4 = n3 + 32;
        Iterator<RowRecord> iterator = this._rowRecords.values().iterator();
        for (n2 = 0; n2 < n3; ++n2) {
            iterator.next();
        }
        int n5 = 0;
        while (iterator.hasNext() && n2++ < n4) {
            Record record = iterator.next();
            n5 += record.getRecordSize();
            recordVisitor.visitRecord(record);
        }
        return n5;
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        int n;
        RecordAggregate.PositionTrackingVisitor positionTrackingVisitor = new RecordAggregate.PositionTrackingVisitor(recordVisitor, 0);
        int n2 = this.getRowBlockCount();
        for (n = 0; n < n2; ++n) {
            int n3 = 0;
            int n4 = this.visitRowRecordsForBlock(n, recordVisitor);
            n3 += n4;
            int n5 = this.getStartRowNumberForBlock(n);
            int n6 = this.getEndRowNumberForBlock(n);
            DBCellRecord.Builder builder = new DBCellRecord.Builder();
            int n7 = n4 - 20;
            for (int i = n5; i <= n6; ++i) {
                if (!this._valuesAgg.rowHasCells(i)) continue;
                positionTrackingVisitor.setPosition(0);
                this._valuesAgg.visitCellsForRow(i, positionTrackingVisitor);
                int n8 = positionTrackingVisitor.getPosition();
                n3 += n8;
                builder.addCellOffset(n7);
                n7 = n8;
            }
            recordVisitor.visitRecord(builder.build(n3));
        }
        for (n = 0; n < this._unknownRecords.size(); ++n) {
            recordVisitor.visitRecord(this._unknownRecords.get(n));
        }
    }

    public Iterator<RowRecord> getIterator() {
        return this._rowRecords.values().iterator();
    }

    public int findStartOfRowOutlineGroup(int n) {
        RowRecord rowRecord = this.getRow(n);
        short s = rowRecord.getOutlineLevel();
        int n2 = n;
        while (this.getRow(n2) != null) {
            rowRecord = this.getRow(n2);
            if (rowRecord.getOutlineLevel() < s) {
                return n2 + 1;
            }
            --n2;
        }
        return n2 + 1;
    }

    public int findEndOfRowOutlineGroup(int n) {
        int n2;
        short s = this.getRow(n).getOutlineLevel();
        for (n2 = n; n2 < this.getLastRowNum() && this.getRow(n2) != null && this.getRow(n2).getOutlineLevel() >= s; ++n2) {
        }
        return n2 - 1;
    }

    private int writeHidden(RowRecord rowRecord, int n) {
        int n2 = n;
        RowRecord rowRecord2 = rowRecord;
        short s = rowRecord2.getOutlineLevel();
        while (rowRecord2 != null && this.getRow(n2).getOutlineLevel() >= s) {
            rowRecord2.setZeroHeight(true);
            rowRecord2 = this.getRow(++n2);
        }
        return n2;
    }

    public void collapseRow(int n) {
        int n2 = this.findStartOfRowOutlineGroup(n);
        RowRecord rowRecord = this.getRow(n2);
        int n3 = this.writeHidden(rowRecord, n2);
        RowRecord rowRecord2 = this.getRow(n3);
        if (rowRecord2 == null) {
            rowRecord2 = RowRecordsAggregate.createRow(n3);
            this.insertRow(rowRecord2);
        }
        rowRecord2.setColapsed(true);
    }

    public static RowRecord createRow(int n) {
        return new RowRecord(n);
    }

    public boolean isRowGroupCollapsed(int n) {
        int n2 = this.findEndOfRowOutlineGroup(n) + 1;
        if (this.getRow(n2) == null) {
            return false;
        }
        return this.getRow(n2).getColapsed();
    }

    public void expandRow(int n) {
        int n2 = n;
        if (n2 == -1) {
            return;
        }
        if (!this.isRowGroupCollapsed(n2)) {
            return;
        }
        int n3 = this.findStartOfRowOutlineGroup(n2);
        RowRecord rowRecord = this.getRow(n3);
        int n4 = this.findEndOfRowOutlineGroup(n2);
        if (!this.isRowGroupHiddenByParent(n2)) {
            for (int i = n3; i <= n4; ++i) {
                RowRecord rowRecord2 = this.getRow(i);
                if (rowRecord.getOutlineLevel() != rowRecord2.getOutlineLevel() && this.isRowGroupCollapsed(i)) continue;
                rowRecord2.setZeroHeight(false);
            }
        }
        this.getRow(n4 + 1).setColapsed(false);
    }

    public boolean isRowGroupHiddenByParent(int n) {
        boolean bl;
        short s;
        boolean bl2;
        short s2;
        int n2 = this.findEndOfRowOutlineGroup(n);
        if (this.getRow(n2 + 1) == null) {
            s2 = 0;
            bl2 = false;
        } else {
            s2 = this.getRow(n2 + 1).getOutlineLevel();
            bl2 = this.getRow(n2 + 1).getZeroHeight();
        }
        int n3 = this.findStartOfRowOutlineGroup(n);
        if (n3 - 1 < 0 || this.getRow(n3 - 1) == null) {
            s = 0;
            bl = false;
        } else {
            s = this.getRow(n3 - 1).getOutlineLevel();
            bl = this.getRow(n3 - 1).getZeroHeight();
        }
        if (s2 > s) {
            return bl2;
        }
        return bl;
    }

    public Iterator<CellValueRecordInterface> getCellValueIterator() {
        return this._valuesAgg.iterator();
    }

    public CellValueRecordInterface[] getValueRecords() {
        return this._valuesAgg.getValueRecords();
    }

    public IndexRecord createIndexRecord(int n, int n2) {
        IndexRecord indexRecord = new IndexRecord();
        indexRecord.setFirstRow(this._firstrow);
        indexRecord.setLastRowAdd1(this._lastrow + 1);
        int n3 = this.getRowBlockCount();
        int n4 = IndexRecord.getRecordSizeForBlockCount(n3);
        int n5 = n + n4 + n2;
        for (int i = 0; i < n3; ++i) {
            n5 += this.getRowBlockSize(i);
            indexRecord.addDbcell(n5 += this._valuesAgg.getRowCellBlockSize(this.getStartRowNumberForBlock(i), this.getEndRowNumberForBlock(i)));
            n5 += 8 + this.getRowCountForBlock(i) * 2;
        }
        return indexRecord;
    }

    public void insertCell(CellValueRecordInterface cellValueRecordInterface) {
        this._valuesAgg.insertCell(cellValueRecordInterface);
    }

    public void removeCell(CellValueRecordInterface cellValueRecordInterface) {
        if (cellValueRecordInterface instanceof FormulaRecordAggregate) {
            ((FormulaRecordAggregate)cellValueRecordInterface).notifyFormulaChanging();
        }
        this._valuesAgg.removeCell(cellValueRecordInterface);
    }

    public FormulaRecordAggregate createFormula(int n, int n2) {
        FormulaRecord formulaRecord = new FormulaRecord();
        formulaRecord.setRow(n);
        formulaRecord.setColumn((short)n2);
        return new FormulaRecordAggregate(formulaRecord, null, this._sharedValueManager);
    }

    public void updateFormulasAfterRowShift(FormulaShifter formulaShifter, int n) {
        this._valuesAgg.updateFormulasAfterRowShift(formulaShifter, n);
    }

    public DimensionsRecord createDimensions() {
        DimensionsRecord dimensionsRecord = new DimensionsRecord();
        dimensionsRecord.setFirstRow(this._firstrow);
        dimensionsRecord.setLastRow(this._lastrow);
        dimensionsRecord.setFirstCol((short)this._valuesAgg.getFirstCellNum());
        dimensionsRecord.setLastCol((short)this._valuesAgg.getLastCellNum());
        return dimensionsRecord;
    }
}

