/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.aggregates;

import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.record.BottomMarginRecord;
import ai.org.apache.poi.hssf.record.ContinueRecord;
import ai.org.apache.poi.hssf.record.FooterRecord;
import ai.org.apache.poi.hssf.record.HCenterRecord;
import ai.org.apache.poi.hssf.record.HeaderFooterRecord;
import ai.org.apache.poi.hssf.record.HeaderRecord;
import ai.org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import ai.org.apache.poi.hssf.record.LeftMarginRecord;
import ai.org.apache.poi.hssf.record.Margin;
import ai.org.apache.poi.hssf.record.PageBreakRecord;
import ai.org.apache.poi.hssf.record.PrintSetupRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.RecordBase;
import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RightMarginRecord;
import ai.org.apache.poi.hssf.record.TopMarginRecord;
import ai.org.apache.poi.hssf.record.UserSViewBegin;
import ai.org.apache.poi.hssf.record.VCenterRecord;
import ai.org.apache.poi.hssf.record.VerticalPageBreakRecord;
import ai.org.apache.poi.hssf.record.aggregates.CustomViewSettingsRecordAggregate;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import ai.org.apache.poi.util.HexDump;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageSettingsBlock
extends RecordAggregate {
    private PageBreakRecord _rowBreaksRecord;
    private PageBreakRecord _columnBreaksRecord;
    private HeaderRecord _header;
    private FooterRecord _footer;
    private HCenterRecord _hCenter;
    private VCenterRecord _vCenter;
    private LeftMarginRecord _leftMargin;
    private RightMarginRecord _rightMargin;
    private TopMarginRecord _topMargin;
    private BottomMarginRecord _bottomMargin;
    private final List<PLSAggregate> _plsRecords;
    private PrintSetupRecord _printSetup;
    private Record _bitmap;
    private HeaderFooterRecord _headerFooter;
    private List<HeaderFooterRecord> _sviewHeaderFooters = new ArrayList<HeaderFooterRecord>();
    private Record _printSize;

    public PageSettingsBlock(RecordStream recordStream) {
        this._plsRecords = new ArrayList<PLSAggregate>();
        while (this.readARecord(recordStream)) {
        }
    }

    public PageSettingsBlock() {
        this._plsRecords = new ArrayList<PLSAggregate>();
        this._rowBreaksRecord = new HorizontalPageBreakRecord();
        this._columnBreaksRecord = new VerticalPageBreakRecord();
        this._header = new HeaderRecord("");
        this._footer = new FooterRecord("");
        this._hCenter = PageSettingsBlock.createHCenter();
        this._vCenter = PageSettingsBlock.createVCenter();
        this._printSetup = PageSettingsBlock.createPrintSetup();
    }

    public static boolean isComponentRecord(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 51: 
            case 77: 
            case 131: 
            case 132: 
            case 161: 
            case 233: 
            case 2204: {
                return true;
            }
        }
        return false;
    }

    private boolean readARecord(RecordStream recordStream) {
        switch (recordStream.peekNextSid()) {
            case 27: {
                this.checkNotPresent(this._rowBreaksRecord);
                this._rowBreaksRecord = (PageBreakRecord)recordStream.getNext();
                break;
            }
            case 26: {
                this.checkNotPresent(this._columnBreaksRecord);
                this._columnBreaksRecord = (PageBreakRecord)recordStream.getNext();
                break;
            }
            case 20: {
                this.checkNotPresent(this._header);
                this._header = (HeaderRecord)recordStream.getNext();
                break;
            }
            case 21: {
                this.checkNotPresent(this._footer);
                this._footer = (FooterRecord)recordStream.getNext();
                break;
            }
            case 131: {
                this.checkNotPresent(this._hCenter);
                this._hCenter = (HCenterRecord)recordStream.getNext();
                break;
            }
            case 132: {
                this.checkNotPresent(this._vCenter);
                this._vCenter = (VCenterRecord)recordStream.getNext();
                break;
            }
            case 38: {
                this.checkNotPresent(this._leftMargin);
                this._leftMargin = (LeftMarginRecord)recordStream.getNext();
                break;
            }
            case 39: {
                this.checkNotPresent(this._rightMargin);
                this._rightMargin = (RightMarginRecord)recordStream.getNext();
                break;
            }
            case 40: {
                this.checkNotPresent(this._topMargin);
                this._topMargin = (TopMarginRecord)recordStream.getNext();
                break;
            }
            case 41: {
                this.checkNotPresent(this._bottomMargin);
                this._bottomMargin = (BottomMarginRecord)recordStream.getNext();
                break;
            }
            case 77: {
                this._plsRecords.add(new PLSAggregate(recordStream));
                break;
            }
            case 161: {
                this.checkNotPresent(this._printSetup);
                this._printSetup = (PrintSetupRecord)recordStream.getNext();
                break;
            }
            case 233: {
                this.checkNotPresent(this._bitmap);
                this._bitmap = recordStream.getNext();
                break;
            }
            case 51: {
                this.checkNotPresent(this._printSize);
                this._printSize = recordStream.getNext();
                break;
            }
            case 2204: {
                HeaderFooterRecord headerFooterRecord = (HeaderFooterRecord)recordStream.getNext();
                if (headerFooterRecord.isCurrentSheet()) {
                    this._headerFooter = headerFooterRecord;
                    break;
                }
                this._sviewHeaderFooters.add(headerFooterRecord);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void checkNotPresent(Record record) {
        if (record != null) {
            throw new RecordFormatException("Duplicate PageSettingsBlock record (sid=0x" + Integer.toHexString(record.getSid()) + ")");
        }
    }

    private PageBreakRecord getRowBreaksRecord() {
        if (this._rowBreaksRecord == null) {
            this._rowBreaksRecord = new HorizontalPageBreakRecord();
        }
        return this._rowBreaksRecord;
    }

    private PageBreakRecord getColumnBreaksRecord() {
        if (this._columnBreaksRecord == null) {
            this._columnBreaksRecord = new VerticalPageBreakRecord();
        }
        return this._columnBreaksRecord;
    }

    public void setColumnBreak(short s, short s2, short s3) {
        this.getColumnBreaksRecord().addBreak(s, s2, s3);
    }

    public void removeColumnBreak(int n) {
        this.getColumnBreaksRecord().removeBreak(n);
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        PageSettingsBlock.visitIfPresent(this._rowBreaksRecord, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._columnBreaksRecord, recordVisitor);
        if (this._header == null) {
            recordVisitor.visitRecord(new HeaderRecord(""));
        } else {
            recordVisitor.visitRecord(this._header);
        }
        if (this._footer == null) {
            recordVisitor.visitRecord(new FooterRecord(""));
        } else {
            recordVisitor.visitRecord(this._footer);
        }
        PageSettingsBlock.visitIfPresent(this._hCenter, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._vCenter, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._leftMargin, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._rightMargin, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._topMargin, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._bottomMargin, recordVisitor);
        for (RecordAggregate recordAggregate : this._plsRecords) {
            recordAggregate.visitContainedRecords(recordVisitor);
        }
        PageSettingsBlock.visitIfPresent(this._printSetup, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._printSize, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._headerFooter, recordVisitor);
        PageSettingsBlock.visitIfPresent(this._bitmap, recordVisitor);
    }

    private static void visitIfPresent(Record record, RecordAggregate.RecordVisitor recordVisitor) {
        if (record != null) {
            recordVisitor.visitRecord(record);
        }
    }

    private static void visitIfPresent(PageBreakRecord pageBreakRecord, RecordAggregate.RecordVisitor recordVisitor) {
        if (pageBreakRecord != null) {
            if (pageBreakRecord.isEmpty()) {
                return;
            }
            recordVisitor.visitRecord(pageBreakRecord);
        }
    }

    private static HCenterRecord createHCenter() {
        HCenterRecord hCenterRecord = new HCenterRecord();
        hCenterRecord.setHCenter(false);
        return hCenterRecord;
    }

    private static VCenterRecord createVCenter() {
        VCenterRecord vCenterRecord = new VCenterRecord();
        vCenterRecord.setVCenter(false);
        return vCenterRecord;
    }

    private static PrintSetupRecord createPrintSetup() {
        PrintSetupRecord printSetupRecord = new PrintSetupRecord();
        printSetupRecord.setPaperSize((short)1);
        printSetupRecord.setScale((short)100);
        printSetupRecord.setPageStart((short)1);
        printSetupRecord.setFitWidth((short)1);
        printSetupRecord.setFitHeight((short)1);
        printSetupRecord.setOptions((short)2);
        printSetupRecord.setHResolution((short)300);
        printSetupRecord.setVResolution((short)300);
        printSetupRecord.setHeaderMargin(0.5);
        printSetupRecord.setFooterMargin(0.5);
        printSetupRecord.setCopies((short)1);
        return printSetupRecord;
    }

    public HeaderRecord getHeader() {
        return this._header;
    }

    public void setHeader(HeaderRecord headerRecord) {
        this._header = headerRecord;
    }

    public FooterRecord getFooter() {
        return this._footer;
    }

    public void setFooter(FooterRecord footerRecord) {
        this._footer = footerRecord;
    }

    public PrintSetupRecord getPrintSetup() {
        return this._printSetup;
    }

    public void setPrintSetup(PrintSetupRecord printSetupRecord) {
        this._printSetup = printSetupRecord;
    }

    private Margin getMarginRec(int n) {
        switch (n) {
            case 0: {
                return this._leftMargin;
            }
            case 1: {
                return this._rightMargin;
            }
            case 2: {
                return this._topMargin;
            }
            case 3: {
                return this._bottomMargin;
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + n);
    }

    public double getMargin(short s) {
        Margin margin = this.getMarginRec(s);
        if (margin != null) {
            return margin.getMargin();
        }
        switch (s) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 0.75;
            }
            case 2: {
                return 1.0;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new IllegalArgumentException("Unknown margin constant:  " + s);
    }

    public void setMargin(short s, double d) {
        Margin margin = this.getMarginRec(s);
        if (margin == null) {
            switch (s) {
                case 0: {
                    this._leftMargin = new LeftMarginRecord();
                    margin = this._leftMargin;
                    break;
                }
                case 1: {
                    this._rightMargin = new RightMarginRecord();
                    margin = this._rightMargin;
                    break;
                }
                case 2: {
                    this._topMargin = new TopMarginRecord();
                    margin = this._topMargin;
                    break;
                }
                case 3: {
                    this._bottomMargin = new BottomMarginRecord();
                    margin = this._bottomMargin;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown margin constant:  " + s);
                }
            }
        }
        margin.setMargin(d);
    }

    private static void shiftBreaks(PageBreakRecord pageBreakRecord, int n, int n2, int n3) {
        Iterator<PageBreakRecord.Break> iterator = pageBreakRecord.getBreaksIterator();
        ArrayList<PageBreakRecord.Break> arrayList = new ArrayList<PageBreakRecord.Break>();
        while (iterator.hasNext()) {
            boolean bl;
            PageBreakRecord.Break break_ = iterator.next();
            int n4 = break_.main;
            boolean bl2 = n4 >= n;
            boolean bl3 = bl = n4 <= n2;
            if (!bl2 || !bl) continue;
            arrayList.add(break_);
        }
        for (PageBreakRecord.Break break_ : arrayList) {
            pageBreakRecord.removeBreak(break_.main);
            pageBreakRecord.addBreak((short)(break_.main + n3), break_.subFrom, break_.subTo);
        }
    }

    public void setRowBreak(int n, short s, short s2) {
        this.getRowBreaksRecord().addBreak((short)n, s, s2);
    }

    public void removeRowBreak(int n) {
        if (this.getRowBreaksRecord().getBreaks().length < 1) {
            throw new IllegalArgumentException("Sheet does not define any row breaks");
        }
        this.getRowBreaksRecord().removeBreak((short)n);
    }

    public boolean isRowBroken(int n) {
        return this.getRowBreaksRecord().getBreak(n) != null;
    }

    public boolean isColumnBroken(int n) {
        return this.getColumnBreaksRecord().getBreak(n) != null;
    }

    public void shiftRowBreaks(int n, int n2, int n3) {
        PageSettingsBlock.shiftBreaks(this.getRowBreaksRecord(), n, n2, n3);
    }

    public void shiftColumnBreaks(short s, short s2, short s3) {
        PageSettingsBlock.shiftBreaks(this.getColumnBreaksRecord(), s, s2, s3);
    }

    public int[] getRowBreaks() {
        return this.getRowBreaksRecord().getBreaks();
    }

    public int getNumRowBreaks() {
        return this.getRowBreaksRecord().getNumBreaks();
    }

    public int[] getColumnBreaks() {
        return this.getColumnBreaksRecord().getBreaks();
    }

    public int getNumColumnBreaks() {
        return this.getColumnBreaksRecord().getNumBreaks();
    }

    public VCenterRecord getVCenter() {
        return this._vCenter;
    }

    public HCenterRecord getHCenter() {
        return this._hCenter;
    }

    public void addLateHeaderFooter(HeaderFooterRecord headerFooterRecord) {
        if (this._headerFooter != null) {
            throw new IllegalStateException("This page settings block already has a header/footer record");
        }
        if (headerFooterRecord.getSid() != 2204) {
            throw new RecordFormatException("Unexpected header-footer record sid: 0x" + Integer.toHexString(headerFooterRecord.getSid()));
        }
        this._headerFooter = headerFooterRecord;
    }

    public void addLateRecords(RecordStream recordStream) {
        while (this.readARecord(recordStream)) {
        }
    }

    public void positionRecords(List<RecordBase> list) {
        ArrayList<HeaderFooterRecord> arrayList = new ArrayList<HeaderFooterRecord>(this._sviewHeaderFooters);
        final HashMap<String, HeaderFooterRecord> hashMap = new HashMap<String, HeaderFooterRecord>();
        for (HeaderFooterRecord recordBase : arrayList) {
            hashMap.put(HexDump.toHex(recordBase.getGuid()), recordBase);
        }
        for (RecordBase recordBase : list) {
            if (!(recordBase instanceof CustomViewSettingsRecordAggregate)) continue;
            final CustomViewSettingsRecordAggregate customViewSettingsRecordAggregate = (CustomViewSettingsRecordAggregate)recordBase;
            customViewSettingsRecordAggregate.visitContainedRecords(new RecordAggregate.RecordVisitor(){

                public void visitRecord(Record record) {
                    String string;
                    HeaderFooterRecord headerFooterRecord;
                    if (record.getSid() == 426 && (headerFooterRecord = (HeaderFooterRecord)hashMap.get(string = HexDump.toHex(((UserSViewBegin)record).getGuid()))) != null) {
                        customViewSettingsRecordAggregate.append(headerFooterRecord);
                        PageSettingsBlock.this._sviewHeaderFooters.remove(headerFooterRecord);
                    }
                }
            });
        }
    }

    private static final class PLSAggregate
    extends RecordAggregate {
        private static final ContinueRecord[] EMPTY_CONTINUE_RECORD_ARRAY = new ContinueRecord[0];
        private final Record _pls;
        private ContinueRecord[] _plsContinues;

        public PLSAggregate(RecordStream recordStream) {
            this._pls = recordStream.getNext();
            if (recordStream.peekNextSid() == 60) {
                ArrayList<ContinueRecord> arrayList = new ArrayList<ContinueRecord>();
                while (recordStream.peekNextSid() == 60) {
                    arrayList.add((ContinueRecord)recordStream.getNext());
                }
                this._plsContinues = new ContinueRecord[arrayList.size()];
                arrayList.toArray(this._plsContinues);
            } else {
                this._plsContinues = EMPTY_CONTINUE_RECORD_ARRAY;
            }
        }

        public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
            recordVisitor.visitRecord(this._pls);
            for (int i = 0; i < this._plsContinues.length; ++i) {
                recordVisitor.visitRecord(this._plsContinues[i]);
            }
        }
    }
}

