/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record.aggregates;

import ai.org.apache.poi.hssf.model.RecordStream;
import ai.org.apache.poi.hssf.record.DVALRecord;
import ai.org.apache.poi.hssf.record.DVRecord;
import ai.org.apache.poi.hssf.record.Record;
import ai.org.apache.poi.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.List;

public final class DataValidityTable
extends RecordAggregate {
    private final DVALRecord _headerRec;
    private final List _validationList;

    public DataValidityTable(RecordStream recordStream) {
        this._headerRec = (DVALRecord)recordStream.getNext();
        ArrayList<Record> arrayList = new ArrayList<Record>();
        while (recordStream.peekNextClass() == DVRecord.class) {
            arrayList.add(recordStream.getNext());
        }
        this._validationList = arrayList;
    }

    public DataValidityTable() {
        this._headerRec = new DVALRecord();
        this._validationList = new ArrayList();
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        if (this._validationList.isEmpty()) {
            return;
        }
        recordVisitor.visitRecord(this._headerRec);
        for (int i = 0; i < this._validationList.size(); ++i) {
            recordVisitor.visitRecord((Record)this._validationList.get(i));
        }
    }

    public void addDataValidation(DVRecord dVRecord) {
        this._validationList.add(dVRecord);
        this._headerRec.setDVRecNo(this._validationList.size());
    }
}

