/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndian;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;
import java.util.Arrays;

public final class WriteAccessRecord
extends StandardRecord {
    public static final short sid = 92;
    private static final byte PAD_CHAR = 32;
    private static final int DATA_SIZE = 112;
    private String field_1_username;
    private static final byte[] PADDING = new byte[112];

    public WriteAccessRecord() {
        this.setUsername("");
    }

    public WriteAccessRecord(RecordInputStream recordInputStream) {
        if (recordInputStream.remaining() > 112) {
            throw new RecordFormatException("Expected data size (112) but got (" + recordInputStream.remaining() + ")");
        }
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUByte();
        if (n > 112 || (n2 & 0xFE) != 0) {
            byte[] byArray = new byte[3 + recordInputStream.remaining()];
            LittleEndian.putUShort(byArray, 0, n);
            LittleEndian.putByte(byArray, 2, n2);
            recordInputStream.readFully(byArray, 3, byArray.length - 3);
            String string = new String(byArray);
            this.setUsername(string.trim());
            return;
        }
        String string = (n2 & 1) == 0 ? StringUtil.readCompressedUnicode(recordInputStream, n) : StringUtil.readUnicodeLE(recordInputStream, n);
        this.field_1_username = string.trim();
        for (int i = recordInputStream.remaining(); i > 0; --i) {
            recordInputStream.readUByte();
        }
    }

    public void setUsername(String string) {
        boolean bl = StringUtil.hasMultibyte(string);
        int n = 3 + string.length() * (bl ? 2 : 1);
        int n2 = 112 - n;
        if (n2 < 0) {
            throw new IllegalArgumentException("Name is too long: " + string);
        }
        this.field_1_username = string;
    }

    public String getUsername() {
        return this.field_1_username;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WRITEACCESS]\n");
        stringBuffer.append("    .name = ").append(this.field_1_username).append("\n");
        stringBuffer.append("[/WRITEACCESS]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        String string = this.getUsername();
        boolean bl = StringUtil.hasMultibyte(string);
        littleEndianOutput.writeShort(string.length());
        littleEndianOutput.writeByte(bl ? 1 : 0);
        if (bl) {
            StringUtil.putUnicodeLE(string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(string, littleEndianOutput);
        }
        int n = 3 + string.length() * (bl ? 2 : 1);
        int n2 = 112 - n;
        littleEndianOutput.write(PADDING, 0, n2);
    }

    protected int getDataSize() {
        return 112;
    }

    public short getSid() {
        return 92;
    }

    static {
        Arrays.fill(PADDING, (byte)32);
    }
}

