/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class WSBoolRecord
extends StandardRecord {
    public static final short sid = 129;
    private byte field_1_wsbool;
    private byte field_2_wsbool;
    private static final BitField autobreaks = BitFieldFactory.getInstance(1);
    private static final BitField dialog = BitFieldFactory.getInstance(16);
    private static final BitField applystyles = BitFieldFactory.getInstance(32);
    private static final BitField rowsumsbelow = BitFieldFactory.getInstance(64);
    private static final BitField rowsumsright = BitFieldFactory.getInstance(128);
    private static final BitField fittopage = BitFieldFactory.getInstance(1);
    private static final BitField displayguts = BitFieldFactory.getInstance(6);
    private static final BitField alternateexpression = BitFieldFactory.getInstance(64);
    private static final BitField alternateformula = BitFieldFactory.getInstance(128);

    public WSBoolRecord() {
    }

    public WSBoolRecord(RecordInputStream recordInputStream) {
        byte[] byArray = recordInputStream.readRemainder();
        this.field_1_wsbool = byArray[1];
        this.field_2_wsbool = byArray[0];
    }

    public void setWSBool1(byte by) {
        this.field_1_wsbool = by;
    }

    public void setAutobreaks(boolean bl) {
        this.field_1_wsbool = autobreaks.setByteBoolean(this.field_1_wsbool, bl);
    }

    public void setDialog(boolean bl) {
        this.field_1_wsbool = dialog.setByteBoolean(this.field_1_wsbool, bl);
    }

    public void setRowSumsBelow(boolean bl) {
        this.field_1_wsbool = rowsumsbelow.setByteBoolean(this.field_1_wsbool, bl);
    }

    public void setRowSumsRight(boolean bl) {
        this.field_1_wsbool = rowsumsright.setByteBoolean(this.field_1_wsbool, bl);
    }

    public void setWSBool2(byte by) {
        this.field_2_wsbool = by;
    }

    public void setFitToPage(boolean bl) {
        this.field_2_wsbool = fittopage.setByteBoolean(this.field_2_wsbool, bl);
    }

    public void setDisplayGuts(boolean bl) {
        this.field_2_wsbool = displayguts.setByteBoolean(this.field_2_wsbool, bl);
    }

    public void setAlternateExpression(boolean bl) {
        this.field_2_wsbool = alternateexpression.setByteBoolean(this.field_2_wsbool, bl);
    }

    public void setAlternateFormula(boolean bl) {
        this.field_2_wsbool = alternateformula.setByteBoolean(this.field_2_wsbool, bl);
    }

    public byte getWSBool1() {
        return this.field_1_wsbool;
    }

    public boolean getAutobreaks() {
        return autobreaks.isSet(this.field_1_wsbool);
    }

    public boolean getDialog() {
        return dialog.isSet(this.field_1_wsbool);
    }

    public boolean getRowSumsBelow() {
        return rowsumsbelow.isSet(this.field_1_wsbool);
    }

    public boolean getRowSumsRight() {
        return rowsumsright.isSet(this.field_1_wsbool);
    }

    public byte getWSBool2() {
        return this.field_2_wsbool;
    }

    public boolean getFitToPage() {
        return fittopage.isSet(this.field_2_wsbool);
    }

    public boolean getDisplayGuts() {
        return displayguts.isSet(this.field_2_wsbool);
    }

    public boolean getAlternateExpression() {
        return alternateexpression.isSet(this.field_2_wsbool);
    }

    public boolean getAlternateFormula() {
        return alternateformula.isSet(this.field_2_wsbool);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[WSBOOL]\n");
        stringBuffer.append("    .wsbool1        = ").append(Integer.toHexString(this.getWSBool1())).append("\n");
        stringBuffer.append("        .autobreaks = ").append(this.getAutobreaks()).append("\n");
        stringBuffer.append("        .dialog     = ").append(this.getDialog()).append("\n");
        stringBuffer.append("        .rowsumsbelw= ").append(this.getRowSumsBelow()).append("\n");
        stringBuffer.append("        .rowsumsrigt= ").append(this.getRowSumsRight()).append("\n");
        stringBuffer.append("    .wsbool2        = ").append(Integer.toHexString(this.getWSBool2())).append("\n");
        stringBuffer.append("        .fittopage  = ").append(this.getFitToPage()).append("\n");
        stringBuffer.append("        .displayguts= ").append(this.getDisplayGuts()).append("\n");
        stringBuffer.append("        .alternateex= ").append(this.getAlternateExpression()).append("\n");
        stringBuffer.append("        .alternatefo= ").append(this.getAlternateFormula()).append("\n");
        stringBuffer.append("[/WSBOOL]\n");
        return stringBuffer.toString();
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.getWSBool2());
        littleEndianOutput.writeByte(this.getWSBool1());
    }

    protected int getDataSize() {
        return 2;
    }

    public short getSid() {
        return 129;
    }

    public Object clone() {
        WSBoolRecord wSBoolRecord = new WSBoolRecord();
        wSBoolRecord.field_1_wsbool = this.field_1_wsbool;
        wSBoolRecord.field_2_wsbool = this.field_2_wsbool;
        return wSBoolRecord;
    }
}

