/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecord;
import ai.org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import ai.org.apache.poi.hssf.usermodel.HSSFRichTextString;
import ai.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;

public final class TextObjectRecord
extends ContinuableRecord {
    public static final short sid = 438;
    private static final int FORMAT_RUN_ENCODED_SIZE = 8;
    private static final BitField HorizontalTextAlignment = BitFieldFactory.getInstance(14);
    private static final BitField VerticalTextAlignment = BitFieldFactory.getInstance(112);
    private static final BitField textLocked = BitFieldFactory.getInstance(512);
    public static final short HORIZONTAL_TEXT_ALIGNMENT_LEFT_ALIGNED = 1;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_RIGHT_ALIGNED = 3;
    public static final short HORIZONTAL_TEXT_ALIGNMENT_JUSTIFIED = 4;
    public static final short VERTICAL_TEXT_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_TEXT_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_TEXT_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_TEXT_ALIGNMENT_JUSTIFY = 4;
    public static final short TEXT_ORIENTATION_NONE = 0;
    public static final short TEXT_ORIENTATION_TOP_TO_BOTTOM = 1;
    public static final short TEXT_ORIENTATION_ROT_RIGHT = 2;
    public static final short TEXT_ORIENTATION_ROT_LEFT = 3;
    private int field_1_options;
    private int field_2_textOrientation;
    private int field_3_reserved4;
    private int field_4_reserved5;
    private int field_5_reserved6;
    private int field_8_reserved7;
    private HSSFRichTextString _text;
    private int _unknownPreFormulaInt;
    private OperandPtg _linkRefPtg;
    private Byte _unknownPostFormulaByte;

    public TextObjectRecord() {
    }

    public TextObjectRecord(RecordInputStream recordInputStream) {
        this.field_1_options = recordInputStream.readUShort();
        this.field_2_textOrientation = recordInputStream.readUShort();
        this.field_3_reserved4 = recordInputStream.readUShort();
        this.field_4_reserved5 = recordInputStream.readUShort();
        this.field_5_reserved6 = recordInputStream.readUShort();
        int n = recordInputStream.readUShort();
        int n2 = recordInputStream.readUShort();
        this.field_8_reserved7 = recordInputStream.readInt();
        if (recordInputStream.remaining() > 0) {
            if (recordInputStream.remaining() < 11) {
                throw new RecordFormatException("Not enough remaining data for a link formula");
            }
            int n3 = recordInputStream.readUShort();
            this._unknownPreFormulaInt = recordInputStream.readInt();
            Ptg[] ptgArray = Ptg.readTokens(n3, recordInputStream);
            if (ptgArray.length != 1) {
                throw new RecordFormatException("Read " + ptgArray.length + " tokens but expected exactly 1");
            }
            this._linkRefPtg = (OperandPtg)ptgArray[0];
            this._unknownPostFormulaByte = recordInputStream.remaining() > 0 ? Byte.valueOf(recordInputStream.readByte()) : null;
        } else {
            this._linkRefPtg = null;
        }
        if (recordInputStream.remaining() > 0) {
            throw new RecordFormatException("Unused " + recordInputStream.remaining() + " bytes at end of record");
        }
        String string = n > 0 ? TextObjectRecord.readRawString(recordInputStream, n) : "";
        this._text = new HSSFRichTextString(string);
        if (n2 > 0) {
            TextObjectRecord.processFontRuns(recordInputStream, this._text, n2);
        }
    }

    private static String readRawString(RecordInputStream recordInputStream, int n) {
        boolean bl;
        byte by = recordInputStream.readByte();
        boolean bl2 = bl = (by & 1) == 0;
        if (bl) {
            return recordInputStream.readCompressedUnicode(n);
        }
        return recordInputStream.readUnicodeLEString(n);
    }

    private static void processFontRuns(RecordInputStream recordInputStream, HSSFRichTextString hSSFRichTextString, int n) {
        if (n % 8 != 0) {
            throw new RecordFormatException("Bad format run data length " + n + ")");
        }
        int n2 = n / 8;
        for (int i = 0; i < n2; ++i) {
            short s = recordInputStream.readShort();
            short s2 = recordInputStream.readShort();
            recordInputStream.readInt();
            hSSFRichTextString.applyFont((int)s, hSSFRichTextString.length(), s2);
        }
    }

    public short getSid() {
        return 438;
    }

    private void serializeTXORecord(ContinuableRecordOutput continuableRecordOutput) {
        continuableRecordOutput.writeShort(this.field_1_options);
        continuableRecordOutput.writeShort(this.field_2_textOrientation);
        continuableRecordOutput.writeShort(this.field_3_reserved4);
        continuableRecordOutput.writeShort(this.field_4_reserved5);
        continuableRecordOutput.writeShort(this.field_5_reserved6);
        continuableRecordOutput.writeShort(this._text.length());
        continuableRecordOutput.writeShort(this.getFormattingDataLength());
        continuableRecordOutput.writeInt(this.field_8_reserved7);
        if (this._linkRefPtg != null) {
            int n = this._linkRefPtg.getSize();
            continuableRecordOutput.writeShort(n);
            continuableRecordOutput.writeInt(this._unknownPreFormulaInt);
            this._linkRefPtg.write(continuableRecordOutput);
            if (this._unknownPostFormulaByte != null) {
                continuableRecordOutput.writeByte(this._unknownPostFormulaByte.byteValue());
            }
        }
    }

    private void serializeTrailingRecords(ContinuableRecordOutput continuableRecordOutput) {
        continuableRecordOutput.writeContinue();
        continuableRecordOutput.writeStringData(this._text.getString());
        continuableRecordOutput.writeContinue();
        TextObjectRecord.writeFormatData(continuableRecordOutput, this._text);
    }

    protected void serialize(ContinuableRecordOutput continuableRecordOutput) {
        this.serializeTXORecord(continuableRecordOutput);
        if (this._text.getString().length() > 0) {
            this.serializeTrailingRecords(continuableRecordOutput);
        }
    }

    private int getFormattingDataLength() {
        if (this._text.length() < 1) {
            return 0;
        }
        return (this._text.numFormattingRuns() + 1) * 8;
    }

    private static void writeFormatData(ContinuableRecordOutput continuableRecordOutput, HSSFRichTextString hSSFRichTextString) {
        int n = hSSFRichTextString.numFormattingRuns();
        for (int i = 0; i < n; ++i) {
            continuableRecordOutput.writeShort(hSSFRichTextString.getIndexOfFormattingRun(i));
            short s = hSSFRichTextString.getFontOfFormattingRun(i);
            continuableRecordOutput.writeShort(s == 0 ? (short)0 : s);
            continuableRecordOutput.writeInt(0);
        }
        continuableRecordOutput.writeShort(hSSFRichTextString.length());
        continuableRecordOutput.writeShort(0);
        continuableRecordOutput.writeInt(0);
    }

    public void setHorizontalTextAlignment(int n) {
        this.field_1_options = HorizontalTextAlignment.setValue(this.field_1_options, n);
    }

    public int getHorizontalTextAlignment() {
        return HorizontalTextAlignment.getValue(this.field_1_options);
    }

    public void setVerticalTextAlignment(int n) {
        this.field_1_options = VerticalTextAlignment.setValue(this.field_1_options, n);
    }

    public int getVerticalTextAlignment() {
        return VerticalTextAlignment.getValue(this.field_1_options);
    }

    public void setTextLocked(boolean bl) {
        this.field_1_options = textLocked.setBoolean(this.field_1_options, bl);
    }

    public boolean isTextLocked() {
        return textLocked.isSet(this.field_1_options);
    }

    public int getTextOrientation() {
        return this.field_2_textOrientation;
    }

    public void setTextOrientation(int n) {
        this.field_2_textOrientation = n;
    }

    public HSSFRichTextString getStr() {
        return this._text;
    }

    public void setStr(HSSFRichTextString hSSFRichTextString) {
        this._text = hSSFRichTextString;
    }

    public Ptg getLinkRefPtg() {
        return this._linkRefPtg;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TXO]\n");
        stringBuffer.append("    .options        = ").append(HexDump.shortToHex(this.field_1_options)).append("\n");
        stringBuffer.append("         .isHorizontal = ").append(this.getHorizontalTextAlignment()).append('\n');
        stringBuffer.append("         .isVertical   = ").append(this.getVerticalTextAlignment()).append('\n');
        stringBuffer.append("         .textLocked   = ").append(this.isTextLocked()).append('\n');
        stringBuffer.append("    .textOrientation= ").append(HexDump.shortToHex(this.getTextOrientation())).append("\n");
        stringBuffer.append("    .reserved4      = ").append(HexDump.shortToHex(this.field_3_reserved4)).append("\n");
        stringBuffer.append("    .reserved5      = ").append(HexDump.shortToHex(this.field_4_reserved5)).append("\n");
        stringBuffer.append("    .reserved6      = ").append(HexDump.shortToHex(this.field_5_reserved6)).append("\n");
        stringBuffer.append("    .textLength     = ").append(HexDump.shortToHex(this._text.length())).append("\n");
        stringBuffer.append("    .reserved7      = ").append(HexDump.intToHex(this.field_8_reserved7)).append("\n");
        stringBuffer.append("    .string = ").append(this._text).append('\n');
        for (int i = 0; i < this._text.numFormattingRuns(); ++i) {
            stringBuffer.append("    .textrun = ").append(this._text.getFontOfFormattingRun(i)).append('\n');
        }
        stringBuffer.append("[/TXO]\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        TextObjectRecord textObjectRecord = new TextObjectRecord();
        textObjectRecord._text = this._text;
        textObjectRecord.field_1_options = this.field_1_options;
        textObjectRecord.field_2_textOrientation = this.field_2_textOrientation;
        textObjectRecord.field_3_reserved4 = this.field_3_reserved4;
        textObjectRecord.field_4_reserved5 = this.field_4_reserved5;
        textObjectRecord.field_5_reserved6 = this.field_5_reserved6;
        textObjectRecord.field_8_reserved7 = this.field_8_reserved7;
        textObjectRecord._text = this._text;
        if (this._linkRefPtg != null) {
            textObjectRecord._unknownPreFormulaInt = this._unknownPreFormulaInt;
            textObjectRecord._linkRefPtg = this._linkRefPtg.copy();
            textObjectRecord._unknownPostFormulaByte = this._unknownPostFormulaByte;
        }
        return textObjectRecord;
    }
}

