/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.SharedValueRecordBase;
import ai.org.apache.poi.hssf.util.CellRangeAddress8Bit;
import ai.org.apache.poi.hssf.util.CellReference;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class TableRecord
extends SharedValueRecordBase {
    public static final short sid = 566;
    private static final BitField alwaysCalc = BitFieldFactory.getInstance(1);
    private static final BitField calcOnOpen = BitFieldFactory.getInstance(2);
    private static final BitField rowOrColInpCell = BitFieldFactory.getInstance(4);
    private static final BitField oneOrTwoVar = BitFieldFactory.getInstance(8);
    private static final BitField rowDeleted = BitFieldFactory.getInstance(16);
    private static final BitField colDeleted = BitFieldFactory.getInstance(32);
    private int field_5_flags;
    private int field_6_res;
    private int field_7_rowInputRow;
    private int field_8_colInputRow;
    private int field_9_rowInputCol;
    private int field_10_colInputCol;

    public TableRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_5_flags = recordInputStream.readByte();
        this.field_6_res = recordInputStream.readByte();
        this.field_7_rowInputRow = recordInputStream.readShort();
        this.field_8_colInputRow = recordInputStream.readShort();
        this.field_9_rowInputCol = recordInputStream.readShort();
        this.field_10_colInputCol = recordInputStream.readShort();
    }

    public TableRecord(CellRangeAddress8Bit cellRangeAddress8Bit) {
        super(cellRangeAddress8Bit);
        this.field_6_res = 0;
    }

    public int getFlags() {
        return this.field_5_flags;
    }

    public void setFlags(int n) {
        this.field_5_flags = n;
    }

    public int getRowInputRow() {
        return this.field_7_rowInputRow;
    }

    public void setRowInputRow(int n) {
        this.field_7_rowInputRow = n;
    }

    public int getColInputRow() {
        return this.field_8_colInputRow;
    }

    public void setColInputRow(int n) {
        this.field_8_colInputRow = n;
    }

    public int getRowInputCol() {
        return this.field_9_rowInputCol;
    }

    public void setRowInputCol(int n) {
        this.field_9_rowInputCol = n;
    }

    public int getColInputCol() {
        return this.field_10_colInputCol;
    }

    public void setColInputCol(int n) {
        this.field_10_colInputCol = n;
    }

    public boolean isAlwaysCalc() {
        return alwaysCalc.isSet(this.field_5_flags);
    }

    public void setAlwaysCalc(boolean bl) {
        this.field_5_flags = alwaysCalc.setBoolean(this.field_5_flags, bl);
    }

    public boolean isRowOrColInpCell() {
        return rowOrColInpCell.isSet(this.field_5_flags);
    }

    public void setRowOrColInpCell(boolean bl) {
        this.field_5_flags = rowOrColInpCell.setBoolean(this.field_5_flags, bl);
    }

    public boolean isOneNotTwoVar() {
        return oneOrTwoVar.isSet(this.field_5_flags);
    }

    public void setOneNotTwoVar(boolean bl) {
        this.field_5_flags = oneOrTwoVar.setBoolean(this.field_5_flags, bl);
    }

    public boolean isColDeleted() {
        return colDeleted.isSet(this.field_5_flags);
    }

    public void setColDeleted(boolean bl) {
        this.field_5_flags = colDeleted.setBoolean(this.field_5_flags, bl);
    }

    public boolean isRowDeleted() {
        return rowDeleted.isSet(this.field_5_flags);
    }

    public void setRowDeleted(boolean bl) {
        this.field_5_flags = rowDeleted.setBoolean(this.field_5_flags, bl);
    }

    public short getSid() {
        return 566;
    }

    protected int getExtraDataSize() {
        return 10;
    }

    protected void serializeExtraData(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(this.field_5_flags);
        littleEndianOutput.writeByte(this.field_6_res);
        littleEndianOutput.writeShort(this.field_7_rowInputRow);
        littleEndianOutput.writeShort(this.field_8_colInputRow);
        littleEndianOutput.writeShort(this.field_9_rowInputCol);
        littleEndianOutput.writeShort(this.field_10_colInputCol);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[TABLE]\n");
        stringBuffer.append("    .range    = ").append(this.getRange().toString()).append("\n");
        stringBuffer.append("    .flags    = ").append(HexDump.byteToHex(this.field_5_flags)).append("\n");
        stringBuffer.append("    .alwaysClc= ").append(this.isAlwaysCalc()).append("\n");
        stringBuffer.append("    .reserved = ").append(HexDump.intToHex(this.field_6_res)).append("\n");
        CellReference cellReference = TableRecord.cr(this.field_7_rowInputRow, this.field_8_colInputRow);
        CellReference cellReference2 = TableRecord.cr(this.field_9_rowInputCol, this.field_10_colInputCol);
        stringBuffer.append("    .rowInput = ").append(cellReference.formatAsString()).append("\n");
        stringBuffer.append("    .colInput = ").append(cellReference2.formatAsString()).append("\n");
        stringBuffer.append("[/TABLE]\n");
        return stringBuffer.toString();
    }

    private static CellReference cr(int n, int n2) {
        int n3 = n2 & 0xFF;
        boolean bl = (n2 & 0x8000) == 0;
        boolean bl2 = (n2 & 0x4000) == 0;
        return new CellReference(n, n3, bl, bl2);
    }
}

