/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import ai.org.apache.poi.util.StringUtil;

public final class SupBookRecord
extends StandardRecord {
    private static final POILogger logger = POILogFactory.getLogger(SupBookRecord.class);
    public static final short sid = 430;
    private static final short SMALL_RECORD_SIZE = 4;
    private static final short TAG_INTERNAL_REFERENCES = 1025;
    private static final short TAG_ADD_IN_FUNCTIONS = 14849;
    private short field_1_number_of_sheets;
    private String field_2_encoded_url;
    private String[] field_3_sheet_names;
    private boolean _isAddInFunctions;
    protected static final char CH_VOLUME = '\u0001';
    protected static final char CH_SAME_VOLUME = '\u0002';
    protected static final char CH_DOWN_DIR = '\u0003';
    protected static final char CH_UP_DIR = '\u0004';
    protected static final char CH_LONG_VOLUME = '\u0005';
    protected static final char CH_STARTUP_DIR = '\u0006';
    protected static final char CH_ALT_STARTUP_DIR = '\u0007';
    protected static final char CH_LIB_DIR = '\b';
    protected static final String PATH_SEPERATOR = System.getProperty("file.separator");

    public static SupBookRecord createInternalReferences(short s) {
        return new SupBookRecord(false, s);
    }

    public static SupBookRecord createAddInFunctions() {
        return new SupBookRecord(true, 1);
    }

    public static SupBookRecord createExternalReferences(String string, String[] stringArray) {
        return new SupBookRecord(string, stringArray);
    }

    private SupBookRecord(boolean bl, short s) {
        this.field_1_number_of_sheets = s;
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        this._isAddInFunctions = bl;
    }

    public SupBookRecord(String string, String[] stringArray) {
        this.field_1_number_of_sheets = (short)stringArray.length;
        this.field_2_encoded_url = string;
        this.field_3_sheet_names = stringArray;
        this._isAddInFunctions = false;
    }

    public boolean isExternalReferences() {
        return this.field_3_sheet_names != null;
    }

    public boolean isInternalReferences() {
        return this.field_3_sheet_names == null && !this._isAddInFunctions;
    }

    public boolean isAddInFunctions() {
        return this.field_3_sheet_names == null && this._isAddInFunctions;
    }

    public SupBookRecord(RecordInputStream recordInputStream) {
        int n = recordInputStream.remaining();
        this.field_1_number_of_sheets = recordInputStream.readShort();
        if (n > 4) {
            this._isAddInFunctions = false;
            this.field_2_encoded_url = recordInputStream.readString();
            String[] stringArray = new String[this.field_1_number_of_sheets];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = recordInputStream.readString();
            }
            this.field_3_sheet_names = stringArray;
            return;
        }
        this.field_2_encoded_url = null;
        this.field_3_sheet_names = null;
        short s = recordInputStream.readShort();
        if (s == 1025) {
            this._isAddInFunctions = false;
        } else if (s == 14849) {
            this._isAddInFunctions = true;
            if (this.field_1_number_of_sheets != 1) {
                throw new RuntimeException("Expected 0x0001 for number of sheets field in 'Add-In Functions' but got (" + this.field_1_number_of_sheets + ")");
            }
        } else {
            throw new RuntimeException("invalid EXTERNALBOOK code (" + Integer.toHexString(s) + ")");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[SUPBOOK ");
        if (this.isExternalReferences()) {
            stringBuffer.append("External References]\n");
            stringBuffer.append(" .url     = ").append(this.field_2_encoded_url).append("\n");
            stringBuffer.append(" .nSheets = ").append(this.field_1_number_of_sheets).append("\n");
            for (String string : this.field_3_sheet_names) {
                stringBuffer.append("    .name = ").append(string).append("\n");
            }
            stringBuffer.append("[/SUPBOOK");
        } else if (this._isAddInFunctions) {
            stringBuffer.append("Add-In Functions");
        } else {
            stringBuffer.append("Internal References");
            stringBuffer.append(" nSheets=").append(this.field_1_number_of_sheets);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        if (!this.isExternalReferences()) {
            return 4;
        }
        int n = 2;
        n += StringUtil.getEncodedSize(this.field_2_encoded_url);
        for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
            n += StringUtil.getEncodedSize(this.field_3_sheet_names[i]);
        }
        return n;
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_number_of_sheets);
        if (this.isExternalReferences()) {
            StringUtil.writeUnicodeString(littleEndianOutput, this.field_2_encoded_url);
            for (int i = 0; i < this.field_3_sheet_names.length; ++i) {
                StringUtil.writeUnicodeString(littleEndianOutput, this.field_3_sheet_names[i]);
            }
        } else {
            int n = this._isAddInFunctions ? 14849 : 1025;
            littleEndianOutput.writeShort(n);
        }
    }

    public void setNumberOfSheets(short s) {
        this.field_1_number_of_sheets = s;
    }

    public short getNumberOfSheets() {
        return this.field_1_number_of_sheets;
    }

    public short getSid() {
        return 430;
    }

    public String getURL() {
        String string = this.field_2_encoded_url;
        switch (string.charAt(0)) {
            case '\u0000': {
                return string.substring(1);
            }
            case '\u0001': {
                return SupBookRecord.decodeFileName(string);
            }
            case '\u0002': {
                return string.substring(1);
            }
        }
        return string;
    }

    private static String decodeFileName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0001': {
                    char c2 = string.charAt(++i);
                    if (c2 == '@') {
                        stringBuilder.append("\\\\");
                        continue block8;
                    }
                    stringBuilder.append(c2).append(":");
                    continue block8;
                }
                case '\u0002': {
                    stringBuilder.append(PATH_SEPERATOR);
                    continue block8;
                }
                case '\u0003': {
                    stringBuilder.append(PATH_SEPERATOR);
                    continue block8;
                }
                case '\u0004': {
                    stringBuilder.append("..").append(PATH_SEPERATOR);
                    continue block8;
                }
                case '\u0005': {
                    logger.log(5, "Found unexpected key: ChLongVolume - IGNORING");
                    continue block8;
                }
                case '\u0006': 
                case '\u0007': 
                case '\b': {
                    logger.log(5, "EXCEL.EXE path unkown - using this directoy instead: .");
                    stringBuilder.append(".").append(PATH_SEPERATOR);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public String[] getSheetNames() {
        return (String[])this.field_3_sheet_names.clone();
    }

    public void setURL(String string) {
        this.field_2_encoded_url = this.field_2_encoded_url.substring(0, 1) + string;
    }
}

