/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import ai.org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import ai.org.apache.poi.hssf.record.EndSubRecord;
import ai.org.apache.poi.hssf.record.FtCblsSubRecord;
import ai.org.apache.poi.hssf.record.FtCfSubRecord;
import ai.org.apache.poi.hssf.record.FtPioGrbitSubRecord;
import ai.org.apache.poi.hssf.record.GroupMarkerSubRecord;
import ai.org.apache.poi.hssf.record.LbsDataSubRecord;
import ai.org.apache.poi.hssf.record.NoteStructureSubRecord;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.LittleEndianOutputStream;
import java.io.ByteArrayOutputStream;

public abstract class SubRecord {
    protected SubRecord() {
    }

    public static SubRecord createSubRecord(LittleEndianInput littleEndianInput, int n) {
        int n2 = littleEndianInput.readUShort();
        int n3 = littleEndianInput.readUShort();
        switch (n2) {
            case 21: {
                return new CommonObjectDataSubRecord(littleEndianInput, n3);
            }
            case 9: {
                return new EmbeddedObjectRefSubRecord(littleEndianInput, n3);
            }
            case 6: {
                return new GroupMarkerSubRecord(littleEndianInput, n3);
            }
            case 0: {
                return new EndSubRecord(littleEndianInput, n3);
            }
            case 13: {
                return new NoteStructureSubRecord(littleEndianInput, n3);
            }
            case 19: {
                return new LbsDataSubRecord(littleEndianInput, n3, n);
            }
            case 12: {
                return new FtCblsSubRecord(littleEndianInput, n3);
            }
            case 8: {
                return new FtPioGrbitSubRecord(littleEndianInput, n3);
            }
            case 7: {
                return new FtCfSubRecord(littleEndianInput, n3);
            }
        }
        return new UnknownSubRecord(littleEndianInput, n2, n3);
    }

    protected abstract int getDataSize();

    public byte[] serialize() {
        int n = this.getDataSize() + 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        this.serialize(new LittleEndianOutputStream(byteArrayOutputStream));
        if (byteArrayOutputStream.size() != n) {
            throw new RuntimeException("write size mismatch");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public abstract void serialize(LittleEndianOutput var1);

    public abstract Object clone();

    public boolean isTerminating() {
        return false;
    }

    private static final class UnknownSubRecord
    extends SubRecord {
        private final int _sid;
        private final byte[] _data;

        public UnknownSubRecord(LittleEndianInput littleEndianInput, int n, int n2) {
            this._sid = n;
            byte[] byArray = new byte[n2];
            littleEndianInput.readFully(byArray);
            this._data = byArray;
        }

        protected int getDataSize() {
            return this._data.length;
        }

        public void serialize(LittleEndianOutput littleEndianOutput) {
            littleEndianOutput.writeShort(this._sid);
            littleEndianOutput.writeShort(this._data.length);
            littleEndianOutput.write(this._data);
        }

        public Object clone() {
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append("sid=").append(HexDump.shortToHex(this._sid));
            stringBuffer.append(" size=").append(this._data.length);
            stringBuffer.append(" : ").append(HexDump.toHex(this._data));
            stringBuffer.append("]\n");
            return stringBuffer.toString();
        }
    }
}

