/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.hssf.record;

import ai.org.apache.poi.hssf.record.RecordFormatException;
import ai.org.apache.poi.hssf.record.RecordInputStream;
import ai.org.apache.poi.hssf.record.StandardRecord;
import ai.org.apache.poi.util.BitField;
import ai.org.apache.poi.util.BitFieldFactory;
import ai.org.apache.poi.util.HexDump;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class StyleRecord
extends StandardRecord {
    public static final short sid = 659;
    private static final BitField styleIndexMask = BitFieldFactory.getInstance(4095);
    private static final BitField isBuiltinFlag = BitFieldFactory.getInstance(32768);
    private int field_1_xf_index;
    private int field_2_builtin_style;
    private int field_3_outline_style_level;
    private boolean field_3_stringHasMultibyte;
    private String field_4_name;

    public StyleRecord() {
        this.field_1_xf_index = isBuiltinFlag.set(this.field_1_xf_index);
    }

    public StyleRecord(RecordInputStream recordInputStream) {
        this.field_1_xf_index = recordInputStream.readShort();
        if (this.isBuiltin()) {
            this.field_2_builtin_style = recordInputStream.readByte();
            this.field_3_outline_style_level = recordInputStream.readByte();
        } else {
            short s = recordInputStream.readShort();
            if (recordInputStream.remaining() < 1) {
                if (s != 0) {
                    throw new RecordFormatException("Ran out of data reading style record");
                }
                this.field_4_name = "";
            } else {
                this.field_3_stringHasMultibyte = recordInputStream.readByte() != 0;
                this.field_4_name = this.field_3_stringHasMultibyte ? StringUtil.readUnicodeLE(recordInputStream, s) : StringUtil.readCompressedUnicode(recordInputStream, s);
            }
        }
    }

    public void setXFIndex(int n) {
        this.field_1_xf_index = styleIndexMask.setValue(this.field_1_xf_index, n);
    }

    public int getXFIndex() {
        return styleIndexMask.getValue(this.field_1_xf_index);
    }

    public void setName(String string) {
        this.field_4_name = string;
        this.field_3_stringHasMultibyte = StringUtil.hasMultibyte(string);
        this.field_1_xf_index = isBuiltinFlag.clear(this.field_1_xf_index);
    }

    public void setBuiltinStyle(int n) {
        this.field_1_xf_index = isBuiltinFlag.set(this.field_1_xf_index);
        this.field_2_builtin_style = n;
    }

    public void setOutlineStyleLevel(int n) {
        this.field_3_outline_style_level = n & 0xFF;
    }

    public boolean isBuiltin() {
        return isBuiltinFlag.isSet(this.field_1_xf_index);
    }

    public String getName() {
        return this.field_4_name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[STYLE]\n");
        stringBuffer.append("    .xf_index_raw =").append(HexDump.shortToHex(this.field_1_xf_index)).append("\n");
        stringBuffer.append("        .type     =").append(this.isBuiltin() ? "built-in" : "user-defined").append("\n");
        stringBuffer.append("        .xf_index =").append(HexDump.shortToHex(this.getXFIndex())).append("\n");
        if (this.isBuiltin()) {
            stringBuffer.append("    .builtin_style=").append(HexDump.byteToHex(this.field_2_builtin_style)).append("\n");
            stringBuffer.append("    .outline_level=").append(HexDump.byteToHex(this.field_3_outline_style_level)).append("\n");
        } else {
            stringBuffer.append("    .name        =").append(this.getName()).append("\n");
        }
        stringBuffer.append("[/STYLE]\n");
        return stringBuffer.toString();
    }

    protected int getDataSize() {
        if (this.isBuiltin()) {
            return 4;
        }
        return 5 + this.field_4_name.length() * (this.field_3_stringHasMultibyte ? 2 : 1);
    }

    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.field_1_xf_index);
        if (this.isBuiltin()) {
            littleEndianOutput.writeByte(this.field_2_builtin_style);
            littleEndianOutput.writeByte(this.field_3_outline_style_level);
        } else {
            littleEndianOutput.writeShort(this.field_4_name.length());
            littleEndianOutput.writeByte(this.field_3_stringHasMultibyte ? 1 : 0);
            if (this.field_3_stringHasMultibyte) {
                StringUtil.putUnicodeLE(this.getName(), littleEndianOutput);
            } else {
                StringUtil.putCompressedUnicode(this.getName(), littleEndianOutput);
            }
        }
    }

    public short getSid() {
        return 659;
    }
}

